/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.jackson.databind.node;

import java.io.IOException;
import java.io.Serializable;
import me.lib720.jackson.core.JsonGenerator;
import me.lib720.jackson.core.JsonParser;
import me.lib720.jackson.core.JsonToken;
import me.lib720.jackson.core.ObjectCodec;
import me.lib720.jackson.databind.JsonNode;
import me.lib720.jackson.databind.SerializerProvider;
import me.lib720.jackson.databind.jsontype.TypeSerializer;
import me.lib720.jackson.databind.node.InternalNodeMapper;
import me.lib720.jackson.databind.node.MissingNode;
import me.lib720.jackson.databind.node.NodeSerialization;
import me.lib720.jackson.databind.node.TreeTraversingParser;

public abstract class BaseJsonNode
extends JsonNode
implements Serializable {
    private static final long serialVersionUID = 1L;

    Object writeReplace() {
        return NodeSerialization.from(this);
    }

    protected BaseJsonNode() {
    }

    @Override
    public final JsonNode findPath(String fieldName) {
        JsonNode value = this.findValue(fieldName);
        if (value == null) {
            return MissingNode.getInstance();
        }
        return value;
    }

    public abstract int hashCode();

    @Override
    public JsonNode required(String fieldName) {
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no fields", this.getClass().getSimpleName());
    }

    @Override
    public JsonNode required(int index) {
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no indexed values", this.getClass().getSimpleName());
    }

    @Override
    public JsonParser traverse() {
        return new TreeTraversingParser(this);
    }

    @Override
    public JsonParser traverse(ObjectCodec codec) {
        return new TreeTraversingParser(this, codec);
    }

    @Override
    public abstract JsonToken asToken();

    @Override
    public JsonParser.NumberType numberType() {
        return null;
    }

    @Override
    public abstract void serialize(JsonGenerator var1, SerializerProvider var2) throws IOException;

    @Override
    public abstract void serializeWithType(JsonGenerator var1, SerializerProvider var2, TypeSerializer var3) throws IOException;

    @Override
    public String toString() {
        return InternalNodeMapper.nodeToString(this);
    }

    @Override
    public String toPrettyString() {
        return InternalNodeMapper.nodeToPrettyString(this);
    }
}

