/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.mpatric.mp3agic;

import java.io.UnsupportedEncodingException;
import me.lib720.mpatric.mp3agic.AbstractID3v2FrameData;
import me.lib720.mpatric.mp3agic.BufferTools;
import me.lib720.mpatric.mp3agic.EncodedText;
import me.lib720.mpatric.mp3agic.InvalidDataException;

public class ID3v2UrlFrameData
extends AbstractID3v2FrameData {
    protected String url;
    protected EncodedText description;

    public ID3v2UrlFrameData(boolean bl) {
        super(bl);
    }

    public ID3v2UrlFrameData(boolean bl, EncodedText encodedText, String string) {
        super(bl);
        this.description = encodedText;
        this.url = string;
    }

    public ID3v2UrlFrameData(boolean bl, byte[] byArray) throws InvalidDataException {
        super(bl);
        this.synchroniseAndUnpackFrameData(byArray);
    }

    @Override
    protected void unpackFrameData(byte[] byArray) throws InvalidDataException {
        int n = BufferTools.indexOfTerminatorForEncoding(byArray, 1, byArray[0]);
        if (n >= 0) {
            this.description = new EncodedText(byArray[0], BufferTools.copyBuffer(byArray, 1, n - 1));
            n += this.description.getTerminator().length;
        } else {
            this.description = new EncodedText(byArray[0], "");
            n = 1;
        }
        try {
            this.url = BufferTools.byteBufferToString(byArray, n, byArray.length - n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.url = "";
        }
    }

    @Override
    protected byte[] packFrameData() {
        byte[] byArray = new byte[this.getLength()];
        byArray[0] = this.description != null ? this.description.getTextEncoding() : (byte)0;
        int n = 1;
        if (this.description != null) {
            byte[] byArray2 = this.description.toBytes(true, true);
            BufferTools.copyIntoByteBuffer(byArray2, 0, byArray2.length, byArray, n);
            n += byArray2.length;
        } else {
            byArray[n++] = 0;
        }
        if (this.url != null && this.url.length() > 0) {
            try {
                BufferTools.stringIntoByteBuffer(this.url, 0, this.url.length(), byArray, n);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return byArray;
    }

    @Override
    protected int getLength() {
        int n = 1;
        n = this.description != null ? (n += this.description.toBytes(true, true).length) : ++n;
        if (this.url != null) {
            n += this.url.length();
        }
        return n;
    }

    public EncodedText getDescription() {
        return this.description;
    }

    public void setDescription(EncodedText encodedText) {
        this.description = encodedText;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.description == null ? 0 : this.description.hashCode());
        n = 31 * n + (this.url == null ? 0 : this.url.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ID3v2UrlFrameData iD3v2UrlFrameData = (ID3v2UrlFrameData)object;
        if (this.description == null ? iD3v2UrlFrameData.description != null : !this.description.equals(iD3v2UrlFrameData.description)) {
            return false;
        }
        return !(this.url == null ? iD3v2UrlFrameData.url != null : !this.url.equals(iD3v2UrlFrameData.url));
    }
}

