/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sun.jna.Platform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import me.lib720.caprica.vlcj.binding.support.runtime.RuntimeUtil;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.external.GifDecoder;
import me.srrapero720.watermedia.api.external.ThreadUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Util {
    private static final Marker IT = MarkerFactory.getMarker((String)"Util");
    public static final OsArch ARCH = Util.getOsArch();
    private static final Thread THREAD = Thread.currentThread();

    public static <T> Field getClassField(Class<? super T> from, String name) {
        try {
            Field f = from.getDeclaredField(name);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to locate field " + from.getSimpleName() + "." + name, e);
        }
    }

    public static InputStream resourceAsStream(String path, ClassLoader classLoader) {
        InputStream stream = classLoader.getResourceAsStream(path);
        if (stream == null && path.startsWith("/")) {
            stream = classLoader.getResourceAsStream(path);
        }
        return stream;
    }

    public static InputStream resourceAsStream(String path) {
        return Util.resourceAsStream(path, Util.class.getClassLoader());
    }

    public static String[] getArrayStringFromRes(String path) {
        return Util.getJsonListFromRes(path).toArray(new String[0]);
    }

    public static List<String> getJsonListFromRes(String path) {
        ArrayList<String> result;
        block16: {
            result = new ArrayList<String>();
            try (InputStream stream = Util.resourceAsStream(path);
                 BufferedReader reader = stream != null ? new BufferedReader(new InputStreamReader(stream)) : null;){
                if (reader != null) {
                    result.addAll((Collection)new Gson().fromJson((Reader)reader, new TypeToken<List<String>>(){}.getType()));
                    break block16;
                }
                throw new IllegalArgumentException("File not found!");
            }
            catch (Exception e) {
                WaterMedia.LOGGER.error(IT, "### Exception trying to read JSON from {}", (Object)path);
                if (WaterMedia.LOGGER.isDebugEnabled()) {
                    WaterMedia.LOGGER.debug(IT, "### Information", (Throwable)e);
                }
                WaterMedia.LOGGER.error("### Information", (Throwable)e);
            }
        }
        return result;
    }

    public static List<String> getJsonListFromRes(String path, ClassLoader classLoader) {
        ArrayList<String> result;
        block15: {
            result = new ArrayList<String>();
            try (InputStream stream = Util.resourceAsStream(path, classLoader);
                 BufferedReader reader = stream != null ? new BufferedReader(new InputStreamReader(stream)) : null;){
                if (reader != null) {
                    result.addAll((Collection)new Gson().fromJson((Reader)reader, new TypeToken<List<String>>(){}.getType()));
                    break block15;
                }
                throw new IllegalArgumentException("File not found!");
            }
            catch (Exception e) {
                WaterMedia.LOGGER.error(IT, "Exception trying to read JSON from {}", (Object)path, (Object)e);
            }
        }
        return result;
    }

    public static void extractFrom(String originPath, String destinationPath) {
        block10: {
            try (InputStream is = Util.resourceAsStream(originPath);){
                Path dllDestinationPath = Paths.get(destinationPath, new String[0]);
                if (is != null) {
                    Files.createDirectories(dllDestinationPath.getParent(), new FileAttribute[0]);
                    Files.copy(is, dllDestinationPath, new CopyOption[0]);
                    break block10;
                }
                throw new RuntimeException("Resource was not found in " + originPath);
            }
            catch (Exception e) {
                WaterMedia.LOGGER.error(IT, "### Failed to extract from {} to {} due to unexpected error", (Object)originPath, (Object)destinationPath);
                if (WaterMedia.LOGGER.isDebugEnabled()) {
                    WaterMedia.LOGGER.debug(IT, "### Information", (Throwable)e);
                }
                WaterMedia.LOGGER.error("### Information", (Throwable)e);
            }
        }
    }

    public static void deleteFrom(String destinationPath) {
        try {
            Path path = Paths.get(destinationPath, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)path.toFile());
            }
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Failed to delete from {} due to unexpected error", (Object)destinationPath, (Object)e);
        }
    }

    public static String readFrom(Path path) {
        return ThreadUtil.tryAndReturn(defaultVar -> Files.exists(path, new LinkOption[0]) ? Files.readString(path) : defaultVar, null);
    }

    public static Map<String, String> parseQuery(String query) {
        String[] params;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (String param : params = query.split("&")) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            String value = keyValue[1];
            queryParams.put(key, value);
        }
        return queryParams;
    }

    private static OsArch getOsArch() {
        String arch;
        switch (arch = Platform.ARCH) {
            case "amd64": 
            case "x86-64": {
                if (RuntimeUtil.isWindows()) {
                    return OsArch.WIN_X64;
                }
                if (RuntimeUtil.isMac()) {
                    return OsArch.MAC_X64;
                }
                if (!RuntimeUtil.isNix()) break;
                return OsArch.NIX_X64;
            }
            case "arm64": {
                if (RuntimeUtil.isWindows()) {
                    return OsArch.WIN_ARM64;
                }
                if (RuntimeUtil.isMac()) {
                    return OsArch.MAC_ARM64;
                }
                if (!RuntimeUtil.isNix()) break;
                return OsArch.NIX_ARM64;
            }
            case "arm": 
            case "armel": {
                if (RuntimeUtil.isWindows()) {
                    return OsArch.WIN_ARM;
                }
                if (RuntimeUtil.isMac()) {
                    return OsArch.MAC_ARM;
                }
                if (!RuntimeUtil.isNix()) break;
                return OsArch.NIX_ARM;
            }
            case "x86": {
                if (!RuntimeUtil.isWindows()) break;
                return OsArch.WIN_X32;
            }
            default: {
                return OsArch.DUMMY;
            }
        }
        throw new RuntimeException("\u00bfHow did you get here?");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage getImageFromResources(String path) {
        try (InputStream in = Util.resourceAsStream(path);){
            BufferedImage image = ImageIO.read(in);
            if (image == null) throw new NullPointerException("Image read from WaterMedia resources was NULL");
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed loading BufferedImage from WaterMedia resources", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GifDecoder getGifFromResources(String path) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)Util.resourceAsStream(path)));){
            GifDecoder gif = new GifDecoder();
            int status = gif.read(in);
            if (status == 0) {
                GifDecoder gifDecoder = gif;
                return gifDecoder;
            }
            WaterMedia.LOGGER.error(IT, "Exception reading Gif from {}", (Object)path);
            throw new IOException("Failed to read/process gif, status code " + status);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed loading gif from WaterMedia resources", e);
        }
    }

    public static boolean integrityCheck(String source, File targetFile) {
        boolean bl;
        block9: {
            InputStream sourceStream = Util.resourceAsStream(source);
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] sourceDigest = Util.calculateDigest(sourceStream, md);
                byte[] targetDigest = Util.calculateDigest(new FileInputStream(targetFile), md);
                if (!MessageDigest.isEqual(sourceDigest, targetDigest)) {
                    throw new RuntimeException("File no match with the stored one");
                }
                bl = true;
                if (sourceStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (sourceStream != null) {
                        try {
                            sourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    WaterMedia.LOGGER.error(IT, "Integrity check failed, exception occurred on file '{}'", (Object)targetFile.toPath(), (Object)e);
                    return false;
                }
            }
            sourceStream.close();
        }
        return bl;
    }

    private static byte[] calculateDigest(InputStream inputStream, MessageDigest md) throws IOException {
        byte[] byArray;
        DigestInputStream dis = new DigestInputStream(inputStream, md);
        try {
            byte[] buffer = new byte[8192];
            while (dis.read(buffer) != -1) {
            }
            dis.close();
            byArray = md.digest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IOException("Failed calculating digest", e);
            }
        }
        dis.close();
        return byArray;
    }

    public static void checkIfCurrentThreadHaveClassLoader() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(THREAD.getContextClassLoader());
        }
    }

    public static String getUserAgentBasedOnOS() {
        return "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36 Edg/112.0.1722.68";
    }

    public static enum OsArch {
        WIN_X32("win", "x32", ".dll", false),
        WIN_X64("win", "x64", ".dll", true),
        MAC_X64("mac", "x64", ".dylib", false),
        NIX_X64("nix", "x64", ".os", false),
        WIN_ARM64("win", "arm64", ".dll", false),
        MAC_ARM64("mac", "arm64", ".dylib", false),
        NIX_ARM64("nix", "arm64", ".os", false),
        WIN_ARM("win", "arm", ".dll", false),
        MAC_ARM("mac", "arm", ".dylib", false),
        NIX_ARM("nix", "arm", ".os", false),
        DUMMY("dummy", "dummy", ".dummy", false);

        public final String OS;
        public final String ARCH;
        public final String EXT;
        public final boolean wrapped;

        private OsArch(String os, String arch, String ext, boolean isWrapped) {
            this.OS = os;
            this.ARCH = arch;
            this.EXT = ext;
            this.wrapped = isWrapped;
        }

        public String toString() {
            return this.OS + "-" + this.ARCH;
        }
    }
}

