/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.factory.discovery.NativeDiscovery;
import me.lib720.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import me.srrapero720.watermedia.Util;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.external.ThreadUtil;
import me.srrapero720.watermedia.api.images.RenderablePicture;
import me.srrapero720.watermedia.api.url.URLPatch;
import me.srrapero720.watermedia.api.url.patch.DrivePatch;
import me.srrapero720.watermedia.api.url.patch.DropboxPatch;
import me.srrapero720.watermedia.api.url.patch.KickPatch;
import me.srrapero720.watermedia.api.url.patch.OnedrivePatch;
import me.srrapero720.watermedia.api.url.patch.TwitchPatch;
import me.srrapero720.watermedia.api.url.patch.TwitterPatch;
import me.srrapero720.watermedia.api.url.patch.YoutubePatch;
import me.srrapero720.watermedia.core.videolan.VideoLAN;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Deprecated
public final class WaterMediaAPI {
    private static final Marker IT = MarkerFactory.getMarker((String)"WaterMediaAPI");
    public static final RenderablePicture LOADING_GIF = new RenderablePicture(Util.getGifFromResources("/images/loading.gif"));
    public static final RenderablePicture VLC_FAILED = new RenderablePicture(Util.getImageFromResources("/images/vlc/vlc_failed.png"));
    public static final RenderablePicture VLC_FAILED_INSTALL = new RenderablePicture(Util.getImageFromResources("/images/vlc/vlc_failed_install.png"));
    private static final NativeDiscovery DISCOVERY = new NativeDiscovery(new NativeDiscoveryStrategy[0]);
    private static final List<URLPatch> URL_PATCHERS = new ArrayList<DropboxPatch>(List.of(new YoutubePatch(), new TwitchPatch(), new KickPatch(), new DrivePatch(), new TwitterPatch(), new OnedrivePatch(), new DropboxPatch()));

    public static long gameTicksToMs(int ticks) {
        return (long)ticks * 50L;
    }

    public static int msToGameTicks(long ms) {
        return (int)(ms / 50L);
    }

    public static boolean isURLValid(String url) {
        return ThreadUtil.tryAndReturn(defaultVar -> {
            new URL(url);
            return true;
        }, false);
    }

    public static void registerURLPatch(URLPatch ... patch) {
        for (URLPatch p : patch) {
            WaterMedia.LOGGER.warn(IT, "Registered new URLPatch: {}", (Object)p.getClass().getSimpleName());
            URL_PATCHERS.add(p);
        }
    }

    public static String urlPatch(String urlStr) {
        return ThreadUtil.tryAndReturn(defaultVar -> {
            URL url = new URL(urlStr);
            for (URLPatch compat : URL_PATCHERS) {
                if (!compat.isValid(url)) continue;
                return compat.patch(url);
            }
            return defaultVar;
        }, e -> WaterMedia.LOGGER.error(IT, "Exception running urlPatch({}): {}", (Object)urlStr, (Object)e.getMessage()), urlStr);
    }

    public static MediaPlayerFactory createVLCFactory(String[] vlcArgs) {
        if (DISCOVERY.discover()) {
            MediaPlayerFactory factory = new MediaPlayerFactory(DISCOVERY, vlcArgs);
            WaterMedia.LOGGER.info(IT, "New instance of VLC loaded from '{}' with the next args:\n{}", (Object)DISCOVERY.discoveredPath(), (Object)Arrays.toString(vlcArgs));
            Runtime.getRuntime().addShutdownHook(new Thread(factory::release));
            return factory;
        }
        WaterMedia.LOGGER.error(IT, "VLC was not found on your system.");
        return null;
    }

    public static MediaPlayerFactory getVLCFactory() {
        return VideoLAN.factory();
    }

    public static boolean isVLCReady() {
        return VideoLAN.factory() != null;
    }

    public static int preRender(BufferedImage image, int width, int height) {
        int[] pixels = new int[width * height];
        image.getRGB(0, 0, width, height, pixels, 0, width);
        boolean alpha = false;
        if (image.getColorModel().hasAlpha()) {
            for (int pixel : pixels) {
                if ((pixel >> 24 & 0xFF) >= 255) continue;
                alpha = true;
                break;
            }
        }
        int bytesPerPixel = alpha ? 4 : 3;
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * bytesPerPixel));
        for (int pixel : pixels) {
            buffer.put((byte)(pixel >> 16 & 0xFF));
            buffer.put((byte)(pixel >> 8 & 0xFF));
            buffer.put((byte)(pixel & 0xFF));
            if (!alpha) continue;
            buffer.put((byte)(pixel >> 24 & 0xFF));
        }
        buffer.flip();
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        if (!alpha) {
            GL11.glPixelStorei((int)3317, (int)1);
        }
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glTexImage2D((int)3553, (int)0, (int)(alpha ? 32856 : 32849), (int)width, (int)height, (int)0, (int)(alpha ? 6408 : 6407), (int)5121, (ByteBuffer)buffer);
        return textureID;
    }
}

