/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.external;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ThreadUtil {
    private static int workers = 0;
    private static Thread THREADLG = null;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ThreadUtil");
    private static final Thread.UncaughtExceptionHandler EXCEPTION_HANDLER = (t, e) -> System.out.println("Fatal exception on ThreadUtils - " + String.valueOf(e));

    public static void printStackTrace(Exception e) {
        e.printStackTrace();
    }

    public static <T> T tryAndReturnNull(ReturnableRunnable<T> runnable, CatchRunnable catchRunnable) {
        return ThreadUtil.tryAndReturn(defaultVar1 -> runnable.run(null), catchRunnable, null);
    }

    public static <T> T tryAndReturn(ReturnableRunnable<T> runnable, T defaultVar) {
        return ThreadUtil.tryAndReturn(runnable, null, defaultVar);
    }

    public static <T> T tryAndReturn(ReturnableRunnable<T> runnable, @Nullable CatchRunnable catchRunnable, T defaultVar) {
        return ThreadUtil.tryAndReturn(runnable, catchRunnable, null, defaultVar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T tryAndReturn(ReturnableRunnable<T> runnable, @Nullable CatchRunnable catchRunnable, @Nullable ReturnableFinallyRunnable<T> finallyRunnable, T defaultVar) {
        T returned = defaultVar;
        try {
            returned = runnable.run(defaultVar);
            T t = returned;
            return t;
        }
        catch (Exception exception) {
            if (catchRunnable != null) {
                catchRunnable.run(exception);
            }
            T t = defaultVar;
            return t;
        }
        finally {
            if (finallyRunnable != null) {
                finallyRunnable.run(returned);
            }
        }
    }

    public static void trySimple(SimpleTryRunnable runnable) {
        ThreadUtil.trySimple(runnable, null, null);
    }

    public static void trySimple(SimpleTryRunnable runnable, CatchRunnable catchRunnable) {
        ThreadUtil.trySimple(runnable, catchRunnable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trySimple(SimpleTryRunnable runnable, CatchRunnable catchRunnable, FinallyRunnable finallyRunnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            if (catchRunnable != null) {
                catchRunnable.run(e);
            }
        }
        finally {
            if (finallyRunnable != null) {
                finallyRunnable.run();
            }
        }
    }

    public static Thread threadTryWithLowPrior(TryRunnable toTry) {
        Thread thread = new Thread(() -> {
            try {
                toTry.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        thread.setName("WCoRE-worker-" + ++workers);
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.setUncaughtExceptionHandler(EXCEPTION_HANDLER);
        thread.start();
        return thread;
    }

    public static void threadTry(@NotNull TryRunnable toTry, @Nullable CatchRunnable toCatch, @Nullable FinallyRunnable toFinally) {
        ThreadUtil.threadTryArgument(null, object -> toTry.run(), toCatch, object -> {
            if (toFinally != null) {
                toFinally.run();
            }
        });
    }

    public static void threadNonDaeomTry(@NotNull TryRunnable toTry, @Nullable CatchRunnable toCatch, @Nullable FinallyRunnable toFinally) {
        ThreadUtil.threadTryArgument(null, object -> toTry.run(), toCatch, object -> {
            if (toFinally != null) {
                toFinally.run();
            }
        });
    }

    public static Thread thread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName("WCoRE-worker-" + ++workers);
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(EXCEPTION_HANDLER);
        thread.start();
        return thread;
    }

    public static Thread threadNonDaemon(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName("WATERCoRE-" + ++workers);
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        thread.setDaemon(false);
        thread.setUncaughtExceptionHandler(EXCEPTION_HANDLER);
        thread.start();
        return thread;
    }

    public static <T> void threadTryArgument(T object, TryRunnableWithArgument<T> toTry, @Nullable CatchRunnable toCatch, @Nullable FinallyRunnableWithArgument<T> toFinally) {
        ThreadUtil.thread(() -> {
            try {
                toTry.run(object);
            }
            catch (Exception e) {
                if (toCatch != null) {
                    toCatch.run(e);
                }
            }
            finally {
                if (toFinally != null) {
                    toFinally.run(object);
                }
            }
        });
    }

    public static <T> void threadNonDaemonTryArgument(T object, TryRunnableWithArgument<T> toTry, @Nullable CatchRunnable toCatch, @Nullable FinallyRunnableWithArgument<T> toFinally) {
        ThreadUtil.threadNonDaemon(() -> {
            try {
                toTry.run(object);
            }
            catch (Exception e) {
                if (toCatch != null) {
                    toCatch.run(e);
                }
            }
            finally {
                if (toFinally != null) {
                    toFinally.run(object);
                }
            }
        });
    }

    public static void threadLogger() {
        ThreadUtil.threadLoggerKill();
        THREADLG = ThreadUtil.thread(() -> {
            do {
                ThreadUtil.trySimple(ThreadUtil::showThreads);
                ThreadUtil.trySimple(() -> Thread.sleep(2000L));
            } while (THREADLG != null);
            throw new IllegalStateException("Thread logger was lost");
        });
    }

    public static void threadLoggerKill() {
        ThreadUtil.trySimple(() -> {
            if (ThreadUtil.threadLoggerEnabled()) {
                THREADLG.interrupt();
            }
            THREADLG = null;
            System.gc();
        });
    }

    public static boolean threadLoggerEnabled() {
        return THREADLG != null && !THREADLG.isInterrupted();
    }

    public static void showThreads() {
        LOGGER.info("{}\t{}\t{}\t{}\n", new Object[]{"Name", "State", "Priority", "isDaemon"});
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            LOGGER.info("{}\t{}\t{}\t{}\n", new Object[]{t.getName(), t.getState(), t.getPriority(), t.isDaemon()});
        }
    }

    public static interface ReturnableRunnable<T> {
        public T run(T var1) throws Exception;
    }

    public static interface CatchRunnable {
        public void run(Exception var1);
    }

    public static interface ReturnableFinallyRunnable<T> {
        public void run(@NotNull T var1);
    }

    public static interface SimpleTryRunnable {
        public void run() throws Exception;
    }

    public static interface FinallyRunnable {
        public void run();
    }

    public static interface TryRunnable {
        public void run() throws Exception;
    }

    public static interface TryRunnableWithArgument<T> {
        public void run(T var1) throws Exception;
    }

    public static interface FinallyRunnableWithArgument<T> {
        public void run(T var1);
    }
}

