/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.images;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import me.srrapero720.watermedia.WaterMedia;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LocalStorage {
    private static final Marker IT = MarkerFactory.getMarker((String)LocalStorage.class.getSimpleName());
    private static final Map<String, Entry> entries = new HashMap<String, Entry>();
    private static File dir;
    private static File index;

    public static boolean init(Path rootDir) {
        if (dir != null && index != null) {
            WaterMedia.LOGGER.error(IT, "Rejected attempt to reload LocalStorage" + (rootDir.toAbsolutePath().resolve("cache/pictures").equals(dir.toPath()) ? "with a different path" : ""));
            return true;
        }
        WaterMedia.LOGGER.info(IT, "Storage path used for logs and binaries '{}'", (Object)rootDir);
        dir = rootDir.toAbsolutePath().resolve("cache/pictures").toFile();
        index = new File(dir, "indexer");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (index.exists()) {
            boolean bl;
            DataInputStream stream = new DataInputStream(new GZIPInputStream(new FileInputStream(index)));
            try {
                int length = stream.readInt();
                for (int i = 0; i < length; ++i) {
                    String url = stream.readUTF();
                    String tag = stream.readUTF();
                    long time = stream.readLong();
                    long expireTime = stream.readLong();
                    Entry entry = new Entry(url, tag.length() > 0 ? tag : null, time, expireTime);
                    entries.put(entry.getUrl(), entry);
                }
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    WaterMedia.LOGGER.error(IT, "Failed to load indexes", (Throwable)e);
                    return false;
                }
            }
            stream.close();
            return bl;
        }
        return true;
    }

    public static File getFile(String url) {
        return new File(dir, Base64.encodeBase64String((byte[])url.getBytes()).replace("\\", "--").replace("/", "--"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(String url, String tag, long time, long expireTime, byte[] data) {
        Entry entry = new Entry(url, tag, time, expireTime);
        boolean saved = false;
        OutputStream out = null;
        File file = LocalStorage.getFile(entry.url);
        try {
            out = new FileOutputStream(file);
            out.write(data);
            saved = true;
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Failed to save cache file {}", (Object)url, (Object)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        if (saved && LocalStorage.refreshAllIndexOnFile()) {
            entries.put(url, entry);
        } else if (file.exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean refreshAllIndexOnFile() {
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(index)));
            out.writeInt(entries.size());
            for (Map.Entry<String, Entry> mapEntry : entries.entrySet()) {
                Entry entry = mapEntry.getValue();
                out.writeUTF(entry.getUrl());
                out.writeUTF(entry.getTag() == null ? "" : entry.getTag());
                out.writeLong(entry.getTime());
                out.writeLong(entry.getExpireTime());
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            WaterMedia.LOGGER.error(IT, "Failed to save cache index", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public static Entry getEntry(String url) {
        return entries.get(url);
    }

    public static void updateEntry(Entry fresh) {
        entries.put(fresh.url, fresh);
    }

    public static void deleteEntry(String url) {
        entries.remove(url);
        File file = LocalStorage.getFile(url);
        if (file.exists()) {
            file.delete();
        }
    }

    public static final class Entry {
        private final String url;
        private String tag;
        private long time;
        private long expireTime;

        public Entry(String url, String tag, long time, long expireTime) {
            this.url = url;
            this.tag = tag;
            this.time = time;
            this.expireTime = expireTime;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setExpireTime(long expireTime) {
            this.expireTime = expireTime;
        }

        public String getUrl() {
            return this.url;
        }

        public String getTag() {
            return this.tag;
        }

        public long getTime() {
            return this.time;
        }

        public long getExpireTime() {
            return this.expireTime;
        }
    }
}

