/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.images;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import me.srrapero720.watermedia.Util;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.api.external.GifDecoder;
import me.srrapero720.watermedia.api.images.LocalStorage;
import me.srrapero720.watermedia.api.images.RenderablePicture;
import org.apache.commons.io.IOUtils;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class PictureFetcher
extends Thread {
    private static final Marker IT = MarkerFactory.getMarker((String)"FetchPicture");
    private static final Object LOCK = new Object();
    private static final String USER_AGENT = Util.getUserAgentBasedOnOS();
    private static final DateFormat FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    public static final int MAX_FETCH = 6;
    public static final AtomicInteger ACTIVE_FETCH = new AtomicInteger(0);
    private final String originalURL;

    public PictureFetcher(String originalURL) {
        this.originalURL = originalURL;
        this.setName("WaterMedia-Picture");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canSeek() {
        Object object = LOCK;
        synchronized (object) {
            return ACTIVE_FETCH.get() < 6;
        }
    }

    public abstract void onFailed(Exception var1);

    public abstract void onSuccess(RenderablePicture var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AtomicInteger atomicInteger;
        block19: {
            atomicInteger = ACTIVE_FETCH;
            synchronized (atomicInteger) {
                ACTIVE_FETCH.incrementAndGet();
            }
            try {
                String url = WaterMediaAPI.urlPatch(this.originalURL);
                byte[] data = PictureFetcher.load(url);
                String type = PictureFetcher.readType(data);
                try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
                    if (type != null && type.equalsIgnoreCase("gif")) {
                        GifDecoder gif = new GifDecoder();
                        int status = gif.read(in);
                        if (status == 0) {
                            this.onSuccess(new RenderablePicture(gif));
                            break block19;
                        }
                        WaterMedia.LOGGER.error(IT, "Failed to read gif: {}", (Object)status);
                        throw new GifDecodingException();
                    }
                    try {
                        BufferedImage image = ImageIO.read(in);
                        if (image != null) {
                            this.onSuccess(new RenderablePicture(image));
                        }
                    }
                    catch (IOException e1) {
                        WaterMedia.LOGGER.error(IT, "Failed to parse BufferedImage from stream", (Throwable)e1);
                        throw e1;
                    }
                }
            }
            catch (Exception e) {
                if (!(e instanceof VideoContentException)) {
                    WaterMedia.LOGGER.error(IT, "An exception occurred while loading Waterframes image", (Throwable)e);
                }
                this.onFailed(e);
                LocalStorage.deleteEntry(this.originalURL);
            }
        }
        atomicInteger = ACTIVE_FETCH;
        synchronized (atomicInteger) {
            ACTIVE_FETCH.decrementAndGet();
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] load(String url) throws IOException, VideoContentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String readType(byte[] input) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(input);){
            String string = PictureFetcher.readType(in);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readType(InputStream input) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(stream);
        if (!iterator.hasNext()) {
            return null;
        }
        ImageReader reader = iterator.next();
        if (reader.getFormatName().equalsIgnoreCase("gif")) {
            return "gif";
        }
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        try {
            reader.read(0, param);
        }
        catch (IOException e) {
            WaterMedia.LOGGER.error(IT, "Failed to parse input format", (Throwable)e);
        }
        finally {
            reader.dispose();
            IOUtils.closeQuietly((Closeable)stream);
        }
        input.reset();
        return reader.getFormatName();
    }

    private static /* synthetic */ Long lambda$load$2(String lastMod, Long defaultVar) throws Exception {
        return FORMAT.parse(lastMod).getTime();
    }

    private static /* synthetic */ Long lambda$load$1(String expires, Long defaultVar) throws Exception {
        return FORMAT.parse(expires).getTime();
    }

    private static /* synthetic */ Long lambda$load$0(long requestTime, String maxAge, Long defaultVar) throws Exception {
        return requestTime + Long.parseLong(maxAge) * 1000L;
    }

    public static final class GifDecodingException
    extends IOException {
    }

    public static final class VideoContentException
    extends Exception {
    }
}

