/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.images;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.api.external.GifDecoder;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class RenderablePicture {
    public final int width;
    public final int height;
    public final int[] textures;
    public final long[] delay;
    public final long duration;
    public final BufferedImage image;
    public GifDecoder decoder;
    public int remaining;

    public RenderablePicture(@NotNull BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.textures = new int[]{-1};
        this.delay = new long[]{0L};
        this.remaining = 1;
        this.duration = 0L;
        this.decoder = null;
        this.image = image;
    }

    public RenderablePicture(@NotNull GifDecoder decoder) {
        Dimension frameSize = decoder.getFrameSize();
        this.width = (int)frameSize.getWidth();
        this.height = (int)frameSize.getHeight();
        this.textures = new int[decoder.getFrameCount()];
        this.delay = new long[decoder.getFrameCount()];
        this.decoder = decoder;
        this.image = null;
        this.remaining = decoder.getFrameCount();
        long time = 0L;
        for (int i = 0; i < decoder.getFrameCount(); ++i) {
            this.textures[i] = -1;
            this.delay[i] = time;
            time += (long)decoder.getDelay(i);
        }
        this.duration = time;
    }

    public int genTexture(long time) {
        if (this.textures == null) {
            return -1;
        }
        if (this.textures.length == 1) {
            return this.genTexture(0);
        }
        int last = this.genTexture(0);
        for (int i = 1; i < this.delay.length && this.delay[i] <= time; ++i) {
            last = this.genTexture(i);
        }
        return last;
    }

    public int genTexture(int index) {
        if (this.textures[index] == -1 && this.decoder != null) {
            this.textures[index] = WaterMediaAPI.preRender(this.decoder.getFrame(index), this.width, this.height);
            --this.remaining;
            if (this.remaining <= 0) {
                this.decoder = null;
            }
        } else if (this.textures[index] == -1 && this.image != null) {
            this.textures[index] = WaterMediaAPI.preRender(this.image, this.width, this.height);
            --this.remaining;
        }
        return this.textures[index];
    }

    public synchronized void flush() {
        if (this.image != null) {
            this.image.flush();
        }
        if (this.decoder != null) {
            for (int i = 0; i < this.decoder.getFrameCount(); ++i) {
                this.decoder.getFrame(i).flush();
            }
        }
        Arrays.fill(this.textures, -1);
    }

    public synchronized void release() {
        GL11.glDeleteTextures((int[])this.textures);
        this.flush();
    }
}

