/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.patch;

import java.net.URL;
import me.lib720.retrofit2.Call;
import me.lib720.retrofit2.Response;
import me.srrapero720.watermedia.api.url.URLPatch;
import me.srrapero720.watermedia.api.url.patch.util.kick.KickAPI;
import me.srrapero720.watermedia.api.url.patch.util.kick.models.KickChannel;
import me.srrapero720.watermedia.api.url.patch.util.kick.models.KickVideo;
import org.jetbrains.annotations.NotNull;

public class KickPatch
extends URLPatch {
    @Override
    public boolean isValid(@NotNull URL url) {
        return url.getHost().contains("kick.com");
    }

    @Override
    public String patch(@NotNull URL url) throws URLPatch.PatchingUrlException {
        block7: {
            super.patch(url);
            if (url.getPath().contains("/video/")) {
                Call<KickVideo> call = KickAPI.NET.getVideoInfo(url.getPath().replace("/video/", ""));
                try {
                    Response<KickVideo> res = call.execute();
                    if (res.isSuccessful() && res.body() != null) {
                        return res.body().url;
                    }
                    break block7;
                }
                catch (Exception e) {
                    throw new URLPatch.PatchingUrlException(url.toString(), (Throwable)e);
                }
            }
            Call<KickChannel> call = KickAPI.NET.getChannelInfo(url.getPath().replace("/", ""));
            try {
                Response<KickChannel> res = call.execute();
                if (res.isSuccessful() && res.body() != null) {
                    return res.body().url;
                }
            }
            catch (Exception e) {
                throw new URLPatch.PatchingUrlException(url.toString(), (Throwable)e);
            }
        }
        return null;
    }
}

