/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;

public final class ClientUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ResourceLocation DUMMY_TEXTURE = new ResourceLocation("forge", "white");
    public static final Supplier<Boolean> OPTIFINE_LOADED = Suppliers.memoize(() -> {
        try {
            Class.forName("net.optifine.Config");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    });
    private static final List<ClientTask> tasks = new ArrayList<ClientTask>();
    private static ResourceKey<Level> lastDimension = null;

    public static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen, @Nullable List<Property<?>> ignoredProps) {
        ClientUtils.replaceModels(block, models, blockModelGen, null, ignoredProps);
    }

    public static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen, @Nullable BlockState itemModelSource, @Nullable List<Property<?>> ignoredProps) {
        ClientUtils.replaceModelsSpecial(block, models, blockModelGen, itemModelSource, testState -> ClientUtils.ignoreProps(testState, ignoredProps));
    }

    public static void replaceModelsSpecial(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen, Function<BlockState, BlockState> stateMerger) {
        ClientUtils.replaceModelsSpecial(block, models, blockModelGen, null, stateMerger);
    }

    public static void replaceModelsSpecial(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen, @Nullable BlockState itemModelSource, Function<BlockState, BlockState> stateMerger) {
        HashMap<BlockState, BakedModel> visitedStates = new HashMap<BlockState, BakedModel>();
        for (BlockState state : ((Block)block.get()).m_49965_().m_61056_()) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)state);
            BakedModel baseModel = models.get(location);
            BakedModel replacement = visitedStates.computeIfAbsent(stateMerger.apply(state), key -> (BakedModel)blockModelGen.apply((BlockState)key, baseModel));
            models.put((ResourceLocation)location, replacement);
        }
        if (itemModelSource != null) {
            ModelResourceLocation location = new ModelResourceLocation(block.getId(), "inventory");
            BakedModel replacement = models.get(BlockModelShaper.m_110895_((BlockState)itemModelSource));
            models.put((ResourceLocation)location, replacement);
        }
    }

    public static void reuseModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, RegistryObject<Block> sourceBlock, @Nullable List<Property<?>> ignoredProps) {
        for (BlockState state : ((Block)block.get()).m_49965_().m_61056_()) {
            BlockState sourceState = ((Block)sourceBlock.get()).m_49966_();
            for (Property prop : state.m_61147_()) {
                if (sourceState.m_61138_(prop)) {
                    sourceState = (BlockState)sourceState.m_61124_(prop, state.m_61143_(prop));
                    continue;
                }
                if (ignoredProps == null || ignoredProps.contains(prop)) continue;
                LOGGER.warn("Found invalid ignored property {} for block {}!", (Object)prop, (Object)sourceState.m_60734_());
            }
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)state);
            ModelResourceLocation sourceLocation = BlockModelShaper.m_110895_((BlockState)sourceState);
            models.put((ResourceLocation)location, models.get(sourceLocation));
        }
    }

    private static BlockState ignoreProps(BlockState state, @Nullable List<Property<?>> ignoredProps) {
        ArrayList<Object> props = new ArrayList<Object>();
        props.add(FramedProperties.GLOWING);
        if (ignoredProps != null) {
            props.addAll(ignoredProps);
        }
        BlockState defaultState = state.m_60734_().m_49966_();
        for (Property property : props) {
            if (!state.m_61138_(property)) {
                LOGGER.warn("Found invalid ignored property {} for block {}!", (Object)property, (Object)state.m_60734_());
                continue;
            }
            state = (BlockState)state.m_61124_(property, defaultState.m_61143_(property));
        }
        return state;
    }

    public static BlockEntity getBlockEntitySafe(BlockGetter blockGetter, BlockPos pos) {
        if (blockGetter instanceof RenderChunkRegion) {
            RenderChunkRegion renderChunk = (RenderChunkRegion)blockGetter;
            return renderChunk.m_7702_(pos);
        }
        return null;
    }

    public static void enqueueClientTask(Runnable task) {
        Minecraft.m_91087_().m_6937_(task);
    }

    public static int getBlockColor(BlockAndTintGetter level, BlockPos pos, BlockState state, int tintIdx) {
        return Minecraft.m_91087_().m_91298_().m_92577_(state, level, pos, tintIdx);
    }

    public static int getFluidColor(BlockAndTintGetter level, BlockPos pos, FluidState fluid) {
        return IClientFluidTypeExtensions.of((FluidState)fluid).getTintColor(fluid, level, pos);
    }

    public static boolean isDummyTexture(BakedQuad quad) {
        return ClientUtils.isTexture(quad, DUMMY_TEXTURE);
    }

    public static boolean isTexture(BakedQuad quad, ResourceLocation texture) {
        return quad.m_173410_().m_245424_().m_246162_().equals((Object)texture);
    }

    public static void enqueueClientTask(long delay, Runnable task) {
        long time = Minecraft.m_91087_().f_91073_.m_46467_() + delay;
        tasks.add(new ClientTask(time, task));
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || tasks.isEmpty()) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null || level.m_46472_() != lastDimension) {
            lastDimension = level != null ? level.m_46472_() : null;
            tasks.clear();
            if (level == null) {
                return;
            }
        }
        Iterator<ClientTask> it = tasks.iterator();
        while (it.hasNext()) {
            ClientTask task = it.next();
            if (level.m_46467_() < task.time) continue;
            task.task.run();
            it.remove();
        }
    }

    private ClientUtils() {
    }

    private record ClientTask(long time, Runnable task) {
    }
}

