/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.common.FBContent;

public class FramedPrismCornerModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;
    private final boolean offset;
    private final boolean ySlope;

    public FramedPrismCornerModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        this.offset = (Boolean)state.m_61143_((Property)FramedProperties.OFFSET);
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (quadDir == Direction.UP && this.top || quadDir == Direction.DOWN && !this.top) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 1.0f, 0.0f)).export(quadMap.get(quadDir));
        } else if (quadDir == this.dir || quadDir == this.dir.m_122428_()) {
            Direction cutDir = quadDir == this.dir ? this.dir.m_122427_() : this.dir.m_122424_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(cutDir, this.top ? 1.0f : 0.0f, this.top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
        } else if (!this.ySlope && quadDir == this.dir.m_122424_()) {
            if (this.offset) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122427_(), 0.5f)).apply(Modifiers.offset(this.dir.m_122427_(), 0.5f)).apply(Modifiers.cutPrismTriangle(!this.top, true)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122428_(), 0.5f)).apply(Modifiers.offset(this.dir.m_122428_(), 0.5f)).apply(Modifiers.cutPrismTriangle(!this.top, true)).export(quadMap.get(null));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutPrismTriangle(!this.top, true)).export(quadMap.get(null));
            }
        } else if (this.ySlope && (!this.top && quadDir == Direction.UP || this.top && quadDir == Direction.DOWN)) {
            if (this.offset) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.5f)).apply(Modifiers.offset(this.dir.m_122427_(), 0.5f)).apply(Modifiers.cutPrismTriangle(this.dir, true)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122428_(), 0.5f)).apply(Modifiers.offset(this.dir.m_122428_(), 0.5f)).apply(Modifiers.cutPrismTriangle(this.dir, true)).export(quadMap.get(null));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutPrismTriangle(this.dir, true)).export(quadMap.get(null));
            }
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedPrismCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

