/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.util.DoubleSoundMode;

public class FramedDividedSlopeBlockEntity
extends FramedDoubleBlockEntity {
    public FramedDividedSlopeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedDividedSlope.get(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit) {
        Direction dir;
        if (this.m_58900_().m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            dir = Direction.UP;
        } else {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR);
            dir = facing.m_122427_();
        }
        Direction side = hit.m_82434_();
        if (side == dir) {
            return true;
        }
        if (side == dir.m_122424_()) {
            return false;
        }
        return Utils.fractionInDir(hit.m_82450_(), dir) > 0.5;
    }

    @Override
    public DoubleSoundMode getSoundMode() {
        if (this.m_58900_().m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return DoubleSoundMode.SECOND;
        }
        return DoubleSoundMode.EITHER;
    }

    @Override
    public CamoContainer getCamo(Direction side) {
        SlopeType type = (SlopeType)((Object)this.m_58900_().m_61143_(PropertyHolder.SLOPE_TYPE));
        if (type == SlopeType.HORIZONTAL) {
            if (side == Direction.UP) {
                return this.getCamoTwo();
            }
            if (side == Direction.DOWN) {
                return this.getCamo();
            }
        } else {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR);
            if (side == facing.m_122427_()) {
                return this.getCamoTwo();
            }
            if (side == facing.m_122428_()) {
                return this.getCamo();
            }
        }
        return EmptyCamoContainer.EMPTY;
    }

    @Override
    public boolean isSolidSide(Direction side) {
        Direction secDir;
        SlopeType type = (SlopeType)((Object)this.m_58900_().m_61143_(PropertyHolder.SLOPE_TYPE));
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR);
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TOP: {
                Direction direction = Direction.UP;
                break;
            }
            case BOTTOM: {
                Direction direction = Direction.DOWN;
                break;
            }
            case HORIZONTAL: {
                Direction direction = secDir = facing.m_122428_();
            }
        }
        if (side == facing || side == secDir) {
            return this.getCamo().isSolid((BlockGetter)this.f_58857_, this.f_58858_) && this.getCamoTwo().isSolid((BlockGetter)this.f_58857_, this.f_58858_);
        }
        return false;
    }
}

