/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jei;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.FramingSawScreen;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramingSawBlock;
import xfacthd.framedblocks.common.compat.jei.FramedJeiPlugin;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;

public final class FramingSawRecipeCategory
implements IRecipeCategory<FramingSawRecipe> {
    private static final ResourceLocation BACKGROUND = Utils.rl("textures/gui/framing_saw_jei.png");
    private static final int WIDTH = 118;
    private static final int HEIGHT = 41;
    private static final int WARNING_X = 38;
    private static final int WARNING_Y = 3;
    private static final int WARNING_SIZE = 16;
    private static final float WARNING_SCALE = 0.75f;
    private static final int WARNING_DRAW_SIZE = 12;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable warning;

    public FramingSawRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUND, 0, 0, 118, 41);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)FBContent.blockFramingSaw.get()));
        this.warning = guiHelper.drawableBuilder(FramingSawScreen.WARNING_ICON, 8, 8, 16, 16).setTextureSize(32, 32).build();
    }

    public RecipeType<FramingSawRecipe> getRecipeType() {
        return FramedJeiPlugin.FRAMING_SAW_RECIPE_TYPE;
    }

    public Component getTitle() {
        return FramingSawBlock.MENU_TITLE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FramingSawRecipe recipe, IFocusGroup focuses) {
        FramingSawRecipeCache cache = FramingSawRecipeCache.get(true);
        List<FramingSawRecipeAdditive> additives = recipe.getAdditives();
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 19, 1).setSlotName("input");
        IRecipeSlotBuilder[] additiveSlots = null;
        if (!additives.isEmpty()) {
            additiveSlots = new IRecipeSlotBuilder[additives.size()];
            for (int i = 0; i < additives.size(); ++i) {
                int x = 1 + i * 18;
                additiveSlots[i] = builder.addSlot(RecipeIngredientRole.INPUT, x, 24);
            }
        }
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 13);
        ItemStack inputStack = focuses.getItemStackFocuses(RecipeIngredientRole.INPUT).map(focus -> (ItemStack)focus.getTypedValue().getIngredient()).filter(stack -> cache.getMaterialValue(stack.m_41720_()) > 0).findFirst().orElse(ItemStack.f_41583_);
        if (focuses.isEmpty()) {
            for (Item input : cache.getKnownItems()) {
                FramingSawRecipeCategory.setRecipe(input, recipe, inputSlot, additiveSlots, outputSlot);
            }
            if (additiveSlots != null) {
                IRecipeSlotBuilder[] slots = new IRecipeSlotBuilder[additives.size() + 2];
                System.arraycopy(additiveSlots, 0, slots, 1, additiveSlots.length);
                builder.createFocusLink((IIngredientAcceptor[])slots);
            } else {
                builder.createFocusLink(new IIngredientAcceptor[]{inputSlot, outputSlot});
            }
        } else if (!inputStack.m_41619_()) {
            FramingSawRecipeCategory.setRecipe(inputStack.m_41720_(), recipe, inputSlot, additiveSlots, outputSlot);
        } else {
            FramingSawRecipeCategory.setRecipe(((Block)FBContent.blockFramedCube.get()).m_5456_(), recipe, inputSlot, additiveSlots, outputSlot);
        }
    }

    private static void setRecipe(Item input, FramingSawRecipe recipe, IRecipeSlotBuilder inputSlot, IRecipeSlotBuilder[] additiveSlots, IRecipeSlotBuilder outputSlot) {
        FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation((Container)new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)input)}), true);
        ItemStack inputStack = new ItemStack((ItemLike)input, calc.getInputCount());
        ItemStack outputStack = recipe.getResult().m_41777_();
        int outputCount = calc.getOutputCount();
        outputStack.m_41764_(outputCount);
        List<FramingSawRecipeAdditive> additives = recipe.getAdditives();
        ArrayList<List<ItemStack>> flatAdditives = new ArrayList<List<ItemStack>>(3);
        for (FramingSawRecipeAdditive additive : additives) {
            int addCount = additive.count() * (outputCount / recipe.getResult().m_41613_());
            List<ItemStack> additiveStacks = Stream.of(additive.ingredient().m_43908_()).map(ItemStack::m_41777_).peek(s -> s.m_41764_(addCount)).toList();
            flatAdditives.add(additiveStacks);
        }
        List combinations = Lists.cartesianProduct(flatAdditives);
        combinations.forEach(stacks -> {
            inputSlot.addItemStack(inputStack);
            outputSlot.addItemStack(outputStack);
            for (int i = 0; i < stacks.size(); ++i) {
                additiveSlots[i].addItemStack((ItemStack)stacks.get(i));
            }
        });
    }

    public void draw(FramingSawRecipe recipe, IRecipeSlotsView slots, PoseStack poseStack, double mouseX, double mouseY) {
        ItemStack input = (ItemStack)((IRecipeSlotView)slots.findSlotByName("input").orElseThrow()).getDisplayedItemStack().orElseThrow();
        if (FramingSawRecipeCache.get(true).containsAdditive(input.m_41720_())) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.75f, 0.75f, 1.0f);
            poseStack.m_252880_(50.666668f, 4.0f, 0.0f);
            this.warning.draw(poseStack);
            poseStack.m_85849_();
        }
    }

    public List<Component> getTooltipStrings(FramingSawRecipe recipe, IRecipeSlotsView slots, double mouseX, double mouseY) {
        if (mouseX >= 38.0 && mouseY >= 3.0 && mouseX <= 50.0 && mouseY <= 15.0) {
            ItemStack input = (ItemStack)((IRecipeSlotView)slots.findSlotByName("input").orElseThrow()).getDisplayedItemStack().orElseThrow();
            if (FramingSawRecipeCache.get(true).containsAdditive(input.m_41720_())) {
                return List.of(FramingSawScreen.TOOLTIP_LOOSE_ADDITIVE);
            }
        }
        return List.of();
    }
}

