/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.VerticalHalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.util.FramedUtils;

public final class CornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
            return switch (blockType) {
                case BlockType.FRAMED_CORNER_SLOPE -> CornerSkipPredicate.testAgainstCorner(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE -> CornerSkipPredicate.testAgainstInnerCorner(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_CORNER -> CornerSkipPredicate.testAgainstDoubleCorner(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_SLOPE, BlockType.FRAMED_RAIL_SLOPE, BlockType.FRAMED_POWERED_RAIL_SLOPE, BlockType.FRAMED_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_ACTIVATOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_RAIL_SLOPE, BlockType.FRAMED_FANCY_POWERED_RAIL_SLOPE, BlockType.FRAMED_FANCY_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE -> CornerSkipPredicate.testAgainstSlope(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE -> CornerSkipPredicate.testAgainstDoubleSlope(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_PRISM_CORNER, BlockType.FRAMED_THREEWAY_CORNER -> CornerSkipPredicate.testAgainstThreewayCorner(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_INNER_PRISM_CORNER, BlockType.FRAMED_INNER_THREEWAY_CORNER -> CornerSkipPredicate.testAgainstInnerThreewayCorner(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM_CORNER, BlockType.FRAMED_DOUBLE_THREEWAY_CORNER -> CornerSkipPredicate.testAgainstDoubleThreewayCorner(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> CornerSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> CornerSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> CornerSkipPredicate.testAgainstDoubleHalfSlope(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> CornerSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE -> CornerSkipPredicate.testAgainstVerticalDoubleHalfSlope(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> CornerSkipPredicate.testAgainstSlopedStairs(level, pos, state, dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> CornerSkipPredicate.testAgainstVerticalSlopedStairs(level, pos, state, dir, type, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(CornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstInnerCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(InnerCornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerSkipPredicate.testAgainstInnerCorner(level, pos, state, dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstCorner(level, pos, state, dir, type, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = FramedUtils.getSlopeBlockFacing(adjState);
        SlopeType adjType = FramedUtils.getSlopeType(adjState);
        if (CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(SlopeSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerSkipPredicate.testAgainstSlope(level, pos, state, dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstSlope(level, pos, state, dir, type, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstThreewayCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(ThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstInnerThreewayCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(InnerThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleThreewayCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerSkipPredicate.testAgainstInnerThreewayCorner(level, pos, state, dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstThreewayCorner(level, pos, state, dir, type, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(HalfSlopeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return CornerSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, type, (BlockState)states.m_14419_(), side);
        }
        return CornerSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, type, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, type, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        boolean top = type.isTop();
        if (!type.isHorizontal() || !top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(VerticalHalfSlopeSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstVerticalHalfSlope(level, pos, state, dir, type, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        boolean top = type.isTop();
        if (!type.isHorizontal() || !top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(SlopedStairsSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    public static TriangleDir getTriDir(Direction dir, CornerType type, Direction side) {
        if (type.isHorizontal()) {
            boolean top = type.isTop();
            boolean right = type.isRight();
            if (!top && side == Direction.DOWN || top && side == Direction.UP) {
                return TriangleDir.fromDirections(dir, right ? dir.m_122427_() : dir.m_122428_());
            }
            if (!right && side == dir.m_122428_() || right && side == dir.m_122427_()) {
                return TriangleDir.fromDirections(dir, top ? Direction.UP : Direction.DOWN);
            }
        } else {
            if (side == dir) {
                return TriangleDir.fromDirections(dir.m_122428_(), type == CornerType.TOP ? Direction.UP : Direction.DOWN);
            }
            if (side == dir.m_122428_()) {
                return TriangleDir.fromDirections(dir, type == CornerType.TOP ? Direction.UP : Direction.DOWN);
            }
        }
        return TriangleDir.NULL;
    }
}

