/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book;

import com.google.common.base.Preconditions;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraft.resources.ResourceLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.ChapterBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.ConditionBuilder;

public final class GuidebookBuilder {
    private final String name;
    private final List<String> includes = new ArrayList<String>();
    private final List<ChapterBuilder> chapters = new ArrayList<ChapterBuilder>();
    private final List<String> dependencies = new ArrayList<String>();
    private final Map<String, ConditionBuilder> conditions = new LinkedHashMap<String, ConditionBuilder>();
    private String title = null;
    private ResourceLocation cover = null;
    private ResourceLocation model = null;
    private ResourceLocation background = null;
    private Float fontSize = null;
    private String home = null;

    GuidebookBuilder(String name) {
        Preconditions.checkArgument((boolean)ResourceLocation.m_135841_((String)name), (Object)"Book name must be valid resource location path");
        this.name = name;
        this.includes.add("gbook:xml/standard.xml");
    }

    public GuidebookBuilder title(String title) {
        this.title = title;
        return this;
    }

    public GuidebookBuilder cover(ResourceLocation cover) {
        this.cover = cover;
        return this;
    }

    public GuidebookBuilder model(ResourceLocation model) {
        this.model = model;
        return this;
    }

    public GuidebookBuilder background(ResourceLocation background) {
        this.background = background;
        return this;
    }

    public GuidebookBuilder fontSize(float fontSize) {
        this.fontSize = Float.valueOf(fontSize);
        return this;
    }

    public GuidebookBuilder home(String home) {
        this.home = home;
        return this;
    }

    public GuidebookBuilder include(ResourceLocation include) {
        this.includes.add(include.toString());
        return this;
    }

    public GuidebookBuilder dependency(String dependency) {
        this.dependencies.add(dependency);
        return this;
    }

    public GuidebookBuilder condition(ConditionBuilder condition) {
        ConditionBuilder prev = this.conditions.put(condition.getName(), condition);
        if (prev != null) {
            throw new IllegalStateException("Condition with name '" + prev.getName() + "' registered twice");
        }
        return this;
    }

    public GuidebookBuilder chapter(ChapterBuilder chapter) {
        this.chapters.add(chapter);
        return this;
    }

    String getName() {
        return this.name;
    }

    boolean hasCondition(String name) {
        return this.conditions.containsKey(name);
    }

    void print(OutputStream output) {
        Transformer transformer;
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
        }
        catch (ParserConfigurationException | TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document doc = builder.newDocument();
        Element bookElem = doc.createElement("book");
        if (this.title != null) {
            bookElem.setAttribute("title", this.title);
        }
        if (this.cover != null) {
            bookElem.setAttribute("cover", this.cover.toString());
        }
        if (this.model != null) {
            bookElem.setAttribute("model", this.model.toString());
        }
        if (this.background != null) {
            bookElem.setAttribute("background", this.background.toString());
        }
        if (this.fontSize != null) {
            bookElem.setAttribute("fontSize", this.fontSize.toString());
        }
        if (this.home != null) {
            bookElem.setAttribute("home", this.home);
        }
        if (!this.dependencies.isEmpty()) {
            bookElem.setAttribute("dependencies", String.join((CharSequence)",", this.dependencies));
        }
        this.includes.forEach(inc -> {
            Element incElem = doc.createElement("include");
            incElem.setAttribute("ref", (String)inc);
            bookElem.appendChild(incElem);
        });
        if (!this.conditions.isEmpty()) {
            Element condElem = doc.createElement("conditions");
            this.conditions.forEach((name, cond) -> cond.print(doc, condElem));
            bookElem.appendChild(condElem);
        }
        this.chapters.forEach(chapter -> {
            chapter.captureBook(this);
            chapter.print(doc, bookElem);
        });
        doc.appendChild(bookElem);
        StreamResult result = new StreamResult(output);
        try {
            transformer.transform(new DOMSource(doc), result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }
}

