/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book.elements;

import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.ContainerElementBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.ElementBuilder;

public final class CustomContainerElementBuilder
extends ContainerElementBuilder<CustomContainerElementBuilder>
implements ElementBuilder {
    private final String tagName;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();

    public CustomContainerElementBuilder(String tagName) {
        this.tagName = tagName;
    }

    public CustomContainerElementBuilder attribute(String name, String value) {
        String prev = this.attributes.put(name, value);
        if (prev != null) {
            throw new IllegalStateException("Duplicate attribute '%s', previously set to '%s'".formatted(name, prev));
        }
        return this;
    }

    @Override
    public void print(Document doc, Element parentElem) {
        Element element = doc.createElement(this.tagName);
        for (Map.Entry<String, String> attrib : this.attributes.entrySet()) {
            element.setAttribute(attrib.getKey(), attrib.getValue());
        }
        super.print(doc, element);
        parentElem.appendChild(element);
    }
}

