/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book.elements;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.elements.PositionableElementBuilder;

public abstract class FormattableElementBuilder<T extends FormattableElementBuilder<T>>
extends PositionableElementBuilder<T> {
    private final String content;
    private Integer color = null;
    private int indent = 0;
    private Float scale = null;

    protected FormattableElementBuilder(String content) {
        this.content = content;
    }

    public T color(int color) {
        this.color = color;
        return this.self();
    }

    public T indent(int indent) {
        this.indent = indent;
        return this.self();
    }

    public T scale(float scale) {
        this.scale = Float.valueOf(scale);
        return this.self();
    }

    @Override
    public void print(Document doc, Element parentElem) {
        if (this.color != null) {
            parentElem.setAttribute("color", this.color.toString());
        }
        if (this.indent != 0) {
            parentElem.setAttribute("indent", String.valueOf(this.indent));
        }
        if (this.scale != null) {
            parentElem.setAttribute("scale", this.scale.toString());
        }
        super.print(doc, parentElem);
        parentElem.appendChild(doc.createTextNode(this.content));
    }

    private T self() {
        return (T)this;
    }
}

