/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book.elements;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.ElementBuilder;

public final class StackElementBuilder
implements ElementBuilder {
    private final Item item;
    private int count = 0;
    private String name = null;
    private CompoundTag tag = null;
    private float scale = 1.0f;

    public StackElementBuilder(Item item) {
        this.item = item;
    }

    public StackElementBuilder count(int count) {
        this.count = count;
        return this;
    }

    public StackElementBuilder name(String name) {
        this.name = name;
        return this;
    }

    public StackElementBuilder tag(CompoundTag tag) {
        this.tag = tag;
        return this;
    }

    public StackElementBuilder scale(float scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public void print(Document doc, Element parentElem) {
        Element stackElem = doc.createElement("stack");
        stackElem.setAttribute("item", ForgeRegistries.ITEMS.getKey((Object)this.item).toString());
        if (this.count > 0) {
            stackElem.setAttribute("count", Integer.toString(this.count));
        }
        if (this.name != null) {
            stackElem.setAttribute("name", this.name);
        }
        if (this.tag != null) {
            stackElem.setAttribute("tag", this.tag.m_7916_());
        }
        if (this.scale != 1.0f) {
            stackElem.setAttribute("scale", Float.toString(this.scale));
        }
        parentElem.appendChild(stackElem);
    }
}

