/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.NotResourceCondition;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer;
import com.supermartijn642.core.generator.AdvancementGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.crafting.conditions.ICondition;

public abstract class RecipeGenerator
extends ResourceGenerator {
    private static final Map<CreativeModeTab, RecipeCategory> TAB_TO_CATEGORY = new HashMap<CreativeModeTab, RecipeCategory>();
    private final Map<ResourceLocation, RecipeBuilder<?>> recipes = new HashMap();
    private final Advancements advancements;

    public RecipeGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
        this.advancements = new Advancements(modid, cache);
    }

    @Override
    public void save() {
        this.advancements.generate();
        for (RecipeBuilder<?> recipeBuilder : this.recipes.values()) {
            JsonObject json = new JsonObject();
            HashMap<String, JsonObject> subRecipes = new HashMap<String, JsonObject>();
            subRecipes.put("", json);
            json.addProperty("type", Registries.RECIPE_SERIALIZERS.getIdentifier(recipeBuilder.serializer).toString());
            if (recipeBuilder instanceof ShapedRecipeBuilder) {
                HashSet<Character> characters = new HashSet<Character>();
                for (String string : ((ShapedRecipeBuilder)recipeBuilder).pattern) {
                    for (char c : string.toCharArray()) {
                        if (c == ' ' || !characters.add(Character.valueOf(c)) || ((ShapedRecipeBuilder)recipeBuilder).inputs.containsKey(Character.valueOf(c))) continue;
                        throw new RuntimeException("Recipe '" + recipeBuilder.identifier + "' is missing an input for character '" + c + "'!");
                    }
                }
                for (Character c : ((ShapedRecipeBuilder)recipeBuilder).inputs.keySet()) {
                    if (characters.contains(c)) continue;
                    throw new RuntimeException("Recipe '" + recipeBuilder.identifier + "' has unused input with key '" + c + "'!");
                }
                json.addProperty("group", recipeBuilder.group);
                json.add("pattern", (JsonElement)RecipeGenerator.createArray(((ShapedRecipeBuilder)recipeBuilder).pattern));
                JsonObject keysJson = new JsonObject();
                for (Map.Entry<Character, Ingredient> input : ((ShapedRecipeBuilder)recipeBuilder).inputs.entrySet()) {
                    keysJson.add(input.getKey().toString(), input.getValue().m_43942_());
                }
                json.add("key", (JsonElement)keysJson);
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("item", Registries.ITEMS.getIdentifier(recipeBuilder.output.m_5456_()).toString());
                if (recipeBuilder.outputCount != 1) {
                    jsonObject.addProperty("count", (Number)recipeBuilder.outputCount);
                }
                if (recipeBuilder.outputTag != null) {
                    jsonObject.addProperty("nbt", recipeBuilder.outputTag.toString());
                }
                json.add("result", (JsonElement)jsonObject);
            } else if (recipeBuilder instanceof ShapelessRecipeBuilder) {
                json.addProperty("group", recipeBuilder.group);
                JsonArray ingredientsJson = new JsonArray();
                for (Ingredient ingredient : ((ShapelessRecipeBuilder)recipeBuilder).inputs) {
                    ingredientsJson.add(ingredient.m_43942_());
                }
                json.add("ingredients", (JsonElement)ingredientsJson);
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("item", Registries.ITEMS.getIdentifier(recipeBuilder.output.m_5456_()).toString());
                if (recipeBuilder.outputCount != 1) {
                    resultJson.addProperty("count", (Number)recipeBuilder.outputCount);
                }
                if (recipeBuilder.outputTag != null) {
                    resultJson.addProperty("nbt", recipeBuilder.outputTag.toString());
                }
                json.add("result", (JsonElement)resultJson);
            } else if (recipeBuilder instanceof SmeltingRecipeBuilder) {
                JsonObject recipeJson;
                if (((SmeltingRecipeBuilder)recipeBuilder).includeBlasting) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:blasting");
                    RecipeGenerator.serializeCookingRecipe(recipeJson, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_blasting", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeSmoking) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:smoking");
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_smoking", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeCampfire) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:campfire_cooking");
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_campfire", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeSmelting) {
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 1, 200);
                } else {
                    subRecipes.remove("");
                }
            } else if (recipeBuilder instanceof SmithingRecipeBuilder) {
                json.addProperty("group", recipeBuilder.group);
                json.add("base", ((SmithingRecipeBuilder)recipeBuilder).base.m_43942_());
                json.add("addition", ((SmithingRecipeBuilder)recipeBuilder).addition.m_43942_());
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("item", Registries.ITEMS.getIdentifier(recipeBuilder.output.m_5456_()).toString());
                if (recipeBuilder.outputCount != 1) {
                    resultJson.addProperty("count", (Number)recipeBuilder.outputCount);
                }
                if (recipeBuilder.outputTag != null) {
                    resultJson.addProperty("nbt", recipeBuilder.outputTag.toString());
                }
                json.add("result", (JsonElement)resultJson);
            } else if (recipeBuilder instanceof StoneCuttingRecipeBuilder) {
                json.addProperty("group", recipeBuilder.group);
                json.add("ingredient", ((StoneCuttingRecipeBuilder)recipeBuilder).input.m_43942_());
                json.addProperty("result", Registries.ITEMS.getIdentifier(recipeBuilder.output.m_5456_()).toString());
                json.addProperty("count", (Number)recipeBuilder.outputCount);
            }
            for (Map.Entry subRecipe : subRecipes.entrySet()) {
                json = (JsonObject)subRecipe.getValue();
                if (!recipeBuilder.conditions.isEmpty()) {
                    json = ConditionalRecipeSerializer.wrapRecipeWithForgeConditions(json, recipeBuilder.conditions);
                }
                ResourceLocation resourceLocation = recipeBuilder.identifier;
                this.cache.saveJsonResource(ResourceType.DATA, json, resourceLocation.m_135827_(), "recipes", resourceLocation.m_135815_() + (String)subRecipe.getKey());
            }
        }
        this.advancements.save();
    }

    private static void serializeCookingRecipe(JsonObject json, SmeltingRecipeBuilder recipeBuilder, int durationDivider, int defaultDuration) {
        int duration;
        json.addProperty("group", recipeBuilder.group);
        json.add("ingredient", recipeBuilder.input.m_43942_());
        if (recipeBuilder.outputTag == null && recipeBuilder.outputCount == 1) {
            json.addProperty("result", Registries.ITEMS.getIdentifier(recipeBuilder.output.m_5456_()).toString());
        } else {
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", Registries.ITEMS.getIdentifier(recipeBuilder.output.m_5456_()).toString());
            if (recipeBuilder.outputCount != 1) {
                resultJson.addProperty("count", (Number)recipeBuilder.outputCount);
            }
            if (recipeBuilder.outputTag != null) {
                resultJson.addProperty("nbt", recipeBuilder.outputTag.toString());
            }
            json.add("result", (JsonElement)resultJson);
        }
        if (recipeBuilder.experience != 0) {
            json.addProperty("experience", (Number)recipeBuilder.experience);
        }
        if ((duration = recipeBuilder.duration / durationDivider) != defaultDuration) {
            json.addProperty("cookingtime", (Number)duration);
        }
    }

    private static JsonArray createArray(Iterable<String> elements) {
        JsonArray array = new JsonArray();
        for (String element : elements) {
            array.add(element);
        }
        return array;
    }

    protected <T extends RecipeBuilder<T>> T recipe(ResourceLocation recipeLocation, T builder) {
        if (this.recipes.containsKey(recipeLocation)) {
            throw new RuntimeException("Duplicate recipe '" + recipeLocation + "' of types '" + this.recipes.get(recipeLocation).getClass().getName() + "' and '" + builder.getClass().getName() + "'!");
        }
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, builder.identifier.m_135827_(), "recipes", builder.identifier.m_135815_(), ".json");
        this.recipes.put(recipeLocation, builder);
        return builder;
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, ItemLike output, CompoundTag nbt, int amount) {
        return this.recipe(recipeLocation, new ShapedRecipeBuilder(recipeLocation, output, nbt, amount));
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, ItemLike output, CompoundTag nbt, int amount) {
        return this.shaped(new ResourceLocation(namespace, identifier), output, nbt, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, ItemLike output, CompoundTag nbt, int amount) {
        return this.shaped(this.modid, identifier, output, nbt, amount);
    }

    protected ShapedRecipeBuilder shaped(ItemLike output, CompoundTag nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.m_5456_());
        return this.recipe(identifier, new ShapedRecipeBuilder(identifier, output, nbt, amount));
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, ItemLike output, int amount) {
        return this.shaped(recipeLocation, output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, ItemLike output, int amount) {
        return this.shaped(new ResourceLocation(namespace, identifier), output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, ItemLike output, int amount) {
        return this.shaped(this.modid, identifier, output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(ItemLike output, int amount) {
        return this.shaped(output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, ItemLike output) {
        return this.shaped(recipeLocation, output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, ItemLike output) {
        return this.shaped(new ResourceLocation(namespace, identifier), output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(String identifier, ItemLike output) {
        return this.shaped(this.modid, identifier, output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(ItemLike output) {
        return this.shaped(output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(ResourceLocation recipeLocation, ItemStack output) {
        return this.shaped(recipeLocation, (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, ItemStack output) {
        return this.shaped(new ResourceLocation(namespace, identifier), (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected ShapedRecipeBuilder shaped(String identifier, ItemStack output) {
        return this.shaped(this.modid, identifier, (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected ShapedRecipeBuilder shaped(ItemStack output) {
        return this.shaped((ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, ItemLike output, CompoundTag nbt, int amount) {
        return this.recipe(recipeLocation, new ShapelessRecipeBuilder(recipeLocation, output, nbt, amount));
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, ItemLike output, CompoundTag nbt, int amount) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, ItemLike output, CompoundTag nbt, int amount) {
        return this.shapeless(this.modid, identifier, output, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ItemLike output, CompoundTag nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.m_5456_());
        return this.shapeless(identifier, output, nbt, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, ItemLike output, int amount) {
        return this.shapeless(recipeLocation, output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, ItemLike output, int amount) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, ItemLike output, int amount) {
        return this.shapeless(this.modid, identifier, output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ItemLike output, int amount) {
        return this.shapeless(output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, ItemLike output) {
        return this.shapeless(recipeLocation, output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, ItemLike output) {
        return this.shapeless(new ResourceLocation(namespace, identifier), output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, ItemLike output) {
        return this.shapeless(this.modid, identifier, output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(ItemLike output) {
        return this.shapeless(output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(ResourceLocation recipeLocation, ItemStack output) {
        return this.shapeless(recipeLocation, (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, ItemStack output) {
        return this.shapeless(new ResourceLocation(namespace, identifier), (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, ItemStack output) {
        return this.shapeless(this.modid, identifier, (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected ShapelessRecipeBuilder shapeless(ItemStack output) {
        return this.shapeless((ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, ItemLike output, CompoundTag nbt, int amount) {
        return this.recipe(recipeLocation, new SmeltingRecipeBuilder(recipeLocation, output, nbt, amount)).includeSmelting();
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, ItemLike output, CompoundTag nbt, int amount) {
        return this.smelting(new ResourceLocation(namespace, identifier), output, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, ItemLike output, CompoundTag nbt, int amount) {
        return this.smelting(this.modid, identifier, output, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(ItemLike output, CompoundTag nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.m_5456_());
        return this.smelting(identifier, output, nbt, amount);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, ItemLike output, int amount) {
        return this.smelting(recipeLocation, output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, ItemLike output, int amount) {
        return this.smelting(new ResourceLocation(namespace, identifier), output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, ItemLike output, int amount) {
        return this.smelting(this.modid, identifier, output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(ItemLike output, int amount) {
        return this.smelting(output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, ItemLike output) {
        return this.smelting(recipeLocation, output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, ItemLike output) {
        return this.smelting(new ResourceLocation(namespace, identifier), output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, ItemLike output) {
        return this.smelting(this.modid, identifier, output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(ItemLike output) {
        return this.smelting(output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(ResourceLocation recipeLocation, ItemStack output) {
        return this.smelting(recipeLocation, (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, ItemStack output) {
        return this.smelting(new ResourceLocation(namespace, identifier), (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected SmeltingRecipeBuilder smelting(String identifier, ItemStack output) {
        return this.smelting(this.modid, identifier, (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected SmeltingRecipeBuilder smelting(ItemStack output) {
        return this.smelting((ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, ItemLike output, CompoundTag nbt, int amount) {
        return this.recipe(recipeLocation, new SmithingRecipeBuilder(recipeLocation, output, nbt, amount));
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, ItemLike output, CompoundTag nbt, int amount) {
        return this.smithing(new ResourceLocation(namespace, identifier), output, nbt, amount);
    }

    protected SmithingRecipeBuilder smithing(String identifier, ItemLike output, CompoundTag nbt, int amount) {
        return this.smithing(this.modid, identifier, output, nbt, amount);
    }

    protected SmithingRecipeBuilder smithing(ItemLike output, CompoundTag nbt, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.m_5456_());
        return this.smithing(identifier, output, nbt, amount);
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, ItemLike output, int amount) {
        return this.smithing(recipeLocation, output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, ItemLike output, int amount) {
        return this.smithing(new ResourceLocation(namespace, identifier), output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(String identifier, ItemLike output, int amount) {
        return this.smithing(this.modid, identifier, output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(ItemLike output, int amount) {
        return this.smithing(output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, ItemLike output) {
        return this.smithing(recipeLocation, output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, ItemLike output) {
        return this.smithing(new ResourceLocation(namespace, identifier), output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(String identifier, ItemLike output) {
        return this.smithing(this.modid, identifier, output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(ItemLike output) {
        return this.smithing(output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(ResourceLocation recipeLocation, ItemStack output) {
        return this.smithing(recipeLocation, (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, ItemStack output) {
        return this.smithing(new ResourceLocation(namespace, identifier), (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected SmithingRecipeBuilder smithing(String identifier, ItemStack output) {
        return this.smithing(this.modid, identifier, (ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected SmithingRecipeBuilder smithing(ItemStack output) {
        return this.smithing((ItemLike)output.m_41720_(), output.m_41782_() && !output.m_41783_().m_128456_() ? output.m_41783_() : null, output.m_41613_());
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ResourceLocation recipeLocation, ItemLike output, int amount) {
        return this.recipe(recipeLocation, new StoneCuttingRecipeBuilder(recipeLocation, output, amount));
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String namespace, String identifier, ItemLike output, int amount) {
        return this.stoneCutting(new ResourceLocation(namespace, identifier), output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String identifier, ItemLike output, int amount) {
        return this.stoneCutting(this.modid, identifier, output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ItemLike output, int amount) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(output.m_5456_());
        return this.stoneCutting(identifier, output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ResourceLocation recipeLocation, ItemLike output) {
        return this.stoneCutting(recipeLocation, output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String namespace, String identifier, ItemLike output) {
        return this.stoneCutting(new ResourceLocation(namespace, identifier), output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String identifier, ItemLike output) {
        return this.stoneCutting(this.modid, identifier, output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(ItemLike output) {
        return this.stoneCutting(output, 1);
    }

    @Override
    public String getName() {
        return this.modName + " Recipe Generator";
    }

    static {
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_256788_, RecipeCategory.BUILDING_BLOCKS);
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_256797_, RecipeCategory.COMBAT);
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_256725_, RecipeCategory.BUILDING_BLOCKS);
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_256839_, RecipeCategory.FOOD);
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_256791_, RecipeCategory.BUILDING_BLOCKS);
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_256968_, RecipeCategory.MISC);
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_256776_, RecipeCategory.DECORATIONS);
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_257028_, RecipeCategory.REDSTONE);
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_256837_, RecipeCategory.MISC);
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_256731_, RecipeCategory.MISC);
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_256869_, RecipeCategory.TOOLS);
        TAB_TO_CATEGORY.put(CreativeModeTabs.f_256750_, RecipeCategory.MISC);
    }

    private final class Advancements
    extends AdvancementGenerator {
        public Advancements(String modid, ResourceCache cache) {
            super(modid, cache);
        }

        @Override
        public void generate() {
            for (RecipeBuilder<?> recipe : RecipeGenerator.this.recipes.values()) {
                if (!recipe.hasAdvancement) continue;
                Item outputItem = recipe.output.m_5456_();
                String category = RecipeCategory.MISC.m_247710_();
                for (CreativeModeTab tab : CreativeModeTabRegistry.getSortedCreativeModeTabs()) {
                    if (!tab.m_257694_(outputItem.m_7968_())) continue;
                    category = TAB_TO_CATEGORY.containsKey(tab) ? TAB_TO_CATEGORY.get(tab).m_247710_() : CreativeModeTabRegistry.getName((CreativeModeTab)tab).m_135815_();
                }
                String namespace = recipe.identifier.m_135827_();
                String identifier = "recipes/" + category + "/" + recipe.identifier.m_135815_();
                if (recipe instanceof SmeltingRecipeBuilder) {
                    if (((SmeltingRecipeBuilder)recipe).includeSmelting) {
                        this.createAdvancement(namespace, identifier + "_smelting", recipe);
                    }
                    if (((SmeltingRecipeBuilder)recipe).includeBlasting) {
                        this.createAdvancement(namespace, identifier + "_blasting", recipe);
                    }
                    if (((SmeltingRecipeBuilder)recipe).includeSmoking) {
                        this.createAdvancement(namespace, identifier + "_smoking", recipe);
                    }
                    if (!((SmeltingRecipeBuilder)recipe).includeCampfire) continue;
                    this.createAdvancement(namespace, identifier + "_campfire", recipe);
                    continue;
                }
                this.createAdvancement(namespace, identifier, recipe);
            }
        }

        private void createAdvancement(String namespace, String identifier, RecipeBuilder<?> recipe) {
            AdvancementGenerator.AdvancementBuilder builder = this.advancement(namespace, identifier).parent(net.minecraft.data.recipes.RecipeBuilder.f_236353_).criterion("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipe.identifier)).icon(recipe.output, recipe.outputTag).dontShowToast().dontAnnounceToChat().rewardRecipe(recipe.identifier);
            String[] triggers = new String[recipe.unlockedBy.size() + 1];
            triggers[0] = "has_the_recipe";
            if (recipe.unlockedBy.size() == 1) {
                builder.criterion("recipe_condition", recipe.unlockedBy.get(0));
                triggers[1] = "recipe_condition";
            } else {
                for (int i = 0; i < recipe.unlockedBy.size(); ++i) {
                    builder.criterion("recipe_condition" + (i + 1), recipe.unlockedBy.get(i));
                    triggers[i + 1] = "recipe_condition" + (i + 1);
                }
            }
            builder.requirementGroup(triggers);
            recipe.conditions.forEach(builder::condition);
        }
    }

    public static abstract class RecipeBuilder<T extends RecipeBuilder<T>> {
        protected final ResourceLocation identifier;
        private final List<ICondition> conditions = new ArrayList<ICondition>();
        private final ItemLike output;
        private final CompoundTag outputTag;
        private final int outputCount;
        private RecipeSerializer<?> serializer;
        private String group;
        private boolean hasAdvancement = true;
        private final List<CriterionTriggerInstance> unlockedBy = new ArrayList<CriterionTriggerInstance>();

        protected RecipeBuilder(ResourceLocation identifier, RecipeSerializer<?> serializer, ItemLike output, CompoundTag outputTag, int outputCount) {
            this.identifier = identifier;
            this.output = output;
            this.outputTag = outputTag;
            this.outputCount = outputCount;
            this.serializer = serializer;
        }

        public T group(String group) {
            this.group = group == null || group.trim().isEmpty() ? null : group;
            return this.self();
        }

        public T condition(ICondition condition) {
            this.conditions.add(condition);
            return this.self();
        }

        public T condition(ResourceCondition condition) {
            return this.condition(ResourceCondition.createForgeCondition(condition));
        }

        public T notCondition(ICondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public T notCondition(ResourceCondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public T modLoadedCondition(String modid) {
            return this.condition(new ModLoadedResourceCondition(modid));
        }

        public T advancement(boolean generate) {
            this.hasAdvancement = generate;
            return this.self();
        }

        public T noAdvancement() {
            return this.advancement(false);
        }

        public T unlockedBy(CriterionTriggerInstance criterion) {
            if (this.unlockedBy.contains(criterion)) {
                throw new RuntimeException("Duplicate unlockedBy criterion '" + criterion + "'!");
            }
            this.unlockedBy.add(criterion);
            return this.self();
        }

        public T unlockedBy(ItemLike ... items) {
            return this.unlockedBy((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])items));
        }

        public T unlockedBy(TagKey<Item> tagKey) {
            return this.unlockedBy((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tagKey).m_45077_()}));
        }

        public T customSerializer(RecipeSerializer<?> serializer) {
            this.serializer = serializer;
            return this.self();
        }

        private T self() {
            return (T)this;
        }
    }

    protected static class ShapedRecipeBuilder
    extends RecipeBuilder<ShapedRecipeBuilder> {
        private final List<String> pattern = new ArrayList<String>();
        private final Map<Character, Ingredient> inputs = new HashMap<Character, Ingredient>();

        private ShapedRecipeBuilder(ResourceLocation identifier, ItemLike output, CompoundTag outputTag, int outputCount) {
            super(identifier, RecipeSerializer.f_44076_, output, outputTag, outputCount);
        }

        public ShapedRecipeBuilder pattern(String row) {
            if (row.isEmpty()) {
                throw new IllegalArgumentException("Pattern row for recipe '" + this.identifier + "' cannot be empty!");
            }
            if (row.length() > 3) {
                throw new IllegalArgumentException("Pattern row for recipe '" + this.identifier + "' can have at most 3 characters, not '" + row.length() + "'!");
            }
            for (String otherRow : this.pattern) {
                if (row.length() == otherRow.length()) continue;
                throw new IllegalArgumentException("Pattern rows for recipe '" + this.identifier + "' must have the same length!");
            }
            this.pattern.add(row);
            return this;
        }

        public ShapedRecipeBuilder pattern(String ... rows) {
            for (String row : rows) {
                this.pattern(row);
            }
            return this;
        }

        public ShapedRecipeBuilder input(char key, Ingredient ingredient) {
            if (this.inputs.containsKey(Character.valueOf(key))) {
                throw new RuntimeException("Duplicate key '" + key + "' for recipe '" + this.identifier + "'!");
            }
            this.inputs.put(Character.valueOf(key), ingredient);
            return this;
        }

        public ShapedRecipeBuilder input(char key, Ingredient ... ingredients) {
            return this.input(key, Ingredient.merge(Arrays.asList(ingredients)));
        }

        public ShapedRecipeBuilder input(char key, ItemLike ... items) {
            return this.input(key, Ingredient.m_43929_((ItemLike[])items));
        }

        public ShapedRecipeBuilder input(char key, ItemStack ... itemStacks) {
            return this.input(key, Ingredient.m_43927_((ItemStack[])itemStacks));
        }

        public ShapedRecipeBuilder input(char key, TagKey<Item> tag) {
            return this.input(key, Ingredient.m_204132_(tag));
        }
    }

    protected static class ShapelessRecipeBuilder
    extends RecipeBuilder<ShapelessRecipeBuilder> {
        private final List<Ingredient> inputs = new ArrayList<Ingredient>();

        private ShapelessRecipeBuilder(ResourceLocation identifier, ItemLike output, CompoundTag outputTag, int outputCount) {
            super(identifier, RecipeSerializer.f_44077_, output, outputTag, outputCount);
        }

        public ShapelessRecipeBuilder input(Ingredient ingredient, int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("Cannot add an ingredient '" + count + "' times to recipe '" + this.identifier + "'!");
            }
            if (this.inputs.size() + count > 9) {
                throw new RuntimeException("Recipe '" + this.identifier + "' can have at most 9 inputs!");
            }
            for (int i = 0; i < count; ++i) {
                this.inputs.add(ingredient);
            }
            return this;
        }

        public ShapelessRecipeBuilder input(Ingredient ingredient) {
            return this.input(ingredient, 1);
        }

        public ShapelessRecipeBuilder input(ItemLike item, int count) {
            return this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), count);
        }

        public ShapelessRecipeBuilder input(ItemLike item) {
            return this.input(item, 1);
        }

        public ShapelessRecipeBuilder input(ItemStack itemStack, int count) {
            return this.input(Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}), count);
        }

        public ShapelessRecipeBuilder input(ItemStack itemStack) {
            return this.input(itemStack, 1);
        }

        public ShapelessRecipeBuilder input(TagKey<Item> tag, int count) {
            return this.input(Ingredient.m_204132_(tag), count);
        }

        public ShapelessRecipeBuilder input(TagKey<Item> tag) {
            return this.input(Ingredient.m_204132_(tag), 1);
        }

        public ShapelessRecipeBuilder inputs(Ingredient ... ingredients) {
            for (Ingredient ingredient : ingredients) {
                this.input(ingredient);
            }
            return this;
        }

        public ShapelessRecipeBuilder inputs(ItemLike ... items) {
            for (ItemLike item : items) {
                this.input(item);
            }
            return this;
        }

        public ShapelessRecipeBuilder inputs(ItemStack ... itemStacks) {
            for (ItemStack itemStack : itemStacks) {
                this.input(itemStack);
            }
            return this;
        }
    }

    protected static class SmeltingRecipeBuilder
    extends RecipeBuilder<SmeltingRecipeBuilder> {
        private boolean includeSmelting;
        private boolean includeBlasting;
        private boolean includeCampfire;
        private boolean includeSmoking;
        private Ingredient input;
        private int experience;
        private int duration = 200;

        private SmeltingRecipeBuilder(ResourceLocation identifier, ItemLike output, CompoundTag outputTag, int count) {
            super(identifier, RecipeSerializer.f_44091_, output, outputTag, count);
        }

        public SmeltingRecipeBuilder includeSmelting(boolean includeSmelting) {
            this.includeSmelting = includeSmelting;
            return this;
        }

        public SmeltingRecipeBuilder includeSmelting() {
            return this.includeSmelting(true);
        }

        public SmeltingRecipeBuilder includeBlasting(boolean includeBlasting) {
            this.includeBlasting = includeBlasting;
            return this;
        }

        public SmeltingRecipeBuilder includeBlasting() {
            return this.includeBlasting(true);
        }

        public SmeltingRecipeBuilder includeCampfire(boolean includeCampfire) {
            this.includeCampfire = includeCampfire;
            return this;
        }

        public SmeltingRecipeBuilder includeCampfire() {
            return this.includeCampfire(true);
        }

        public SmeltingRecipeBuilder includeSmoking(boolean includeSmoking) {
            this.includeSmoking = includeSmoking;
            return this;
        }

        public SmeltingRecipeBuilder includeSmoking() {
            return this.includeSmoking(true);
        }

        public SmeltingRecipeBuilder input(Ingredient ingredient) {
            this.input = ingredient;
            return this;
        }

        public SmeltingRecipeBuilder input(Ingredient ... ingredients) {
            return this.input(Ingredient.merge(Arrays.asList(ingredients)));
        }

        public SmeltingRecipeBuilder input(ItemLike ... items) {
            return this.input(Ingredient.m_43929_((ItemLike[])items));
        }

        public SmeltingRecipeBuilder input(ItemStack ... itemStacks) {
            return this.input(Ingredient.m_43927_((ItemStack[])itemStacks));
        }

        public SmeltingRecipeBuilder input(TagKey<Item> tag) {
            return this.input(Ingredient.m_204132_(tag));
        }

        public SmeltingRecipeBuilder experience(int experience) {
            if (experience < 0) {
                throw new IllegalArgumentException("Experience for recipe '" + this.identifier + "' cannot be negative!");
            }
            this.experience = experience;
            return this;
        }

        public SmeltingRecipeBuilder duration(int ticks) {
            if (ticks <= 0) {
                throw new IllegalArgumentException("Duration for recipe '" + this.identifier + "' must be greater than 0!");
            }
            this.duration = ticks;
            return this;
        }

        public SmeltingRecipeBuilder durationSeconds(int seconds) {
            return this.duration(seconds * 20);
        }
    }

    protected static class SmithingRecipeBuilder
    extends RecipeBuilder<SmithingRecipeBuilder> {
        private Ingredient base;
        private Ingredient addition;

        private SmithingRecipeBuilder(ResourceLocation identifier, ItemLike output, CompoundTag outputTag, int outputCount) {
            super(identifier, RecipeSerializer.f_44096_, output, outputTag, outputCount);
        }

        public SmithingRecipeBuilder base(Ingredient ingredient) {
            this.base = ingredient;
            return this;
        }

        public SmithingRecipeBuilder base(Ingredient ... ingredients) {
            return this.base(Ingredient.merge(Arrays.asList(ingredients)));
        }

        public SmithingRecipeBuilder base(ItemLike ... items) {
            return this.base(Ingredient.m_43929_((ItemLike[])items));
        }

        public SmithingRecipeBuilder base(ItemStack ... itemStacks) {
            return this.base(Ingredient.m_43927_((ItemStack[])itemStacks));
        }

        public SmithingRecipeBuilder base(TagKey<Item> tag) {
            return this.base(Ingredient.m_204132_(tag));
        }

        public SmithingRecipeBuilder addition(Ingredient ingredient) {
            this.addition = ingredient;
            return this;
        }

        public SmithingRecipeBuilder addition(Ingredient ... ingredients) {
            return this.addition(Ingredient.merge(Arrays.asList(ingredients)));
        }

        public SmithingRecipeBuilder addition(ItemLike ... items) {
            return this.addition(Ingredient.m_43929_((ItemLike[])items));
        }

        public SmithingRecipeBuilder addition(ItemStack ... itemStacks) {
            return this.addition(Ingredient.m_43927_((ItemStack[])itemStacks));
        }

        public SmithingRecipeBuilder addition(TagKey<Item> tag) {
            return this.addition(Ingredient.m_204132_(tag));
        }
    }

    protected static class StoneCuttingRecipeBuilder
    extends RecipeBuilder<StoneCuttingRecipeBuilder> {
        private Ingredient input;

        private StoneCuttingRecipeBuilder(ResourceLocation identifier, ItemLike output, int outputCount) {
            super(identifier, RecipeSerializer.f_44095_, output, null, outputCount);
        }

        public StoneCuttingRecipeBuilder input(Ingredient ingredient) {
            this.input = ingredient;
            return this;
        }

        public StoneCuttingRecipeBuilder input(Ingredient ... ingredients) {
            return this.input(Ingredient.merge(Arrays.asList(ingredients)));
        }

        public StoneCuttingRecipeBuilder input(ItemLike ... items) {
            return this.input(Ingredient.m_43929_((ItemLike[])items));
        }

        public StoneCuttingRecipeBuilder input(ItemStack ... itemStacks) {
            return this.input(Ingredient.m_43927_((ItemStack[])itemStacks));
        }

        public StoneCuttingRecipeBuilder input(TagKey<Item> tag) {
            return this.input(Ingredient.m_204132_(tag));
        }
    }
}

