/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache;

import com.mojang.blaze3d.vertex.BufferBuilder;
import java.nio.ByteBuffer;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.render.cache.ChunkLayerCache;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferHolder;
import team.creative.littletiles.client.render.cache.buffer.ByteBufferHolder;
import team.creative.littletiles.client.render.cache.buffer.UploadableBufferHolder;

public class BlockBufferCache {
    private ChunkLayerMap<BufferHolder> queue = new ChunkLayerMap();
    private ChunkLayerMap<UploadableBufferHolder> uploaded = new ChunkLayerMap();
    private transient ChunkLayerMap<BufferHolder> additional = null;

    public static BufferHolder combine(BufferHolder first, BufferHolder second) {
        ByteBuffer secondBuffer;
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int vertexCount = 0;
        int length = 0;
        ByteBuffer firstBuffer = first.byteBuffer();
        if (firstBuffer != null) {
            vertexCount += first.vertexCount();
            length += first.length();
        }
        if ((secondBuffer = second.byteBuffer()) != null) {
            vertexCount += second.vertexCount();
            length += second.length();
        }
        if (vertexCount == 0) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(length);
        if (firstBuffer != null) {
            firstBuffer.position(0);
            firstBuffer.limit(first.length());
            byteBuffer.put(firstBuffer);
            firstBuffer.rewind();
        }
        if (secondBuffer != null) {
            secondBuffer.position(0);
            secondBuffer.limit(second.length());
            byteBuffer.put(secondBuffer);
            secondBuffer.rewind();
        }
        byteBuffer.rewind();
        return new ByteBufferHolder(byteBuffer, length, vertexCount, null);
    }

    private UploadableBufferHolder getUploaded(RenderType layer) {
        UploadableBufferHolder holder = (UploadableBufferHolder)this.uploaded.get(layer);
        if (holder != null && holder.isInvalid()) {
            this.uploaded.remove(layer);
            return null;
        }
        return holder;
    }

    private BufferHolder getOriginal(RenderType layer) {
        BufferHolder queued = (BufferHolder)this.queue.get(layer);
        if (queued == null) {
            return this.getUploaded(layer);
        }
        return queued;
    }

    public BufferHolder get(RenderType layer) {
        BufferHolder original = this.getOriginal(layer);
        if (this.additional != null) {
            return BlockBufferCache.combine(original, (BufferHolder)this.additional.get(layer));
        }
        return original;
    }

    public BufferHolder extract(RenderType layer, int index) {
        BufferHolder holder = this.getOriginal(layer);
        if (holder == null) {
            return null;
        }
        boolean holderUploaded = this.uploaded.get(layer) != null;
        BufferHolder extracted = holder.extract(index);
        if (holder.indexCount() == 0) {
            if (holderUploaded) {
                this.uploaded.remove(layer);
            } else {
                this.queue.remove(layer);
            }
        }
        return extracted;
    }

    public boolean has(RenderType layer) {
        return this.queue.containsKey(layer) || this.getUploaded(layer) != null || this.additional != null && this.additional.containsKey(layer);
    }

    public int size(RenderType layer) {
        BufferHolder queued = (BufferHolder)this.queue.get(layer);
        if (queued == null && (queued = this.getUploaded(layer)) != null) {
            return queued.length();
        }
        int size = queued.length();
        if (this.additional != null && (queued = (BufferHolder)this.additional.get(layer)) != null) {
            size += queued.length();
        }
        return size;
    }

    public void add(RenderType layer, BufferBuilder builder, ChunkLayerCache cache) {
        BufferHolder holder = this.get(layer);
        if (holder == null) {
            return;
        }
        this.queue.remove(layer);
        this.uploaded.put(layer, (Object)cache.add(builder, holder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(RenderType layer, int[] indexes, BufferBuilder.RenderedBuffer buffer) {
        BlockBufferCache blockBufferCache = this;
        synchronized (blockBufferCache) {
            if (buffer == null && this.additional == null) {
                this.uploaded.remove(layer);
            }
            if (buffer == null) {
                this.queue.remove(layer);
            } else {
                this.queue.put(layer, (Object)new ByteBufferHolder(buffer, indexes));
            }
        }
    }

    public synchronized void setEmpty() {
        this.queue.clear();
        this.uploaded.clear();
    }

    public boolean hasAdditional() {
        return this.additional != null;
    }

    public void afterRendered() {
        if (this.additional != null) {
            this.additional = null;
        }
    }

    public synchronized void additional(RenderType layer, BufferHolder holder) {
        boolean already;
        boolean bl = already = this.additional != null;
        if (!already) {
            this.additional = new ChunkLayerMap();
        }
        this.additional.put(layer, (Object)(already ? BlockBufferCache.combine((BufferHolder)this.additional.get(layer), holder) : holder));
    }

    public synchronized void additional(LayeredBufferCache cache) {
        boolean already;
        boolean bl = already = this.additional != null;
        if (!already) {
            this.additional = new ChunkLayerMap();
        }
        for (RenderType layer : RenderType.m_110506_()) {
            this.additional.put(layer, (Object)(already ? BlockBufferCache.combine((BufferHolder)this.additional.get(layer), cache.get(layer)) : cache.get(layer)));
        }
    }

    public boolean hasInvalidBuffers() {
        for (Map.Entry entry : this.uploaded.tuples()) {
            if (entry.getValue() == null || !((UploadableBufferHolder)entry.getValue()).isInvalid() && ((UploadableBufferHolder)entry.getValue()).isAvailable() || this.queue.containsKey((RenderType)entry.getKey())) continue;
            return true;
        }
        return false;
    }
}

