/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache;

import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.BufferBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import team.creative.creativecore.mixin.BufferBuilderAccessor;
import team.creative.littletiles.client.render.cache.buffer.BufferHolder;
import team.creative.littletiles.client.render.cache.buffer.UploadableBufferHolder;

public class ChunkLayerCache {
    private int totalSize;
    private List<UploadableBufferHolder> holders = new ArrayList<UploadableBufferHolder>();

    public UploadableBufferHolder add(BufferBuilder builder, BufferHolder data) {
        int index = ((BufferBuilderAccessor)builder).getNextElementByte();
        ByteBuffer buffer = data.byteBuffer();
        if (buffer == null) {
            return null;
        }
        builder.putBulkData(buffer);
        buffer.rewind();
        UploadableBufferHolder holder = new UploadableBufferHolder(buffer, index, data.length(), data.vertexCount(), data.indexes());
        this.holders.add(holder);
        this.totalSize = ((BufferBuilderAccessor)builder).getNextElementByte();
        return holder;
    }

    public void discard() {
        for (UploadableBufferHolder holder : this.holders) {
            holder.invalidate();
        }
    }

    public int totalSize() {
        return this.totalSize;
    }

    public void download(ByteBuffer buffer) {
        for (UploadableBufferHolder holder : this.holders) {
            if (buffer.capacity() >= holder.index + holder.length()) {
                ByteBuffer downloaded = MemoryTracker.m_182527_((int)holder.length());
                downloaded.put(0, buffer, holder.index, holder.length());
                downloaded.rewind();
                holder.downloaded(downloaded);
                continue;
            }
            holder.invalidate();
        }
        buffer.rewind();
    }

    public void uploaded(boolean doNotErase) {
        for (UploadableBufferHolder holder : this.holders) {
            holder.uploaded(doNotErase);
        }
    }

    public boolean isEmpty() {
        return this.holders.isEmpty();
    }
}

