/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.buffer;

import com.mojang.blaze3d.platform.MemoryTracker;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.world.phys.Vec3;
import team.creative.littletiles.client.render.cache.buffer.ByteBufferHolder;
import team.creative.littletiles.client.render.mc.VertexFormatUtils;

public interface BufferHolder {
    public ByteBuffer byteBuffer();

    public int[] indexes();

    public int indexCount();

    public void removeEntry(int var1, int var2);

    public int length();

    public int vertexCount();

    default public BufferHolder extract(int index) {
        int[] indexes = this.indexes();
        if (indexes == null) {
            return null;
        }
        ByteBuffer buffer = this.byteBuffer();
        if (buffer == null) {
            return null;
        }
        int start = -1;
        int length = -1;
        int entryIndex = -1;
        for (int i = 0; i < indexes.length; i += 2) {
            if (indexes[i] == index) {
                start = indexes[i + 1];
                entryIndex = i;
                continue;
            }
            if (start == -1) continue;
            length = indexes[i + 1] - start;
            break;
        }
        if (start == -1) {
            return null;
        }
        if (length == -1) {
            length = this.length() - start;
        }
        if (length == 0) {
            return null;
        }
        int div = this.length() / this.vertexCount();
        int vertexCount = length / div;
        ByteBuffer newBuffer = MemoryTracker.m_182527_((int)length);
        newBuffer.put(0, buffer, start, length);
        newBuffer.rewind();
        this.removeEntry(length, vertexCount);
        if (entryIndex < indexes.length - 2) {
            buffer.put(start, buffer, start + length, buffer.limit() - (start + length));
            for (int i = start + 2; i < indexes.length; i += 2) {
                int n = i + 1;
                indexes[n] = indexes[n] - length;
            }
        }
        buffer.limit(buffer.limit() - length);
        return new ByteBufferHolder(newBuffer, length, vertexCount, null);
    }

    default public void applyOffset(Vec3 vec) {
        ByteBuffer buffer = this.byteBuffer();
        if (buffer == null) {
            return;
        }
        int positionOffset = VertexFormatUtils.blockPositionOffset();
        int formatSize = VertexFormatUtils.blockFormatSize();
        buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < buffer.limit(); i += formatSize) {
            float x = buffer.getFloat(i + positionOffset);
            buffer.putFloat(i + positionOffset, x + (float)vec.f_82479_);
            float y = buffer.getFloat(i + positionOffset + 4);
            buffer.putFloat(i + positionOffset + 4, y + (float)vec.f_82480_);
            float z = buffer.getFloat(i + positionOffset + 8);
            buffer.putFloat(i + positionOffset + 8, z + (float)vec.f_82481_);
        }
    }
}

