/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.buffer;

import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.BufferBuilder;
import java.nio.ByteBuffer;
import team.creative.littletiles.client.render.cache.buffer.BufferHolder;

public class ByteBufferHolder
implements BufferHolder {
    private final ByteBuffer buffer;
    private int length;
    private int vertexCount;
    private final int[] indexes;
    private int indexCount;

    public ByteBufferHolder(ByteBuffer buffer, int length, int vertexCount, int[] indexes) {
        this.buffer = buffer;
        this.length = length;
        this.vertexCount = vertexCount;
        this.indexes = indexes;
        this.indexCount = indexes != null ? indexes.length / 2 : 0;
    }

    public ByteBufferHolder(BufferBuilder.RenderedBuffer buffer, int[] indexes) {
        this.length = buffer.m_231198_().m_166812_();
        this.buffer = MemoryTracker.m_182527_((int)this.length);
        this.buffer.put(buffer.m_231196_());
        this.buffer.rewind();
        this.vertexCount = buffer.m_231198_().f_85734_();
        buffer.m_231200_();
        this.indexes = indexes;
        this.indexCount = indexes != null ? indexes.length / 2 : 0;
    }

    @Override
    public int[] indexes() {
        return this.indexes;
    }

    @Override
    public int indexCount() {
        return this.indexCount;
    }

    @Override
    public void removeEntry(int length, int vertexCount) {
        this.length -= length;
        this.vertexCount -= vertexCount;
        --this.indexCount;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.buffer;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int vertexCount() {
        return this.vertexCount;
    }
}

