/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.PrioritizeChunkUpdates;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;
import org.joml.Matrix4f;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.level.little.LittleClientLevel;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.client.render.level.LittleRenderChunk;
import team.creative.littletiles.client.render.level.LittleRenderChunks;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.entity.level.LittleLevelEntity;

@OnlyIn(value=Dist.CLIENT)
public class LittleLevelRenderManager
extends LittleEntityRenderManager<LittleLevelEntity>
implements Iterable<LittleRenderChunk> {
    private static final Minecraft mc = Minecraft.m_91087_();
    private Vec3d camera;
    private Vec3d chunkCamera = new Vec3d(0.0, 0.0, 0.0);
    private BlockPos.MutableBlockPos cameraPos = new BlockPos.MutableBlockPos();
    private HashMap<Long, LittleRenderChunk> chunks = new HashMap();
    private LittleRenderChunks sortedChunks = new LittleRenderChunks();
    @Nullable
    public Future<?> lastFullRenderChunkUpdate;
    private final BlockingQueue<LittleRenderChunk> queuedCompiled = new LinkedBlockingQueue<LittleRenderChunk>();
    private final BlockingQueue<LittleRenderChunk> emptyCompiled = new LinkedBlockingQueue<LittleRenderChunk>();

    public LittleLevelRenderManager(LittleLevelEntity entity) {
        super(entity);
    }

    @Override
    public RenderChunkExtender getRenderChunk(BlockPos pos) {
        return this.getOrCreateChunk(pos);
    }

    public synchronized LittleRenderChunk getChunk(BlockPos pos) {
        return this.chunks.get(SectionPos.m_175568_((BlockPos)pos));
    }

    public synchronized LittleRenderChunk getOrCreateChunk(BlockPos pos) {
        return this.getChunk(SectionPos.m_123199_((BlockPos)pos), true);
    }

    public synchronized LittleRenderChunk getChunk(SectionPos pos, boolean create) {
        long value = pos.m_123252_();
        LittleRenderChunk chunk = this.chunks.get(value);
        if (chunk == null && create) {
            return this.create(pos);
        }
        return chunk;
    }

    private LittleRenderChunk create(SectionPos pos) {
        if (Minecraft.m_91087_().m_18695_()) {
            LittleRenderChunk chunk = new LittleRenderChunk(this, pos);
            this.chunks.put(pos.m_123252_(), chunk);
            return chunk;
        }
        CompletableFuture future = Minecraft.m_91087_().m_18691_(() -> {
            LittleRenderChunk created = new LittleRenderChunk(this, pos);
            this.chunks.put(pos.m_123252_(), created);
            return created;
        });
        try {
            return (LittleRenderChunk)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<Void> uploadChunkLayer(BufferBuilder.RenderedBuffer rendered, VertexBuffer buffer) {
        return LittleTilesClient.ANIMATION_HANDLER.uploadChunkLayer(rendered, buffer);
    }

    public void schedule(LittleRenderChunk.ChunkCompileTask task) {
        LittleTilesClient.ANIMATION_HANDLER.schedule(task);
    }

    public void emptyChunk(LittleRenderChunk chunk) {
        this.emptyCompiled.add(chunk);
    }

    public void queueChunk(LittleRenderChunk chunk) {
        if (chunk.considered.compareAndSet(false, true)) {
            this.queuedCompiled.add(chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupRender(Camera camera, @Nullable Frustum frustum, boolean capturedFrustum, boolean spectator) {
        super.setupRender(camera, frustum, capturedFrustum, spectator);
        LittleLevelRenderManager littleLevelRenderManager = this;
        synchronized (littleLevelRenderManager) {
            while (!this.emptyCompiled.isEmpty()) {
                LittleRenderChunk chunk = (LittleRenderChunk)this.emptyCompiled.poll();
                if (chunk.considered.compareAndSet(true, false)) {
                    this.sortedChunks.remove(chunk);
                }
                this.chunks.remove(chunk.section.m_123252_());
                chunk.releaseBuffers();
            }
        }
        Vec3d cam = new Vec3d(camera.m_90583_());
        ((LittleLevelEntity)this.entity).getOrigin().transformPointToFakeWorld(cam);
        this.camera = cam;
        this.cameraPos.m_122169_(cam.x, cam.y, cam.z);
        BlockPos cameraPos = this.getCameraBlockPos();
        Vec3d chunkCamera = new Vec3d(Math.floor(cam.x / 8.0), Math.floor(cam.y / 8.0), Math.floor(cam.z / 8.0));
        this.needsFullRenderChunkUpdate |= this.chunkCamera.equals((Object)chunkCamera);
        this.chunkCamera = chunkCamera;
        if (capturedFrustum || !this.isInSight.booleanValue()) {
            return;
        }
        if (this.needsFullRenderChunkUpdate && (this.lastFullRenderChunkUpdate == null || this.lastFullRenderChunkUpdate.isDone())) {
            this.needsFullRenderChunkUpdate = false;
            this.queuedCompiled.clear();
            this.sortedChunks.arrangeRings(SectionPos.m_123199_((BlockPos)cameraPos), this.chunks.values());
        } else {
            LittleLevelRenderManager littleLevelRenderManager2 = this;
            synchronized (littleLevelRenderManager2) {
                while (!this.queuedCompiled.isEmpty()) {
                    LittleRenderChunk chunk = (LittleRenderChunk)this.queuedCompiled.poll();
                    if (!chunk.considered.compareAndSet(false, true)) continue;
                    this.sortedChunks.add(chunk);
                }
            }
        }
    }

    @Override
    public void compileChunks(Camera camera) {
        mc.m_91307_().m_6180_("compile_animation_chunks");
        ArrayList schedule = Lists.newArrayList();
        LittleClientLevel level = (LittleClientLevel)((Object)this.getLevel());
        for (LittleRenderChunk chunk : this) {
            ChunkPos chunkpos = new ChunkPos(chunk.pos);
            if (!chunk.isDirty() || ((LittleLevelEntity)this.entity).isReal() && !level.m_6325_(chunkpos.f_45578_, chunkpos.f_45579_).m_196863_()) continue;
            boolean immediate = false;
            if (LittleLevelRenderManager.mc.f_91066_.m_232080_().m_231551_() == PrioritizeChunkUpdates.PLAYER_AFFECTED) {
                immediate = chunk.isDirtyFromPlayer();
            } else if (LittleLevelRenderManager.mc.f_91066_.m_232080_().m_231551_() == PrioritizeChunkUpdates.NEARBY) {
                boolean bl = immediate = (Boolean)ForgeConfig.CLIENT.alwaysSetupTerrainOffThread.get() == false && (chunk.pos.m_7918_(8, 8, 8).m_123331_((Vec3i)this.getCameraBlockPos()) < 768.0 || chunk.isDirtyFromPlayer());
            }
            if (immediate) {
                chunk.compile();
                chunk.setNotDirty();
                continue;
            }
            schedule.add(chunk);
        }
        for (LittleRenderChunk chunk : schedule) {
            chunk.compileASync();
            chunk.setNotDirty();
        }
        mc.m_91307_().m_7238_();
    }

    @Override
    protected void renderAllBlockEntities(PoseStack pose, Frustum frustum, Vec3 cam, float frameTime, MultiBufferSource bufferSource) {
        for (LittleRenderChunk chunk : this) {
            List list = chunk.getCompiledChunk().m_112773_();
            if (list.isEmpty()) continue;
            for (BlockEntity blockentity : list) {
                this.renderBlockEntity(blockentity, pose, frustum, cam, frameTime, bufferSource);
            }
        }
    }

    @Override
    public void resortTransparency(RenderType layer, double x, double y, double z) {
        int i = 0;
        for (LittleRenderChunk chunk : this.visibleChunks()) {
            if (i > 14) {
                return;
            }
            if (!chunk.resortTransparency(layer)) continue;
            ++i;
        }
    }

    @Override
    public void renderChunkLayer(RenderType layer, PoseStack pose, double x, double y, double z, Matrix4f projectionMatrix, Uniform offset) {
        Iterator<LittleRenderChunk> iterator;
        Iterator<LittleRenderChunk> iterator2 = iterator = layer == RenderType.m_110466_() ? this.visibleChunksInverse() : this.visibleChunks().iterator();
        while (iterator.hasNext()) {
            LittleRenderChunk chunk = iterator.next();
            if (chunk.getCompiledChunk().m_112758_(layer)) continue;
            VertexBuffer vertexbuffer = chunk.getVertexBuffer(layer);
            if (offset != null) {
                offset.m_5889_((float)((double)chunk.pos.m_123341_() - x), (float)((double)chunk.pos.m_123342_() - y), (float)((double)chunk.pos.m_123343_() - z));
                offset.m_85633_();
            }
            vertexbuffer.m_85921_();
            vertexbuffer.m_166882_();
        }
        if (offset != null) {
            offset.m_5889_(0.0f, 0.0f, 0.0f);
        }
    }

    public ChunkBufferBuilderPack fixedBuffers() {
        return LittleTilesClient.ANIMATION_HANDLER.fixedBuffers;
    }

    @Override
    protected void setSectionDirty(int x, int y, int z, boolean playerChanged) {
        LittleRenderChunk chunk = this.chunks.get(SectionPos.m_123209_((int)x, (int)y, (int)z));
        if (chunk == null) {
            chunk = this.create(SectionPos.m_123173_((int)x, (int)y, (int)z));
        }
        chunk.setDirty(playerChanged);
    }

    public Vec3d getCameraPosition() {
        return this.camera;
    }

    public BlockPos getCameraBlockPos() {
        return this.cameraPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGlobalBlockEntities(Collection<BlockEntity> oldBlockEntities, Collection<BlockEntity> newBlockEntities) {
        Set set = this.globalBlockEntities;
        synchronized (set) {
            this.globalBlockEntities.removeAll(oldBlockEntities);
            this.globalBlockEntities.addAll(newBlockEntities);
        }
    }

    @Override
    public synchronized void unload() {
        for (LittleRenderChunk chunk : this) {
            chunk.releaseBuffers();
        }
        super.unload();
    }

    @Override
    public Iterator<LittleRenderChunk> iterator() {
        return this.chunks.values().iterator();
    }

    public Iterable<LittleRenderChunk> visibleChunks() {
        return this.sortedChunks;
    }

    public Iterator<LittleRenderChunk> visibleChunksInverse() {
        return this.sortedChunks.inverseIterator();
    }

    @Override
    public void allChanged() {
        super.allChanged();
        this.needsFullRenderChunkUpdate = true;
        if (this.lastFullRenderChunkUpdate != null) {
            try {
                this.lastFullRenderChunkUpdate.get();
                this.lastFullRenderChunkUpdate = null;
            }
            catch (Exception exception) {
                LittleTiles.LOGGER.warn("Full update failed", (Throwable)exception);
            }
        }
        this.queuedCompiled.clear();
    }
}

