/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.level;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.render.cache.ChunkLayerCache;
import team.creative.littletiles.client.render.entity.LittleLevelRenderManager;
import team.creative.littletiles.client.render.level.LittleChunkDispatcher;
import team.creative.littletiles.client.render.mc.RebuildTaskExtender;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.mixin.client.render.CompiledChunkAccessor;

@OnlyIn(value=Dist.CLIENT)
public class LittleRenderChunk
implements RenderChunkExtender {
    public final LittleLevelRenderManager manager;
    public final SectionPos section;
    public final BlockPos pos;
    public final AtomicReference<ChunkRenderDispatcher.CompiledChunk> compiled = new AtomicReference<ChunkRenderDispatcher.CompiledChunk>(ChunkRenderDispatcher.CompiledChunk.f_112748_);
    private AABB bb;
    public final AtomicBoolean considered = new AtomicBoolean();
    @Nullable
    private RebuildTask lastRebuildTask;
    @Nullable
    private ResortTransparencyTask lastResortTransparencyTask;
    private final Set<BlockEntity> globalBlockEntities = Sets.newHashSet();
    private final ChunkLayerMap<VertexBuffer> buffers = new ChunkLayerMap(x -> new VertexBuffer());
    private boolean dirty = true;
    private final SectionPos[] neighbors;
    private boolean playerChanged;
    private boolean dynamicLightUpdate = false;

    public LittleRenderChunk(LittleLevelRenderManager manager, SectionPos pos) {
        this.manager = manager;
        this.section = pos;
        this.pos = this.section.m_123249_();
        this.bb = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 16), (double)(pos.m_123342_() + 16), (double)(pos.m_123343_() + 16));
        this.neighbors = new SectionPos[Direction.values().length];
        for (int i = 0; i < this.neighbors.length; ++i) {
            Direction direction = Direction.values()[i];
            this.neighbors[i] = SectionPos.m_123173_((int)(this.section.m_123341_() + direction.m_122429_()), (int)(this.section.m_123342_() + direction.m_122430_()), (int)(this.section.m_123343_() + direction.m_122431_()));
        }
    }

    @Override
    public boolean dynamicLightUpdate() {
        return this.dynamicLightUpdate;
    }

    @Override
    public void dynamicLightUpdate(boolean value) {
        this.dynamicLightUpdate = value;
    }

    public LittleSubLevel level() {
        return this.manager.getLevel();
    }

    private boolean doesChunkExistAt(SectionPos pos) {
        return this.level().m_6522_(pos.m_123341_(), pos.m_123343_(), ChunkStatus.f_62326_, false) != null;
    }

    public boolean hasAllNeighbors() {
        if (this.getDistToPlayerSqr() <= 576.0) {
            return true;
        }
        return this.doesChunkExistAt(this.neighbors[Direction.WEST.ordinal()]) && this.doesChunkExistAt(this.neighbors[Direction.NORTH.ordinal()]) && this.doesChunkExistAt(this.neighbors[Direction.EAST.ordinal()]) && this.doesChunkExistAt(this.neighbors[Direction.SOUTH.ordinal()]);
    }

    public AABB getBB() {
        return this.bb;
    }

    @Override
    public Vec3i standardOffset() {
        return this.pos;
    }

    @Override
    public VertexBuffer getVertexBuffer(RenderType layer) {
        return (VertexBuffer)this.buffers.get(layer);
    }

    protected double getDistToPlayerSqr() {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cam = this.level().getOrigin().transformPointToFakeWorld(camera.m_90583_());
        Vec3 center = this.bb.m_82399_();
        double d0 = center.f_82479_ - cam.f_82479_;
        double d1 = center.f_82480_ - cam.f_82480_;
        double d2 = center.f_82481_ - cam.f_82481_;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public ChunkRenderDispatcher.CompiledChunk getCompiledChunk() {
        return this.compiled.get();
    }

    @Override
    public void begin(BufferBuilder builder) {
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
    }

    private void reset() {
        this.cancelTasks();
        this.compiled.set(ChunkRenderDispatcher.CompiledChunk.f_112748_);
        this.dirty = true;
    }

    public void releaseBuffers() {
        this.reset();
        this.buffers.forEach(VertexBuffer::close);
    }

    public void setDirty(boolean playerChanged) {
        boolean flag = this.dirty;
        this.dirty = true;
        this.playerChanged = playerChanged | (flag && this.playerChanged);
    }

    public void setNotDirty() {
        this.dirty = false;
        this.playerChanged = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markReadyForUpdate(boolean playerChanged) {
        this.setDirty(playerChanged);
    }

    public boolean isDirtyFromPlayer() {
        return this.dirty && this.playerChanged;
    }

    public boolean resortTransparency(RenderType layer) {
        ChunkRenderDispatcher.CompiledChunk compiled = this.getCompiledChunk();
        if (this.lastResortTransparencyTask != null) {
            this.lastResortTransparencyTask.cancel();
        }
        if (!((CompiledChunkAccessor)compiled).getHasBlocks().contains(layer)) {
            return false;
        }
        this.lastResortTransparencyTask = new ResortTransparencyTask(this.section.m_123251_(), this.getDistToPlayerSqr(), compiled);
        this.manager.schedule(this.lastResortTransparencyTask);
        return true;
    }

    protected boolean cancelTasks() {
        boolean flag = false;
        if (this.lastRebuildTask != null) {
            this.lastRebuildTask.cancel();
            this.lastRebuildTask = null;
            flag = true;
        }
        if (this.lastResortTransparencyTask != null) {
            this.lastResortTransparencyTask.cancel();
            this.lastResortTransparencyTask = null;
        }
        return flag;
    }

    public ChunkCompileTask createCompileTask() {
        boolean canceled = this.cancelTasks();
        this.lastRebuildTask = new RebuildTask(this.section.m_123251_(), this.getDistToPlayerSqr(), this.level().asLevel(), canceled || this.compiled.get() != ChunkRenderDispatcher.CompiledChunk.f_112748_);
        return this.lastRebuildTask;
    }

    public void compileASync() {
        this.manager.schedule(this.createCompileTask());
    }

    public void compile() {
        this.createCompileTask().doTask(this.manager.fixedBuffers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGlobalBlockEntities(Collection<BlockEntity> blockEntities) {
        HashSet set1;
        HashSet set = Sets.newHashSet(blockEntities);
        Set<BlockEntity> set2 = this.globalBlockEntities;
        synchronized (set2) {
            set1 = Sets.newHashSet(this.globalBlockEntities);
            set.removeAll(this.globalBlockEntities);
            set1.removeAll(blockEntities);
            this.globalBlockEntities.clear();
            this.globalBlockEntities.addAll(blockEntities);
        }
        this.manager.updateGlobalBlockEntities(set1, set);
    }

    @Override
    public BufferBuilder.SortState getTransparencyState() {
        return ((CompiledChunkAccessor)this.getCompiledChunk()).getTransparencyState();
    }

    @Override
    public void setHasBlock(RenderType layer) {
        ChunkRenderDispatcher.CompiledChunk compiled = this.getCompiledChunk();
        if (compiled != ChunkRenderDispatcher.CompiledChunk.f_112748_) {
            ((CompiledChunkAccessor)compiled).getHasBlocks().add(layer);
        }
    }

    @Override
    public boolean isEmpty(RenderType layer) {
        return this.getCompiledChunk().m_112758_(layer);
    }

    @Override
    public void setQuadSortOrigin(BufferBuilder builder, Vec3 cam) {
        builder.m_166771_((float)cam.f_82479_ - (float)this.pos.m_123341_(), (float)cam.f_82480_ - (float)this.pos.m_123342_(), (float)cam.f_82481_ - (float)this.pos.m_123343_());
    }

    @OnlyIn(value=Dist.CLIENT)
    class ResortTransparencyTask
    extends ChunkCompileTask {
        private final ChunkRenderDispatcher.CompiledChunk compiledChunk;

        @Deprecated
        public ResortTransparencyTask(double distAtCreation, ChunkRenderDispatcher.CompiledChunk chunk) {
            this(null, distAtCreation, chunk);
        }

        public ResortTransparencyTask(ChunkPos pos, double distAtCreation, ChunkRenderDispatcher.CompiledChunk chunk) {
            super(pos, distAtCreation, true);
            this.compiledChunk = chunk;
        }

        @Override
        public String name() {
            return "rend_chk_sort";
        }

        @Override
        public CompletableFuture<ChunkTaskResult> doTask(ChunkBufferBuilderPack p_112893_) {
            if (this.isCancelled.get()) {
                return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
            }
            if (this.isCancelled.get()) {
                return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
            }
            if (!LittleRenderChunk.this.hasAllNeighbors()) {
                this.isCancelled.set(true);
                return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
            }
            Vec3d cam = LittleRenderChunk.this.manager.getCameraPosition();
            BufferBuilder.SortState sortstate = ((CompiledChunkAccessor)this.compiledChunk).getTransparencyState();
            if (sortstate != null && !this.compiledChunk.m_112758_(RenderType.m_110466_())) {
                BufferBuilder bufferbuilder = p_112893_.m_108839_(RenderType.m_110466_());
                LittleRenderChunk.this.begin(bufferbuilder);
                bufferbuilder.m_166775_(sortstate);
                bufferbuilder.m_166771_((float)cam.x - (float)LittleRenderChunk.this.pos.m_123341_(), (float)cam.y - (float)LittleRenderChunk.this.pos.m_123342_(), (float)cam.z - (float)LittleRenderChunk.this.pos.m_123343_());
                ((CompiledChunkAccessor)this.compiledChunk).setTransparencyState(bufferbuilder.m_166770_());
                BufferBuilder.RenderedBuffer rendered = bufferbuilder.m_231175_();
                if (this.isCancelled.get()) {
                    rendered.m_231200_();
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                CompletionStage completablefuture = LittleRenderChunk.this.manager.uploadChunkLayer(rendered, LittleRenderChunk.this.getVertexBuffer(RenderType.m_110466_())).thenApply(x -> ChunkTaskResult.CANCELLED);
                return ((CompletableFuture)completablefuture).handle((result, exception) -> {
                    if (exception != null && !(exception instanceof CancellationException) && !(exception instanceof InterruptedException)) {
                        Minecraft.m_91087_().m_231412_(CrashReport.m_127521_((Throwable)exception, (String)"Rendering chunk"));
                    }
                    return this.isCancelled.get() ? ChunkTaskResult.CANCELLED : ChunkTaskResult.SUCCESSFUL;
                });
            }
            return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
        }

        @Override
        public void cancel() {
            this.isCancelled.set(true);
        }
    }

    public abstract class ChunkCompileTask
    implements Comparable<ChunkCompileTask> {
        protected final double distAtCreation;
        protected final AtomicBoolean isCancelled = new AtomicBoolean(false);
        public final boolean isHighPriority;
        protected Map<BlockPos, ModelData> modelData;

        public ChunkCompileTask(ChunkPos pos, double distAtCreation, boolean isHighPriority) {
            this.distAtCreation = distAtCreation;
            this.isHighPriority = isHighPriority;
            this.modelData = pos == null ? Collections.EMPTY_MAP : LittleRenderChunk.this.level().getModelDataManager().getAt(pos);
        }

        public abstract CompletableFuture<ChunkTaskResult> doTask(ChunkBufferBuilderPack var1);

        public abstract void cancel();

        public abstract String name();

        @Override
        public int compareTo(ChunkCompileTask other) {
            return Doubles.compare((double)this.distAtCreation, (double)other.distAtCreation);
        }

        public ModelData getModelData(BlockPos pos) {
            return this.modelData.getOrDefault(pos, ModelData.EMPTY);
        }
    }

    class RebuildTask
    extends ChunkCompileTask
    implements RebuildTaskExtender {
        @Nullable
        protected Level level;
        private ChunkLayerMap<ChunkLayerCache> caches;
        private ChunkBufferBuilderPack pack;
        private Set<RenderType> renderTypes;

        @Deprecated
        public RebuildTask(double distAtCreation, Level level, boolean isHighPriority) {
            this(null, distAtCreation, level, isHighPriority);
        }

        public RebuildTask(ChunkPos pos, @Nullable double distAtCreation, Level level, boolean isHighPriority) {
            super(pos, distAtCreation, isHighPriority);
            this.level = level;
        }

        @Override
        public String name() {
            return "rend_chk_rebuild";
        }

        @Override
        public CompletableFuture<ChunkTaskResult> doTask(ChunkBufferBuilderPack pack) {
            if (this.isCancelled.get()) {
                return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
            }
            if (this.isCancelled.get()) {
                return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
            }
            Vec3d cam = LittleRenderChunk.this.manager.getCameraPosition();
            CompileResults results = this.compile((float)cam.x, (float)cam.y, (float)cam.z, pack);
            LittleRenderChunk.this.updateGlobalBlockEntities(results.globalBlockEntities);
            if (this.isCancelled.get()) {
                results.renderedLayers.values().forEach(BufferBuilder.RenderedBuffer::m_231200_);
                return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
            }
            if (results.isEmpty()) {
                LittleRenderChunk.this.manager.emptyChunk(LittleRenderChunk.this);
                LittleRenderChunk.this.compiled.set(ChunkRenderDispatcher.CompiledChunk.f_112748_);
                results.renderedLayers.values().forEach(BufferBuilder.RenderedBuffer::m_231200_);
                return CompletableFuture.completedFuture(ChunkTaskResult.SUCCESSFUL);
            }
            ChunkRenderDispatcher.CompiledChunk compiled = new ChunkRenderDispatcher.CompiledChunk();
            ((CompiledChunkAccessor)compiled).setVisibilitySet(results.visibilitySet);
            compiled.m_112773_().addAll(results.blockEntities);
            ((CompiledChunkAccessor)compiled).setTransparencyState(results.transparencyState);
            ArrayList list = Lists.newArrayList();
            results.renderedLayers.forEach((layer, buffer) -> {
                list.add(LittleRenderChunk.this.manager.uploadChunkLayer((BufferBuilder.RenderedBuffer)buffer, LittleRenderChunk.this.getVertexBuffer((RenderType)layer)));
                ((CompiledChunkAccessor)compiled).getHasBlocks().add((RenderType)layer);
            });
            return Util.m_143840_((List)list).handle((voids, throwable) -> {
                if (throwable != null && !(throwable instanceof CancellationException) && !(throwable instanceof InterruptedException)) {
                    Minecraft.m_91087_().m_231412_(CrashReport.m_127521_((Throwable)throwable, (String)"Rendering chunk"));
                }
                if (this.isCancelled.get()) {
                    return ChunkTaskResult.CANCELLED;
                }
                LittleRenderChunk.this.compiled.set(compiled);
                LittleRenderChunk.this.manager.queueChunk(LittleRenderChunk.this);
                return ChunkTaskResult.SUCCESSFUL;
            });
        }

        private CompileResults compile(float x, float y, float z, ChunkBufferBuilderPack pack) {
            this.pack = pack;
            LittleChunkDispatcher.startCompile(LittleRenderChunk.this);
            CompileResults results = new CompileResults();
            BlockPos maxPos = LittleRenderChunk.this.pos.m_7918_(15, 15, 15);
            VisGraph visgraph = new VisGraph();
            Level renderchunkregion = this.level;
            this.level = null;
            PoseStack posestack = new PoseStack();
            if (renderchunkregion != null) {
                BufferBuilder bufferbuilder1;
                ModelBlockRenderer.m_111000_();
                this.renderTypes = new ReferenceArraySet(RenderType.m_110506_().size());
                RandomSource randomsource = RandomSource.m_216327_();
                BlockRenderDispatcher blockrenderdispatcher = Minecraft.m_91087_().m_91289_();
                for (BlockPos blockpos2 : BlockPos.m_121940_((BlockPos)LittleRenderChunk.this.pos, (BlockPos)maxPos)) {
                    BlockState blockstate1;
                    FluidState fluidstate;
                    BlockEntity blockentity;
                    BlockState blockstate = renderchunkregion.m_8055_(blockpos2);
                    if (blockstate.m_60804_((BlockGetter)renderchunkregion, blockpos2)) {
                        visgraph.m_112971_(blockpos2);
                    }
                    if (blockstate.m_155947_() && (blockentity = renderchunkregion.m_7702_(blockpos2)) != null) {
                        this.handleBlockEntity(results, blockentity);
                    }
                    if (!(fluidstate = (blockstate1 = renderchunkregion.m_8055_(blockpos2)).m_60819_()).m_76178_()) {
                        RenderType rendertype = ItemBlockRenderTypes.m_109287_((FluidState)fluidstate);
                        BufferBuilder bufferbuilder = pack.m_108839_(rendertype);
                        if (this.renderTypes.add(rendertype)) {
                            LittleRenderChunk.this.begin(bufferbuilder);
                        }
                        blockrenderdispatcher.m_234363_(blockpos2, (BlockAndTintGetter)renderchunkregion, (VertexConsumer)bufferbuilder, blockstate1, fluidstate);
                    }
                    if (blockstate.m_60799_() == RenderShape.INVISIBLE) continue;
                    BakedModel model = blockrenderdispatcher.m_110910_(blockstate);
                    ModelData modelData = this.getModelData(blockpos2);
                    randomsource.m_188584_(blockstate.m_60726_(blockpos2));
                    for (RenderType rendertype2 : model.getRenderTypes(blockstate, randomsource, modelData)) {
                        BufferBuilder bufferbuilder2 = pack.m_108839_(rendertype2);
                        if (this.renderTypes.add(rendertype2)) {
                            LittleRenderChunk.this.begin(bufferbuilder2);
                        }
                        posestack.m_85836_();
                        posestack.m_252880_((float)(blockpos2.m_123341_() & 0xF), (float)(blockpos2.m_123342_() & 0xF), (float)(blockpos2.m_123343_() & 0xF));
                        blockrenderdispatcher.renderBatched(blockstate, blockpos2, (BlockAndTintGetter)renderchunkregion, posestack, (VertexConsumer)bufferbuilder2, true, randomsource, modelData, rendertype2);
                        posestack.m_85849_();
                    }
                }
                if (this.renderTypes.contains(RenderType.m_110466_()) && !(bufferbuilder1 = pack.m_108839_(RenderType.m_110466_())).m_231164_()) {
                    bufferbuilder1.m_166771_(x - (float)LittleRenderChunk.this.pos.m_123341_(), y - (float)LittleRenderChunk.this.pos.m_123342_(), z - (float)LittleRenderChunk.this.pos.m_123343_());
                    results.transparencyState = bufferbuilder1.m_166770_();
                }
                for (RenderType rendertype1 : this.renderTypes) {
                    BufferBuilder.RenderedBuffer rendered = pack.m_108839_(rendertype1).m_231168_();
                    if (rendered == null) continue;
                    results.renderedLayers.put(rendertype1, rendered);
                }
                ModelBlockRenderer.m_111077_();
            }
            results.visibilitySet = visgraph.m_112958_();
            LittleChunkDispatcher.endCompile(LittleRenderChunk.this, this);
            return results;
        }

        private <E extends BlockEntity> void handleBlockEntity(CompileResults results, E entity) {
            BlockEntityRenderer blockentityrenderer;
            if (entity instanceof BETiles) {
                BETiles tiles = (BETiles)entity;
                LittleChunkDispatcher.add(LittleRenderChunk.this, tiles, this);
            }
            if ((blockentityrenderer = Minecraft.m_91087_().m_167982_().m_112265_(entity)) != null) {
                if (blockentityrenderer.m_5932_(entity)) {
                    results.globalBlockEntities.add(entity);
                } else {
                    results.blockEntities.add(entity);
                }
            }
        }

        @Override
        public void cancel() {
            this.level = null;
            if (this.isCancelled.compareAndSet(false, true)) {
                LittleRenderChunk.this.setDirty(false);
            }
        }

        @Override
        public void clear() {
            this.pack = null;
            this.renderTypes = null;
        }

        @Override
        public BufferBuilder builder(RenderType layer) {
            BufferBuilder builder = this.pack.m_108839_(layer);
            if (this.renderTypes.add(layer)) {
                LittleRenderChunk.this.begin(builder);
            }
            return builder;
        }

        @Override
        public ChunkLayerMap<ChunkLayerCache> getLayeredCache() {
            return this.caches;
        }

        @Override
        public ChunkLayerCache getOrCreate(RenderType layer) {
            ChunkLayerCache cache;
            if (this.caches == null) {
                this.caches = new ChunkLayerMap();
            }
            if ((cache = (ChunkLayerCache)this.caches.get(layer)) == null) {
                cache = new ChunkLayerCache();
                this.caches.put(layer, (Object)cache);
            }
            return cache;
        }

        @OnlyIn(value=Dist.CLIENT)
        static final class CompileResults {
            public final List<BlockEntity> globalBlockEntities = new ArrayList<BlockEntity>();
            public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
            public final Map<RenderType, BufferBuilder.RenderedBuffer> renderedLayers = new Reference2ObjectArrayMap();
            public VisibilitySet visibilitySet = new VisibilitySet();
            @Nullable
            public BufferBuilder.SortState transparencyState;

            CompileResults() {
            }

            public boolean isEmpty() {
                return this.renderedLayers.isEmpty() && this.globalBlockEntities.isEmpty() && this.blockEntities.isEmpty();
            }
        }
    }

    public static enum ChunkTaskResult {
        SUCCESSFUL,
        CANCELLED;

    }
}

