/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.tile;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.client.render.model.CreativeBakedQuad;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.type.LittleItemHolder;

public class LittleRenderBoxItem
extends LittleRenderBox {
    private static final Vec3f defaultDirection = new Vec3f(1.0f, 1.0f, 0.0f);
    private static final Vec3f center = new Vec3f(0.5f, 0.5f, 0.5f);
    public final LittleItemHolder structure;

    public LittleRenderBoxItem(LittleItemHolder structure, AlignedBox cube, LittleBox box) {
        super(cube);
        this.box = box;
        this.structure = structure;
        this.allowOverlap = true;
        this.keepVU = true;
    }

    public List<BakedQuad> getBakedQuad(LevelAccessor level, BlockPos pos, BlockPos offset, BlockState state, BakedModel blockModel, Facing facing, RenderType layer, RandomSource rand, boolean overrideTint, int defaultColor) {
        Rotation rotation;
        if (facing != this.structure.facing) {
            return Collections.EMPTY_LIST;
        }
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(this.structure.stack, null, null, 0);
        ArrayList blockQuads = new ArrayList(bakedmodel.m_213637_(null, null, rand));
        for (Direction direction : Direction.values()) {
            List newQuads = bakedmodel.m_213637_(null, direction, rand);
            blockQuads.addAll(newQuads);
        }
        Vec3f topRight = new Vec3f(defaultDirection);
        int rotationSteps = 1;
        boolean flipX = false;
        boolean flipY = false;
        boolean flipZ = false;
        switch (this.structure.facing) {
            case EAST: {
                rotation = Rotation.Y_COUNTER_CLOCKWISE;
                flipX = true;
                break;
            }
            case WEST: {
                rotation = Rotation.Y_CLOCKWISE;
                flipX = true;
                break;
            }
            case UP: {
                flipY = true;
                rotation = Rotation.X_CLOCKWISE;
                break;
            }
            case DOWN: {
                rotation = Rotation.X_CLOCKWISE;
                break;
            }
            case SOUTH: {
                rotation = null;
                break;
            }
            case NORTH: {
                rotation = Rotation.Y_COUNTER_CLOCKWISE;
                rotationSteps = 2;
                flipZ = true;
                break;
            }
            default: {
                rotation = null;
            }
        }
        if (rotation != null) {
            for (int i = 0; i < rotationSteps; ++i) {
                rotation.transform(topRight);
            }
        }
        if (this.structure.topRight.x != 0.0f && this.structure.topRight.x == topRight.x) {
            flipX = true;
        }
        if (this.structure.topRight.y != 0.0f && this.structure.topRight.y != topRight.y) {
            flipY = true;
        }
        if (this.structure.topRight.z != 0.0f && this.structure.topRight.z == topRight.z) {
            flipZ = true;
        }
        float scale = switch (this.structure.facing.axis) {
            case Axis.X -> Math.min(this.getSize(Axis.Y), this.getSize(Axis.Z));
            case Axis.Y -> Math.min(this.getSize(Axis.X), this.getSize(Axis.Z));
            case Axis.Z -> Math.min(this.getSize(Axis.X), this.getSize(Axis.Y));
            default -> 1.0f;
        };
        float offsetX = (this.minX + this.maxX) * 0.5f - 0.5f;
        float offsetY = (this.minY + this.maxY) * 0.5f - 0.5f;
        float offsetZ = (this.minZ + this.maxZ) * 0.5f - 0.5f;
        boolean reverse = ((flipX ? 1 : 0) + (flipY ? 1 : 0) + (flipZ ? 1 : 0)) % 2 == 1;
        VertexFormat format = DefaultVertexFormat.f_85811_;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (int i = 0; i < blockQuads.size(); ++i) {
            int[] originalData = ((BakedQuad)blockQuads.get(i)).m_111303_();
            CreativeBakedQuad quad = new CreativeBakedQuad((BakedQuad)blockQuads.get(i), (RenderBox)this, defaultColor, overrideTint, null);
            for (int k = 0; k < 4; ++k) {
                int index = k * format.m_86017_();
                Vec3f vec = new Vec3f(Float.intBitsToFloat(originalData[index]), Float.intBitsToFloat(originalData[index + 1]), Float.intBitsToFloat(originalData[index + 2]));
                vec.sub(center);
                if (rotation != null) {
                    for (int j = 0; j < rotationSteps; ++j) {
                        rotation.transform(vec);
                    }
                }
                if (flipX) {
                    vec.x = -vec.x;
                }
                if (flipY) {
                    vec.y = -vec.y;
                }
                if (flipZ) {
                    vec.z = -vec.z;
                }
                vec.x *= scale;
                vec.y *= scale;
                vec.z *= scale;
                vec.x += offsetX;
                vec.y += offsetY;
                vec.z += offsetZ;
                vec.add(center);
                int newIndex = index;
                if (reverse) {
                    newIndex = (3 - k) * format.m_86017_();
                }
                quad.m_111303_()[newIndex] = Float.floatToIntBits(vec.x + (float)offset.m_123341_());
                quad.m_111303_()[newIndex + 1] = Float.floatToIntBits(vec.y + (float)offset.m_123342_());
                quad.m_111303_()[newIndex + 2] = Float.floatToIntBits(vec.z + (float)offset.m_123343_());
                if (!reverse) continue;
                for (int j = 3; j < format.m_86017_(); ++j) {
                    quad.m_111303_()[newIndex + j] = originalData[index + j];
                }
            }
            quads.add((BakedQuad)quad);
        }
        return quads;
    }

    public boolean intersectsWithFace(Facing facing, RenderBox.RenderInformationHolder holder, BlockPos offset) {
        return true;
    }
}

