/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.tile;

import java.util.ArrayList;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.creativecore.client.render.face.RenderBoxFace;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.geo.VectorFan;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleTransformableBox;

public class LittleRenderBoxTransformable
extends LittleRenderBox {
    private float scale;
    private float inverseScale;
    public LittleTransformableBox.VectorFanCache cache;

    public LittleRenderBoxTransformable(LittleGrid grid, LittleTransformableBox box) {
        super(grid, box);
        this.cache = box.requestCache();
        this.scale = (float)grid.pixelLength;
        this.inverseScale = grid.count;
    }

    public LittleRenderBoxTransformable(LittleGrid grid, LittleTransformableBox box, BlockState state) {
        super(grid, (LittleBox)box, state);
        this.cache = box.requestCache();
        this.scale = (float)grid.pixelLength;
        this.inverseScale = grid.count;
    }

    public LittleRenderBoxTransformable(LittleGrid grid, LittleTransformableBox box, LittleElement element) {
        super(grid, (LittleBox)box, element);
        this.cache = box.requestCache();
        this.scale = (float)grid.pixelLength;
        this.inverseScale = grid.count;
    }

    public void add(float x, float y, float z) {
        super.add(x, y, z);
        this.cache.add(x * this.inverseScale, y * this.inverseScale, z * this.inverseScale);
    }

    public void sub(float x, float y, float z) {
        super.sub(x, y, z);
        this.cache.sub(x * this.inverseScale, y * this.inverseScale, z * this.inverseScale);
    }

    public void scale(float scale) {
        super.scale(scale);
        this.cache.scale(scale);
    }

    public LittleTransformableBox.VectorFanFaceCache getFaceCache(Facing facing) {
        if (this.cache != null) {
            return this.cache.get(facing);
        }
        return null;
    }

    public boolean shouldRenderFace(Facing facing) {
        LittleTransformableBox.VectorFanFaceCache cache = this.getFaceCache(facing);
        if (cache == null) {
            return false;
        }
        if (super.shouldRenderFace(facing)) {
            return true;
        }
        return cache.hasTiltedStrip();
    }

    protected Object getRenderQuads(Facing facing) {
        if (this.getFace(facing).hasCachedFans()) {
            return this.getFace(facing).getCachedFans();
        }
        LittleTransformableBox.VectorFanFaceCache cache = this.getFaceCache(facing);
        if (cache.hasTiltedStrip()) {
            if (super.shouldRenderFace(facing) && cache.hasAxisStrip()) {
                ArrayList<VectorFan> strips = new ArrayList<VectorFan>(cache.axisStrips);
                if (cache.tiltedStrip1 != null) {
                    strips.add(cache.tiltedStrip1);
                }
                if (cache.tiltedStrip2 != null) {
                    strips.add(cache.tiltedStrip2);
                }
                return strips;
            }
            if (cache.tiltedStrip1 != null ^ cache.tiltedStrip2 != null) {
                if (cache.tiltedStrip1 != null) {
                    return cache.tiltedStrip1;
                }
                return cache.tiltedStrip2;
            }
            ArrayList<VectorFan> strips = new ArrayList<VectorFan>();
            if (cache.tiltedStrip1 != null) {
                strips.add(cache.tiltedStrip1);
            }
            if (cache.tiltedStrip2 != null) {
                strips.add(cache.tiltedStrip2);
            }
            return strips;
        }
        if (super.shouldRenderFace(facing)) {
            return cache.axisStrips;
        }
        return null;
    }

    public float getPreviewOffX() {
        return 0.0f;
    }

    public float getPreviewOffY() {
        return 0.0f;
    }

    public float getPreviewOffZ() {
        return 0.0f;
    }

    public float getPreviewScaleX() {
        return this.scale;
    }

    public float getPreviewScaleY() {
        return this.scale;
    }

    public float getPreviewScaleZ() {
        return this.scale;
    }

    protected boolean scaleAndOffsetQuads(Facing facing) {
        return true;
    }

    protected boolean onlyScaleOnceNoOffset(Facing facing) {
        return true;
    }

    protected float getOverallScale(Facing facing) {
        RenderBoxFace type = this.getFace(facing);
        if (type.hasCachedFans()) {
            return type.getScale();
        }
        return this.scale;
    }
}

