/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.tile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3d;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.type.list.CopyArrayCollection;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.api.common.block.LittleBlock;
import team.creative.littletiles.client.render.block.LittleBlockClientRegistry;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.IngredientUtils;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxCombiner;
import team.creative.littletiles.common.math.box.volume.LittleBoxReturnedVolume;
import team.creative.littletiles.common.math.face.ILittleFace;
import team.creative.littletiles.common.math.vec.LittleVec;

public final class LittleTile
extends LittleElement
implements Iterable<LittleBox> {
    private CopyArrayCollection<LittleBox> boxes;

    public LittleTile(LittleElement element, Iterable<LittleBox> boxes) {
        super(element);
        this.boxes = new CopyArrayCollection();
        for (LittleBox box : boxes) {
            this.boxes.add((Object)box);
        }
    }

    public LittleTile(LittleElement element, LittleBox box) {
        super(element);
        this.boxes = new CopyArrayCollection((Object)box);
    }

    public LittleTile(BlockState state, int color, LittleBox box) {
        super(state, color);
        this.boxes = new CopyArrayCollection((Object)box);
    }

    @Deprecated
    public LittleTile(BlockState state, LittleBlock block, int color, List<LittleBox> boxes) {
        super(state, block, color);
        this.boxes = new CopyArrayCollection(boxes);
    }

    public LittleTile(BlockState state, int color, Iterable<LittleBox> boxes) {
        super(state, color);
        this.boxes = new CopyArrayCollection(boxes);
    }

    public LittleTile(BlockState state, int color, List<LittleBox> boxes) {
        super(state, color);
        this.boxes = new CopyArrayCollection(boxes);
    }

    public LittleTile(String name, int color, List<LittleBox> boxes) {
        super(name, color);
        this.boxes = new CopyArrayCollection(boxes);
    }

    public void add(LittleBox box) {
        this.boxes.add((Object)box);
    }

    public void add(Iterable<LittleBox> boxes) {
        for (LittleBox box : boxes) {
            this.boxes.add((Object)box);
        }
    }

    public boolean remove(LittleCollection parent, Iterable<LittleBox> boxes) {
        boolean result = false;
        for (LittleBox box : boxes) {
            result |= this.boxes.remove((Object)box);
        }
        if (this.boxes.isEmpty()) {
            parent.removeElement(this);
        }
        return result;
    }

    public boolean remove(LittleCollection parent, LittleBox box) {
        boolean result = this.boxes.remove((Object)box);
        if (this.boxes.isEmpty()) {
            parent.removeElement(this);
        }
        return result;
    }

    public void move(LittleVec vec) {
        for (LittleBox box : this.boxes) {
            box.add(vec);
        }
    }

    @Override
    public Iterator<LittleBox> iterator() {
        return this.boxes.iterator();
    }

    public boolean isEmpty() {
        return this.boxes.isEmpty();
    }

    public int size() {
        return this.boxes.size();
    }

    public boolean combine() {
        ArrayList<LittleBox> tempBoxes = new ArrayList<LittleBox>((Collection<LittleBox>)this.boxes);
        if (LittleBoxCombiner.combine(tempBoxes)) {
            this.boxes.clear();
            this.boxes.addAll(tempBoxes);
            return true;
        }
        return false;
    }

    public void combineBlockwise(LittleGrid grid) {
        HashMapList chunked = new HashMapList();
        for (LittleBox box : this.boxes) {
            chunked.add((Object)box.getMinVec().getBlockPos(grid), (Object)box);
        }
        this.boxes.clear();
        for (ArrayList list : chunked.values()) {
            LittleBoxCombiner.combine(list);
            this.boxes.addAll((Collection)list);
        }
    }

    public void split(HashMapList<BlockPos, LittleBox> boxes, BlockPos pos, LittleGrid grid, LittleVec offset, LittleBoxReturnedVolume volume) {
        for (LittleBox box : this.boxes) {
            box.split(grid, pos, offset, boxes, volume);
        }
    }

    @Override
    @Deprecated
    public CompoundTag save(CompoundTag nbt) {
        return super.save(nbt);
    }

    public LittleTile copy() {
        CopyArrayCollection boxes = new CopyArrayCollection();
        for (LittleBox box : this.boxes) {
            boxes.add(box.copy());
        }
        return new LittleTile((LittleElement)this, (Iterable<LittleBox>)boxes);
    }

    public LittleTile copy(List<LittleBox> boxes) {
        return new LittleTile((LittleElement)this, boxes);
    }

    public LittleTile copyEmpty() {
        return new LittleTile((LittleElement)this, (Iterable<LittleBox>)new CopyArrayCollection());
    }

    @Override
    public int hashCode() {
        return this.block.hashCode() + this.color;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LittleTile) {
            return ((LittleTile)obj).block == this.block && ((LittleTile)obj).color == this.color;
        }
        return false;
    }

    @Override
    public boolean hasColor() {
        return ColorUtils.isDefault((int)this.color);
    }

    public boolean isTranslucent() {
        return this.block.isTranslucent() || ColorUtils.isTransparent((int)this.color);
    }

    public int getSmallest(LittleGrid grid) {
        int smallest = 0;
        for (LittleBox box : this.boxes) {
            smallest = Math.max(smallest, box.getSmallest(grid));
        }
        return smallest;
    }

    public void convertTo(LittleGrid from, LittleGrid to) {
        for (LittleBox box : this.boxes) {
            box.convertTo(from, to);
        }
    }

    public int getVolume() {
        int volume = 0;
        for (LittleBox box : this.boxes) {
            volume += box.getVolume();
        }
        return volume;
    }

    public double getPercentVolume(LittleGrid grid) {
        double volume = 0.0;
        for (LittleBox box : this.boxes) {
            volume += box.getPercentVolume(grid);
        }
        return volume;
    }

    public boolean doesFillEntireBlock(LittleGrid grid) {
        if (this.boxes.size() == 1) {
            return ((LittleBox)this.boxes.first()).doesFillEntireBlock(grid);
        }
        boolean[][][] filled = new boolean[grid.count][grid.count][grid.count];
        for (LittleBox box : this.boxes) {
            box.fillInSpace(filled);
        }
        for (int x = 0; x < filled.length; ++x) {
            for (int y = 0; y < filled[x].length; ++y) {
                for (int z = 0; z < filled[x][y].length; ++z) {
                    if (filled[x][y][z]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void fillFace(IParentCollection parent, ILittleFace face, LittleGrid grid) {
        for (LittleBox box : this.boxes) {
            if (face.getGrid() != parent.getGrid()) {
                box = box.copy();
                box.convertTo(parent.getGrid(), face.getGrid());
            }
            box.fill(face);
        }
    }

    public boolean fillInSpace(boolean[][][] filled) {
        boolean changed = false;
        for (LittleBox box : this.boxes) {
            for (int x = box.minX; x < box.maxX; ++x) {
                for (int y = box.minY; y < box.maxY; ++y) {
                    for (int z = box.minZ; z < box.maxZ; ++z) {
                        filled[x][y][z] = true;
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }

    public boolean fillInSpaceInaccurate(LittleBox otherBox, Axis one, Axis two, Axis axis, boolean[][] filled) {
        boolean changed = false;
        for (LittleBox box : this.boxes) {
            changed |= box.fillInSpaceInaccurate(otherBox, one, two, axis, filled);
        }
        return changed;
    }

    public boolean fillInSpaceInaccurate(LittleBox otherBox, boolean[][][] filled) {
        boolean changed = false;
        for (LittleBox box : this.boxes) {
            changed |= box.fillInSpaceInaccurate(otherBox, filled);
        }
        return changed;
    }

    public boolean fillInSpace(LittleBox otherBox, boolean[][][] filled) {
        boolean changed = false;
        for (LittleBox box : this.boxes) {
            changed |= box.fillInSpace(otherBox, filled);
        }
        return changed;
    }

    public boolean intersectsWith(LittleBox intersect) {
        for (LittleBox box : this.boxes) {
            if (!LittleBox.intersectsWith(box, intersect)) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsWith(AABB bb, IParentCollection parent) {
        for (LittleBox box : this.boxes) {
            if (!box.intersectsWith(bb, parent.getGrid())) continue;
            return true;
        }
        return false;
    }

    public void cutOut(LittleBox cutter, @Nullable LittleBoxReturnedVolume volume) {
        List<LittleBox> result = null;
        for (LittleBox box : this.boxes) {
            List<LittleBox> temp = box.cutOut(cutter, volume);
            if (result == null) {
                result = temp;
                continue;
            }
            if (temp == null) continue;
            result.addAll(temp);
        }
        this.boxes.clear();
        this.boxes.addAll(result);
    }

    public void cutOut(List<LittleBox> cutter, List<LittleBox> cutout, @Nullable LittleBoxReturnedVolume volume) {
        List<LittleBox> result = null;
        for (LittleBox box : this.boxes) {
            List<LittleBox> temp = box.cutOut(cutter, cutout, volume);
            if (result == null) {
                result = temp;
                continue;
            }
            if (temp == null) continue;
            result.addAll(temp);
        }
        this.boxes.clear();
        this.boxes.addAll(result);
    }

    public void getIntersectingBoxes(LittleBox intersect, List<LittleBox> boxes) {
        for (LittleBox box : this.boxes) {
            if (!LittleBox.intersectsWith(box, intersect)) continue;
            boxes.add(box);
        }
    }

    public BlockHitResult rayTrace(LittleGrid grid, BlockPos blockPos, Vec3 pos, Vec3 look) {
        double distance = Double.POSITIVE_INFINITY;
        BlockHitResult result = null;
        for (LittleBox box : this.boxes) {
            BlockHitResult temp = box.rayTrace(grid, blockPos, pos, look);
            double tempDistance = 0.0;
            if (temp == null) continue;
            if (result != null) {
                double d;
                tempDistance = temp.m_82450_().m_82554_(pos);
                if (!(distance > d)) continue;
            }
            result = temp;
            distance = tempDistance;
        }
        return result;
    }

    public boolean doesProvideSolidFace() {
        return !this.isTranslucent();
    }

    public boolean contains(LittleBox other) {
        for (LittleBox box : this.boxes) {
            if (!box.equals(other)) continue;
            return true;
        }
        return false;
    }

    public boolean noCollision() {
        return this.block.noCollision();
    }

    public void mirror(Axis axis, LittleVec doubledCenter) {
        for (LittleBox box : this.boxes) {
            box.mirror(axis, doubledCenter);
        }
        this.setState(this.block.mirror(this.getState(), axis, doubledCenter));
    }

    public void rotate(Rotation rotation, LittleVec doubledCenter) {
        for (LittleBox box : this.boxes) {
            box.rotate(rotation, doubledCenter);
        }
        this.setState(this.block.rotate(this.getState(), rotation, doubledCenter));
    }

    public boolean canBeRenderCombined(LittleTile tile) {
        return this.block.canBeRenderCombined(this, tile);
    }

    public void addPlaceBoxes(LittleGrid grid, List<RenderBox> boxes, LittleVec offset) {
        for (LittleBox box : this.boxes) {
            boxes.add(new RenderBox(box.getBox(grid, offset)));
        }
    }

    public void addRenderingBoxes(LittleGrid grid, List<RenderBox> boxes) {
        for (LittleBox box : this.boxes) {
            boxes.add(box.getRenderingBox(grid, this));
        }
    }

    public SoundType getSound() {
        return this.block.getSoundType();
    }

    public float getExplosionResistance() {
        return this.block.getExplosionResistance(this);
    }

    public void onTileExplodes(IParentCollection parent, Explosion explosion) {
        this.block.exploded(parent, this, explosion);
    }

    public void randomDisplayTick(IParentCollection parent, RandomSource rand) {
        this.block.randomDisplayTick(parent, this, rand);
    }

    public boolean canInteract() {
        return this.block.canInteract();
    }

    public InteractionResult use(IParentCollection parent, LittleBox box, BlockPos pos, Player player, BlockHitResult result) {
        return this.block.use(parent, this, box, player, result);
    }

    public int getLightValue() {
        return this.block.getLightValue();
    }

    public float getEnchantPowerBonus(IParentCollection parent) {
        return this.block.getEnchantPowerBonus(parent, this);
    }

    public float getFriction(IParentCollection parent, @Nullable Entity entity) {
        return this.block.getFriction(parent, this, entity);
    }

    public boolean isMaterial(Material material) {
        return this.block.isMaterial(material);
    }

    public boolean isLiquid() {
        return this.block.isLiquid();
    }

    public Vector3d getFogColor(IParentCollection parent, Entity entity, Vector3d originalColor, float partialTicks) {
        return this.block.getFogColor(parent, this, entity, originalColor, partialTicks);
    }

    public Vec3d modifyAcceleration(IParentCollection parent, Entity entity, Vec3d motion) {
        return this.block.modifyAcceleration(parent, this, entity, motion);
    }

    public boolean canBeConvertedToVanilla() {
        for (LittleBox box : this.boxes) {
            if (box.isSolid()) continue;
            return false;
        }
        return this.block.canBeConvertedToVanilla();
    }

    public void entityCollided(IParentCollection parent, Entity entity) {
        this.block.entityCollided(parent, this, entity);
    }

    public VoxelShape getShapes(IParentCollection parent) {
        VoxelShape shape = Shapes.m_83040_();
        for (LittleBox box : this.boxes) {
            if (!box.isSolid()) continue;
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)box.getShape(parent.getGrid()), (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    public List<VoxelShape> collectOddShapes(IParentCollection parent, List<VoxelShape> shapes, AABB bb) {
        for (LittleBox box : this.boxes) {
            if (box.isSolid() || !box.intersectsWith(bb, parent.getGrid())) continue;
            if (shapes == null) {
                shapes = new ArrayList<VoxelShape>();
            }
            shapes.add(box.getShape(parent.getGrid()));
        }
        return shapes;
    }

    @Nullable
    public BlockIngredientEntry getBlockIngredient(LittleGrid context) {
        return IngredientUtils.getBlockIngredient(this.block, this.getPercentVolume(context));
    }

    @Override
    public String toString() {
        return "[" + this.getBlockName() + "|" + this.color + "|" + this.boxes + "]";
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canRenderInLayer(RenderType layer) {
        if (ColorUtils.isTransparent((int)this.color)) {
            return layer == RenderType.m_110466_();
        }
        return LittleBlockClientRegistry.canRenderInLayer(this.getBlock(), layer);
    }
}

