/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.mc;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.block.entity.BESignalConverter;

public class BlockSignalConverter
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public BlockSignalConverter() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_));
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_());
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos origin, boolean p_60514_) {
        super.m_6861_(state, level, pos, block, origin, p_60514_);
        this.changed((LevelReader)level, pos);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        this.changed(level, pos);
    }

    public void changed(LevelReader level, BlockPos pos) {
        Optional result = level.m_141902_(pos, (BlockEntityType)LittleTilesRegistry.BE_SIGNALCONVERTER_TYPE.get());
        if (result.isEmpty()) {
            return;
        }
        Direction direction = (Direction)level.m_8055_(pos).m_61143_((Property)FACING);
        if (!level.m_5776_()) {
            ((BESignalConverter)result.get()).setPower(BlockSignalConverter.getPowerOnSide(level, pos.m_121945_(direction.m_122424_()), direction));
        }
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        Optional result;
        if (state.m_61143_((Property)FACING) == side.m_122424_() && (result = level.m_141902_(pos, (BlockEntityType)LittleTilesRegistry.BE_SIGNALCONVERTER_TYPE.get())).isPresent()) {
            return ((BESignalConverter)result.get()).getPower();
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.m_61143_((Property)FACING) == direction;
    }

    public static int getPowerOnSide(LevelReader level, BlockPos pos, Direction side) {
        BlockState iblockstate = level.m_8055_(pos);
        if (iblockstate.m_60803_()) {
            return level.m_46852_(pos, side);
        }
        return 0;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BESignalConverter(pos, state);
    }
}

