/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.collision.CollisionCoordinator;
import team.creative.creativecore.common.util.math.matrix.ChildVecOrigin;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.client.entity.LevelTransitionListener;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.common.entity.INoPushEntity;
import team.creative.littletiles.common.entity.LittleEntityPhysic;
import team.creative.littletiles.common.entity.OrientationAwareEntity;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.math.vec.LittleHitResult;

public abstract class LittleEntity<T extends LittleEntityPhysic>
extends Entity
implements OrientationAwareEntity,
INoPushEntity,
LevelTransitionListener {
    private Iterable<OrientationAwareEntity> childrenItr = () -> new FilterIterator(this.entities(), x -> {
        OrientationAwareEntity e;
        return x instanceof OrientationAwareEntity && (e = (OrientationAwareEntity)x).hasLoaded();
    });
    protected LittleSubLevel subLevel;
    protected IVecOrigin origin;
    protected boolean hasOriginChanged = false;
    public final T physic = this.createPhysic();
    private List<Entity> entitiesToAdd;
    protected boolean changedLevel;

    public LittleEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public LittleEntity(EntityType<?> type, Level level, Vec3d center) {
        super(type, level);
        this.setSubLevel(this.createLevel(), center);
        this.m_6034_(center.x, center.y, center.z);
        this.origin.tick();
        ((LittleEntityPhysic)this.physic).ignoreCollision(() -> this.initialTick());
    }

    public LittleEntity(EntityType<?> type, Level level, LittleSubLevel subLevel, Vec3d center) {
        super(type, level);
        this.setSubLevel(subLevel, center);
        this.m_6034_(center.x, center.y, center.z);
        this.origin.tick();
        ((LittleEntityPhysic)this.physic).ignoreCollision(() -> this.initialTick());
    }

    protected abstract LittleSubLevel createLevel();

    protected abstract T createPhysic();

    public boolean isReal() {
        Level level = this.f_19853_;
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            this.f_19853_ = sub.getRealLevel();
        }
        return !(this.f_19853_ instanceof IOrientatedLevel);
    }

    @Override
    public void markOriginChange() {
        this.hasOriginChanged = true;
        for (OrientationAwareEntity child : this.children()) {
            child.markOriginChange();
        }
    }

    public void resetOriginChange() {
        this.hasOriginChanged = false;
    }

    protected void m_8097_() {
    }

    @Override
    public IVecOrigin getOrigin() {
        return this.origin;
    }

    public LittleSubLevel getSubLevel() {
        return this.subLevel;
    }

    public Level getRealLevel() {
        Level level = this.f_19853_;
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            return sub.getRealLevel();
        }
        return this.f_19853_;
    }

    public LittleEntity getTopLevelEntity() {
        Level level = this.f_19853_;
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            return ((LittleEntity)sub.getHolder()).getTopLevelEntity();
        }
        return this;
    }

    public abstract CreativePacket initClientPacket();

    public abstract void startTracking(ServerPlayer var1);

    public abstract void stopTracking(ServerPlayer var1);

    protected void setSubLevel(LittleSubLevel subLevel, Vec3d center) {
        this.subLevel = subLevel;
        this.subLevel.setHolder(this);
        this.subLevel.setOrigin(center);
        this.origin = subLevel.getOrigin();
        ((LittleEntityPhysic)this.physic).setSubLevel(subLevel);
    }

    @Override
    public void parentVecOriginChange(IVecOrigin origin) {
        ((ChildVecOrigin)origin).parent = origin;
    }

    @Override
    public void transform(CollisionCoordinator coordinator) {
        ((LittleEntityPhysic)this.physic).transform(coordinator);
    }

    @Override
    public void changedLevel(Level oldLevel, Level newLevel) {
        this.changedLevel = true;
    }

    public AABB getRealBB() {
        Level level = this.f_19853_;
        if (level instanceof ISubLevel) {
            ISubLevel or = (ISubLevel)level;
            return or.getOrigin().getAABB(this.m_20191_());
        }
        return this.m_20191_();
    }

    public Vec3 getRealCenter() {
        Level level = this.f_19853_;
        if (level instanceof ISubLevel) {
            ISubLevel or = (ISubLevel)level;
            return or.getOrigin().transformPointToWorld(this.m_20182_());
        }
        return this.m_20182_();
    }

    public Iterable<Entity> entities() {
        return this.subLevel.entities();
    }

    public Iterable<OrientationAwareEntity> children() {
        return this.childrenItr;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract LittleEntityRenderManager getRenderManager();

    public abstract void initialTick();

    public abstract void internalTick();

    @Override
    public void performTick() {
        if (this.entitiesToAdd != null) {
            for (Entity entity : this.entitiesToAdd) {
                this.subLevel.m_7967_(entity);
            }
            this.entitiesToAdd = null;
        }
        if (this.f_19853_ instanceof ISubLevel) {
            if (!this.f_19853_.f_46443_) {
                this.m_20115_(6, this.m_142038_());
            }
            super.m_6075_();
        } else {
            super.m_8119_();
        }
        this.children().forEach(x -> x.performTick());
        this.internalTick();
        this.subLevel.tick();
        ((LittleEntityPhysic)this.physic).tick();
        ((LittleEntityPhysic)this.physic).updateBoundingBox();
        this.syncMovement();
        this.origin.tick();
        Vec3 center = ((LittleEntityPhysic)this.physic).getCenter();
        this.m_20343_(center.f_82479_, center.f_82480_, center.f_82481_);
    }

    public abstract void syncMovement();

    protected abstract Vec3d loadCenter(CompoundTag var1);

    public void m_7378_(CompoundTag nbt) {
        this.setSubLevel(this.createLevel(), this.loadCenter(nbt));
        ((LittleEntityPhysic)this.physic).load(nbt.m_128469_("physic"));
        this.loadEntity(nbt);
        ((LittleEntityPhysic)this.physic).updateBoundingBox();
        if (nbt.m_128441_("entities")) {
            this.entitiesToAdd = new ArrayList<Entity>();
            ListTag list = nbt.m_128437_("entities", 10);
            for (int i = 0; i < list.size(); ++i) {
                EntityType.m_20642_((CompoundTag)list.m_128728_(i), (Level)((Level)this.subLevel)).ifPresent(this.entitiesToAdd::add);
            }
        } else {
            this.entitiesToAdd = null;
        }
    }

    public abstract void loadEntity(CompoundTag var1);

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128365_("physic", (Tag)((LittleEntityPhysic)this.physic).save());
        this.saveEntity(nbt);
        ListTag list = new ListTag();
        for (Entity entity : this.entities()) {
            CompoundTag entityNBT = new CompoundTag();
            entity.m_20223_(entityNBT);
            list.add((Object)entityNBT);
        }
        if (!list.isEmpty()) {
            nbt.m_128365_("entities", (Tag)list);
        }
    }

    public abstract void saveEntity(CompoundTag var1);

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get(this.f_19853_)).add(this);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get(this.f_19853_)).remove(this);
    }

    public void m_6034_(double x, double y, double z) {
        super.m_20343_(x, y, z);
    }

    protected AABB m_142242_() {
        return this.origin.getAABB(((LittleEntityPhysic)this.physic).getOBB());
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    public void destroyAnimation() {
        this.m_6074_();
    }

    public void m_6074_() {
        this.subLevel.unload();
        super.m_6074_();
    }

    public boolean m_5829_() {
        return false;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public LittleHitResult rayTrace(Vec3 pos, Vec3 look) {
        Vec3 newLook;
        LittleHitResult result = null;
        double distance = 0.0;
        for (Entity entity : this.entities()) {
            double tempDistance;
            LittleHitResult tempResult;
            Vec3 newLook2;
            Vec3 newPos;
            if (entity instanceof LittleEntity) {
                LittleEntity levelEntity = (LittleEntity)entity;
                if (!levelEntity.hasLoaded()) continue;
                newPos = levelEntity.origin.transformPointToFakeWorld(pos);
                newLook2 = levelEntity.origin.transformPointToFakeWorld(look);
                if (!((LittleEntityPhysic)levelEntity.physic).getOBB().m_82335_(newPos, newLook2) || (tempResult = levelEntity.rayTrace(pos, look)) == null) continue;
                tempDistance = newPos.m_82554_(tempResult.hit.m_82450_());
                if (result != null && !(tempDistance < distance)) continue;
                result = tempResult;
                distance = tempDistance;
                continue;
            }
            newPos = this.origin.transformPointToFakeWorld(pos);
            newLook2 = this.origin.transformPointToFakeWorld(look);
            if (!entity.m_20191_().m_82335_(newPos, newLook2)) continue;
            tempResult = new LittleHitResult(this, (HitResult)new EntityHitResult(entity, (Vec3)entity.m_20191_().m_82371_(newPos, newLook2).get()), this.subLevel);
            tempDistance = newPos.m_82554_(tempResult.hit.m_82450_());
            if (result != null && !(tempDistance < distance)) continue;
            result = tempResult;
            distance = tempDistance;
        }
        Vec3 newPos = this.origin.transformPointToFakeWorld(pos);
        BlockHitResult tempResult = this.subLevel.m_45547_(new ClipContext(newPos, newLook = this.origin.transformPointToFakeWorld(look), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null));
        if (tempResult == null || tempResult.m_6662_() != HitResult.Type.BLOCK || !(tempResult instanceof BlockHitResult)) {
            return result;
        }
        if (result == null || pos.m_82554_(tempResult.m_82450_()) < distance) {
            return new LittleHitResult(this, (HitResult)tempResult, this.subLevel);
        }
        return result;
    }

    public boolean m_6000_(double x, double y, double z) {
        Vec3 center = this.getRealCenter();
        double d0 = center.f_82479_ - x;
        double d1 = center.f_82480_ - y;
        double d2 = center.f_82481_ - z;
        return this.m_6783_(d0 * d0 + d1 * d1 + d2 * d2);
    }

    @Override
    public boolean hasLoaded() {
        return this.subLevel != null;
    }
}

