/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.animation;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.LittleEntityPhysic;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.level.little.LittleSubLevel;

public class LittleAnimationEntityPhysic
extends LittleEntityPhysic<LittleAnimationEntity> {
    private boolean blocksChanged = true;

    public LittleAnimationEntityPhysic(LittleAnimationEntity parent) {
        super(parent);
    }

    @Override
    public void setSubLevel(LittleSubLevel level) {
        level.registerBlockChangeListener((pos, state) -> {
            this.blocksChanged = true;
        });
    }

    protected boolean isWithinBoundsNoEdge(BlockPos pos) {
        return Math.floor(this.minX) < (double)pos.m_123341_() && this.maxX > (double)pos.m_123341_() && Math.floor(this.minY) < (double)pos.m_123342_() && this.maxY > (double)pos.m_123342_() && Math.floor(this.minZ) < (double)pos.m_123343_() && this.maxZ > (double)pos.m_123343_();
    }

    @Override
    public void tick() {
        if (this.blocksChanged) {
            this.minX = Double.MAX_VALUE;
            this.minY = Double.MAX_VALUE;
            this.minZ = Double.MAX_VALUE;
            this.maxX = -1.7976931348623157E308;
            this.maxY = -1.7976931348623157E308;
            this.maxZ = -1.7976931348623157E308;
            for (BETiles block : ((LittleAnimationEntity)this.parent).getSubLevel()) {
                if (block.isEmpty() || this.isWithinBoundsNoEdge(block.m_58899_())) continue;
                AABB bb = block.getBlockBBWithOffset();
                this.minX = Math.min(this.minX, bb.f_82288_);
                this.minY = Math.min(this.minY, bb.f_82289_);
                this.minZ = Math.min(this.minZ, bb.f_82290_);
                this.maxX = Math.max(this.maxX, bb.f_82291_);
                this.maxY = Math.max(this.maxY, bb.f_82292_);
                this.maxZ = Math.max(this.maxZ, bb.f_82293_);
            }
            this.setBB(new AABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ));
            this.blocksChanged = false;
        }
    }

    @Override
    public void loadExtra(CompoundTag nbt) {
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
    }
}

