/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.level;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.api.common.block.LittlePhysicBlock;
import team.creative.littletiles.common.entity.INoPushEntity;
import team.creative.littletiles.common.entity.LittleEntityPhysic;
import team.creative.littletiles.common.entity.level.BlockUpdateLevelSystem;
import team.creative.littletiles.common.entity.level.LittleLevelEntity;
import team.creative.littletiles.common.level.little.LevelBoundsListener;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.level.little.LittleSubLevel;

public class LittleLevelEntityPhysic
extends LittleEntityPhysic<LittleLevelEntity>
implements LevelBoundsListener {
    protected static final Predicate<Entity> noAnimation = x -> !(x.m_146895_() instanceof INoPushEntity);
    private BlockUpdateLevelSystem updateSystem;
    public boolean noCollision = false;

    public LittleLevelEntityPhysic(LittleLevelEntity parent) {
        super(parent);
    }

    @Override
    public void setSubLevel(LittleSubLevel level) {
        this.updateSystem = new BlockUpdateLevelSystem(level);
        level.registerBlockChangeListener(this.updateSystem::blockChanged);
        this.updateSystem.registerLevelBoundListener(this);
    }

    @Override
    public void loadExtra(CompoundTag nbt) {
        this.updateSystem.load(nbt.m_128469_("bounds"));
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        nbt.m_128365_("bounds", (Tag)this.updateSystem.save());
    }

    @Override
    public void tick() {
        this.updateSystem.tick(this.parent);
    }

    public BlockUpdateLevelSystem getBlockUpdateLevelSystem() {
        return this.updateSystem;
    }

    @Override
    public void rescan(LittleLevel level, BlockUpdateLevelSystem system, Facing facing, Iterable<BlockPos> possible, int boundary) {
        double value = facing.positive ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        for (BlockPos pos : possible) {
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof LittlePhysicBlock) {
                LittlePhysicBlock block2 = (LittlePhysicBlock)block;
                value = facing.positive ? Math.max(value, block2.bound(level, pos, facing)) : Math.min(value, block2.bound(level, pos, facing));
            } else {
                double d = value = facing.positive ? Math.max(value, (double)(pos.m_123304_(facing.axis.toVanilla()) + 1)) : Math.min(value, (double)pos.m_123304_(facing.axis.toVanilla()));
            }
            if (value != (double)boundary) continue;
            break;
        }
        this.set(facing, value);
    }

    @Override
    public void afterChangesApplied(BlockUpdateLevelSystem system) {
        this.setBB(new AABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ));
    }
}

