/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.littletiles.common.structure.type.premade.LittleParticleEmitter;
import team.creative.littletiles.mixin.client.render.ParticleEngineAccessor;

@OnlyIn(value=Dist.CLIENT)
public class LittleParticle
extends TextureSheetParticle {
    private static final Minecraft mc = Minecraft.m_91087_();
    public LittleParticleEmitter.ParticleSettings settings;
    public SpriteSet sprites;
    private float scaleDeviation;

    public LittleParticle(ClientLevel level, Vec3d pos, Vec3d speed, LittleParticleEmitter.ParticleSettings settings) {
        super(level, pos.x, pos.y, pos.z);
        this.f_107215_ = speed.x * (Math.random() * 0.1 + 0.95);
        this.f_107216_ = speed.y * (Math.random() * 0.1 + 0.95);
        this.f_107217_ = speed.z * (Math.random() * 0.1 + 0.95);
        this.f_107225_ = (int)((double)settings.lifetime + (double)settings.lifetimeDeviation * Math.random());
        this.f_107226_ = settings.gravity;
        this.f_107230_ = ColorUtils.alphaF((int)settings.color);
        this.f_107227_ = ColorUtils.redF((int)settings.color);
        this.f_107228_ = ColorUtils.greenF((int)settings.color);
        this.f_107229_ = ColorUtils.blueF((int)settings.color);
        if (settings.randomColor) {
            this.f_107227_ = (float)((double)this.f_107227_ * Math.random());
            this.f_107228_ = (float)((double)this.f_107228_ * Math.random());
            this.f_107229_ = (float)((double)this.f_107229_ * Math.random());
        }
        this.settings = settings;
        this.sprites = ((ParticleEngineAccessor)LittleParticle.mc.f_91061_).getSpriteSets().get(settings.texture.particleTexture);
        this.scaleDeviation = (float)(Math.random() * (double)settings.sizeDeviation);
        settings.texture.init(this);
        this.m_107250_(0.2f * settings.startSize, 0.2f * settings.startSize);
    }

    public void m_5989_() {
        this.settings.texture.tick(this);
        this.scaleDeviation = this.scaleDeviation + (float)this.getAge() / (float)this.getMaxAge() * (this.settings.endSize - this.settings.startSize) + this.settings.startSize;
        super.m_5989_();
    }

    public int getAge() {
        return this.f_107224_;
    }

    public int getMaxAge() {
        return this.f_107225_;
    }

    public void setSpriteFirst(SpriteSet set) {
        this.m_108337_(set.m_5819_(0, this.f_107225_));
    }

    public void setSpriteFromAgeReverse(SpriteSet set) {
        if (!this.f_107220_) {
            this.m_108337_(set.m_5819_(this.f_107225_ - this.f_107224_, this.f_107225_));
        }
    }

    public ParticleRenderType m_7556_() {
        return this.settings.texture.type;
    }
}

