/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.controls;

import team.creative.creativecore.common.gui.controls.simple.GuiIconButton;
import team.creative.creativecore.common.gui.style.GuiIcon;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.text.TextBuilder;

public class GuiDirectionIndicator
extends GuiIconButton {
    private Facing facing;

    public GuiDirectionIndicator(String name, Facing facing) {
        super(name, GuiIcon.EMPTY, x -> {});
        this.setFacing(facing);
    }

    public Facing getFacing() {
        return this.facing;
    }

    public void setFacing(Facing facing) {
        this.facing = facing;
        this.setIcon(GuiDirectionIndicator.toIcon(facing));
        this.setTooltip(new TextBuilder().translate("gui.points." + facing.name).build());
    }

    public static GuiIcon toIcon(Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.EAST -> GuiIcon.ARROW_RIGHT;
            case Facing.WEST -> GuiIcon.ARROW_LEFT;
            case Facing.UP -> GuiIcon.ARROW_UP;
            case Facing.DOWN -> GuiIcon.ARROW_DOWN;
            case Facing.SOUTH -> GuiIcon.ARROW_IN;
            case Facing.NORTH -> GuiIcon.ARROW_OUT;
        };
    }
}

