/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.controls.animation;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.common.gui.controls.animation.GuiAnimationViewerStorage;

public class GuiAnimationViewer
extends GuiControl {
    public SmoothValue offX = new SmoothValue(200L);
    public SmoothValue offY = new SmoothValue(200L);
    public SmoothValue offZ = new SmoothValue(200L);
    public SmoothValue rotX = new SmoothValue(200L);
    public SmoothValue rotY = new SmoothValue(200L);
    public SmoothValue rotZ = new SmoothValue(200L);
    public SmoothValue distance = new SmoothValue(200L);
    public ViewerDragMode grabMode = ViewerDragMode.NONE;
    private ProjectionMode projection = ProjectionMode.SHOWCASE;
    public double grabX;
    public double grabY;
    public GuiAnimationViewerStorage storage;
    private boolean initialized = false;
    private boolean forward;
    private boolean backward;
    private boolean left;
    private boolean right;
    private boolean up;
    private boolean down;

    public GuiAnimationViewer(String name, GuiAnimationViewerStorage storage) {
        super(name);
        this.storage = storage;
    }

    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED_NO_PADDING;
    }

    public void mouseMoved(Rect rect, double x, double y) {
        super.mouseMoved(rect, x, y);
        if (this.grabMode == ViewerDragMode.NONE) {
            return;
        }
        switch (this.grabMode) {
            case LEFT: {
                this.rotY.set(this.rotY.aimed() + x - this.grabX);
                this.rotX.set(this.rotX.aimed() + y - this.grabY);
                break;
            }
            default: {
                this.projection.dragMouse(this, x - this.grabX, y - this.grabY);
            }
        }
        this.grabX = x;
        this.grabY = y;
    }

    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (this.grabMode == ViewerDragMode.NONE) {
            this.grabMode = ViewerDragMode.of(button);
            this.grabX = x;
            this.grabY = y;
            return true;
        }
        return false;
    }

    public void mouseReleased(Rect rect, double x, double y, int button) {
        if (button == this.grabMode.ordinal() - 1) {
            this.grabMode = ViewerDragMode.NONE;
        }
    }

    public boolean mouseScrolled(Rect rect, double x, double y, double delta) {
        this.distance.set(Math.max(this.distance.aimed() + delta * (double)(-(Screen.m_96637_() ? 5 : 1)), 0.0));
        return true;
    }

    public void nextProjection() {
        this.setProjection(this.projection.next());
    }

    public void setProjection(ProjectionMode mode) {
        this.projection = mode;
        this.initialized = false;
    }

    public PoseStack getProjectionMatrix(Minecraft mc, double fov, float width, float height) {
        PoseStack posestack = new PoseStack();
        posestack.m_166856_();
        posestack.m_252931_(new Matrix4f().setPerspective((float)(fov * Math.PI / 180.0), width / height, 0.05f, mc.f_91063_.m_172790_()));
        return posestack;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Options options = Minecraft.m_91087_().f_91066_;
        if (options.f_92085_.m_90832_(keyCode, scanCode)) {
            this.forward = true;
        }
        if (options.f_92087_.m_90832_(keyCode, scanCode)) {
            this.backward = true;
        }
        if (options.f_92088_.m_90832_(keyCode, scanCode)) {
            this.left = true;
        }
        if (options.f_92086_.m_90832_(keyCode, scanCode)) {
            this.right = true;
        }
        if (options.f_92089_.m_90832_(keyCode, scanCode)) {
            this.up = true;
        }
        if (options.f_92090_.m_90832_(keyCode, scanCode)) {
            this.down = true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        Options options = Minecraft.m_91087_().f_91066_;
        if (options.f_92085_.m_90832_(keyCode, scanCode)) {
            this.forward = false;
        }
        if (options.f_92087_.m_90832_(keyCode, scanCode)) {
            this.backward = false;
        }
        if (options.f_92088_.m_90832_(keyCode, scanCode)) {
            this.left = false;
        }
        if (options.f_92086_.m_90832_(keyCode, scanCode)) {
            this.right = false;
        }
        if (options.f_92089_.m_90832_(keyCode, scanCode)) {
            this.up = false;
        }
        if (options.f_92090_.m_90832_(keyCode, scanCode)) {
            this.down = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public void resetView() {
        this.offX.set(0.0);
        this.offY.set(0.0);
        this.offZ.set(0.0);
        this.rotX.set(0.0);
        this.rotY.set(0.0);
        this.rotZ.set(0.0);
        this.initialized = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack pose, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        if (!this.storage.isReady()) {
            return;
        }
        if (!this.initialized) {
            this.resetView();
            this.projection.init(this);
            this.initialized = true;
        }
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        this.rotX.tick();
        this.rotY.tick();
        this.rotZ.tick();
        this.distance.tick();
        this.offX.tick();
        this.offY.tick();
        this.offZ.tick();
        float amount = mc.m_91297_() * 2.0f;
        if (Screen.m_96637_()) {
            amount *= 4.0f;
        }
        if (this.forward) {
            this.projection.forward(amount, this);
        }
        if (this.backward) {
            this.projection.forward(-amount, this);
        }
        if (this.left) {
            this.projection.lateral(amount, this);
        }
        if (this.right) {
            this.projection.lateral(-amount, this);
        }
        if (this.up) {
            this.projection.up(amount, this);
        }
        if (this.down) {
            this.projection.up(-amount, this);
        }
        pose = RenderSystem.m_157191_();
        pose.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        double scale = window.m_85449_();
        int height = (int)(rect.getHeight() * scale);
        RenderSystem.m_69949_((int)((int)(rect.minX * scale)), (int)((int)((double)window.m_85442_() - rect.minY * scale - (double)height)), (int)((int)(rect.getWidth() * scale)), (int)height);
        RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
        PoseStack projection = this.getProjectionMatrix(mc, 70.0, (float)rect.getWidth(), (float)rect.getHeight());
        RenderSystem.m_252934_((Matrix4f)projection.m_85850_().m_252922_());
        pose.m_166856_();
        RenderSystem.m_69482_();
        Vec3d center = this.storage.center();
        this.projection.prepareRendering(pose, center, this);
        this.storage.renderAll(pose, projection.m_85850_().m_252922_(), mc);
        pose.m_85849_();
        RenderSystem.m_69949_((int)0, (int)0, (int)window.m_85441_(), (int)window.m_85442_());
        RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
        RenderSystem.m_252934_((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)((double)window.m_85441_() / window.m_85449_()), (float)((double)window.m_85442_() / window.m_85449_()), 0.0f, 1000.0f, ForgeHooksClient.getGuiFarPlane()));
        RenderSystem.m_157182_();
        Lighting.m_84931_();
        RenderSystem.m_69465_();
    }

    public void closed() {
    }

    public void init() {
    }

    public void tick() {
    }

    public void flowX(int width, int preferred) {
    }

    public void flowY(int width, int height, int preferred) {
    }

    protected int preferredWidth(int availableWidth) {
        return 10;
    }

    protected int preferredHeight(int width, int availableHeight) {
        return 10;
    }

    protected static enum ViewerDragMode {
        NONE,
        LEFT,
        RIGHT,
        MIDDLE;


        public static ViewerDragMode of(int button) {
            return switch (button) {
                case 0 -> LEFT;
                case 1 -> RIGHT;
                case 2 -> MIDDLE;
                default -> NONE;
            };
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ProjectionMode {
        SHOWCASE{

            @Override
            public void init(GuiAnimationViewer viewer) {
                viewer.distance.set(viewer.storage.longestSide() / 2.0 + 2.0);
            }

            @Override
            public void dragMouse(GuiAnimationViewer viewer, double x, double y) {
                double grabOffset = 0.01;
                switch (viewer.grabMode) {
                    case RIGHT: {
                        Vector3f offset = new Vector3f((float)(x * grabOffset), 0.0f, (float)(y * grabOffset));
                        this.apply(offset, viewer);
                        break;
                    }
                    case MIDDLE: {
                        Vector3f offset = new Vector3f((float)(x * grabOffset), (float)(y * -grabOffset), 0.0f);
                        this.apply(offset, viewer);
                    }
                }
            }

            @Override
            public void forward(float amount, GuiAnimationViewer viewer) {
                viewer.rotX.add((double)amount);
            }

            @Override
            public void lateral(float amount, GuiAnimationViewer viewer) {
                viewer.rotY.add((double)(-amount));
            }

            public void apply(Vector3f vec, GuiAnimationViewer viewer) {
                vec.rotate((Quaternionfc)Axis.f_252529_.m_252977_((float)viewer.rotX.current()));
                vec.rotate((Quaternionfc)Axis.f_252436_.m_252977_((float)viewer.rotY.current()));
                vec.rotate((Quaternionfc)Axis.f_252403_.m_252977_((float)viewer.rotZ.current()));
                viewer.offX.set(viewer.offX.aimed() + (double)vec.x);
                viewer.offY.set(viewer.offY.aimed() + (double)vec.y);
                viewer.offZ.set(viewer.offZ.aimed() + (double)vec.z);
            }

            @Override
            public void prepareRendering(PoseStack pose, Vec3d center, GuiAnimationViewer viewer) {
                pose.m_85837_(viewer.offX.current(), viewer.offY.current(), viewer.offZ.current() - viewer.distance.current());
                pose.m_252781_(Axis.f_252529_.m_252977_((float)viewer.rotX.current()));
                pose.m_252781_(Axis.f_252436_.m_252977_((float)viewer.rotY.current()));
                pose.m_252781_(Axis.f_252403_.m_252977_((float)viewer.rotZ.current()));
                pose.m_85837_(-center.x, -center.y, -center.z);
            }

            @Override
            public ProjectionMode next() {
                return PLAYER;
            }

            @Override
            public void up(float amount, GuiAnimationViewer viewer) {
                viewer.offZ.add((double)(amount * 0.05f));
            }
        }
        ,
        PLAYER{

            @Override
            public void init(GuiAnimationViewer viewer) {
                viewer.offZ.set(viewer.storage.longestSide() / 2.0);
                viewer.offY.set(-viewer.storage.overall().m_82309_());
                viewer.rotX.set(45.0);
                viewer.rotY.set(180.0);
            }

            @Override
            public void dragMouse(GuiAnimationViewer viewer, double x, double y) {
            }

            @Override
            public void forward(float amount, GuiAnimationViewer viewer) {
                amount = (float)((double)amount * 0.1);
                viewer.offX.add((double)amount * Math.sin(-viewer.rotY.aimed() * Math.PI / 180.0));
                viewer.offZ.add((double)amount * Math.cos(viewer.rotY.aimed() * Math.PI / 180.0));
            }

            @Override
            public void lateral(float amount, GuiAnimationViewer viewer) {
                amount = (float)((double)amount * -0.1);
                viewer.offX.add((double)amount * Math.cos(-viewer.rotY.aimed() * Math.PI / 180.0));
                viewer.offZ.add((double)amount * Math.sin(viewer.rotY.aimed() * Math.PI / 180.0));
            }

            @Override
            public void prepareRendering(PoseStack pose, Vec3d center, GuiAnimationViewer viewer) {
                pose.m_252781_(Axis.f_252529_.m_252977_((float)viewer.rotX.current()));
                pose.m_252781_(Axis.f_252436_.m_252977_((float)viewer.rotY.current()));
                pose.m_252781_(Axis.f_252403_.m_252977_((float)viewer.rotZ.current()));
                pose.m_85837_(viewer.offX.current(), viewer.offY.current(), viewer.offZ.current());
                pose.m_85837_(-center.x, -center.y, -center.z);
            }

            @Override
            public ProjectionMode next() {
                return SHOWCASE;
            }

            @Override
            public void up(float amount, GuiAnimationViewer viewer) {
                viewer.offY.add((double)amount * -0.1);
            }
        };


        public abstract ProjectionMode next();

        public abstract void init(GuiAnimationViewer var1);

        public abstract void prepareRendering(PoseStack var1, Vec3d var2, GuiAnimationViewer var3);

        public abstract void dragMouse(GuiAnimationViewer var1, double var2, double var4);

        public abstract void forward(float var1, GuiAnimationViewer var2);

        public abstract void lateral(float var1, GuiAnimationViewer var2);

        public abstract void up(float var1, GuiAnimationViewer var2);
    }
}

