/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.controls.animation;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiIcon;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeAnimationStorage;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.math.box.LittleBox;

public class GuiIsoAnimationViewer
extends GuiControl {
    private static final float MAXIMUM_ZOOM = 1.0f / (float)LittleGrid.defaultGrid().pixelLength;
    protected SmoothValue rotX = new SmoothValue(200L);
    protected SmoothValue rotY = new SmoothValue(200L);
    protected SmoothValue rotZ = new SmoothValue(200L);
    protected SmoothValue scale = new SmoothValue(200L, 1.0);
    protected SmoothValue offX = new SmoothValue(200L);
    protected SmoothValue offY = new SmoothValue(200L);
    private GuiIsoView view;
    private boolean initialized = false;
    private boolean grabbed = false;
    public double grabX;
    public double grabY;
    public final GuiTreeItemStructure item;
    private LittleBox box;
    private LittleGrid grid;
    private boolean even;
    public boolean visibleAxis = true;

    public GuiIsoAnimationViewer(String name, GuiTreeItemStructure item, LittleBox box, LittleGrid grid, boolean even) {
        super(name);
        this.item = item;
        this.setView(GuiIsoView.UP);
        this.box = box.copy();
        this.grid = grid;
        this.even = even;
    }

    public LittleBox getBox() {
        return this.box;
    }

    public LittleGrid getGrid() {
        return this.grid;
    }

    public void setAxis(LittleBox box, LittleGrid grid) {
        this.box = box.copy();
        this.grid = grid;
        this.raiseEvent((GuiEvent)new GuiAnimationAxisChangedEvent(this));
    }

    public boolean isEven() {
        return this.even;
    }

    public void setEven(boolean even) {
        boolean changed = this.even != even;
        this.even = even;
        if (!changed || this.box == null) {
            return;
        }
        if (even) {
            --this.box.minX;
            --this.box.minY;
            --this.box.minZ;
        } else {
            ++this.box.minX;
            ++this.box.minY;
            ++this.box.minZ;
        }
        this.raiseEvent((GuiEvent)new GuiAnimationAxisChangedEvent(this));
    }

    public void setView(GuiIsoView view) {
        this.view = view;
        this.rotX.set((double)view.rotX);
        this.rotY.set((double)view.rotY);
        this.rotZ.set((double)view.rotZ);
        if (this.getParent() != null) {
            this.raiseEvent((GuiEvent)new GuiAnimationViewChangedEvent(this));
        }
    }

    public void mouseMoved(Rect rect, double x, double y) {
        super.mouseMoved(rect, x, y);
        if (!this.grabbed) {
            return;
        }
        double scale = this.calculateScale(rect);
        this.offX.add((x - this.grabX) / scale);
        this.offY.add((y - this.grabY) / scale);
        this.grabX = x;
        this.grabY = y;
    }

    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        switch (button) {
            case 0: {
                this.grabX = x;
                this.grabY = y;
                this.grabbed = true;
                break;
            }
            case 1: {
                this.clickToSetAxis(rect, x, y);
                break;
            }
            case 2: {
                this.resetView();
            }
        }
        return true;
    }

    public void mouseReleased(Rect rect, double x, double y, int button) {
        this.grabbed = false;
    }

    public boolean mouseScrolled(Rect rect, double x, double y, double delta) {
        this.scale.add(0.05 * delta * (double)(Screen.m_96637_() ? 5 : 1));
        if (Math.pow(this.scale.aimed(), 2.0) > (double)MAXIMUM_ZOOM) {
            this.scale.set(Math.sqrt(MAXIMUM_ZOOM));
        }
        if (this.scale.aimed() < 0.0) {
            this.scale.set(0.0);
        }
        return true;
    }

    public void clickToSetAxis(Rect rect, double x, double y) {
        GuiRecipeAnimationStorage storage = this.item.recipe.storage;
        if (!storage.isReady() || !storage.isReady(this.item)) {
            return;
        }
        float scale = this.calculateScale(rect);
        Vec3d center = storage.center();
        Axis one = this.view.xAxis.axis;
        int posOne = this.grid.toGrid(-this.offX.current() * (double)this.view.xAxis.offset() + (x - rect.getWidth() / 2.0) / (double)scale * (double)this.view.xAxis.offset() + center.get(one));
        int sizeOne = this.box.getSize(one);
        this.box.setMax(one, posOne + sizeOne);
        this.box.setMin(one, posOne);
        Axis two = this.view.yAxis.axis;
        int posTwo = this.grid.toGrid((-this.offY.current() + (y - rect.getHeight() / 2.0) / (double)scale) * (double)(-this.view.yAxis.offset()) + center.get(two));
        int sizeTwo = this.box.getSize(two);
        this.box.setMax(two, posTwo + sizeTwo);
        this.box.setMin(two, posTwo);
        this.raiseEvent((GuiEvent)new GuiAnimationAxisChangedEvent(this));
        GuiIsoAnimationViewer.playSound((SoundEvent)SoundEvents.f_12632_);
    }

    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED_NO_PADDING;
    }

    public void resetView() {
        this.offX.set(0.0);
        this.offY.set(0.0);
        this.scale.set(Math.sqrt(0.9 / this.item.recipe.storage.longestSide()));
    }

    public void nextAxis() {
        this.setView(Axis.values()[(this.view.zAxis.axis.ordinal() + 1) % Axis.values().length].facing(true));
    }

    public void mirrorView() {
        this.setView(this.view.zAxis.opposite());
    }

    public void setView(Facing facing) {
        this.setView(switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.EAST -> GuiIsoView.EAST;
            case Facing.WEST -> GuiIsoView.WEST;
            case Facing.UP -> GuiIsoView.UP;
            case Facing.DOWN -> GuiIsoView.DOWN;
            case Facing.SOUTH -> GuiIsoView.SOUTH;
            case Facing.NORTH -> GuiIsoView.NORTH;
        });
    }

    protected float calculateScale(Rect rect) {
        float dimensionScale = Math.min((float)rect.getWidth(), (float)rect.getHeight());
        return (float)((double)dimensionScale * Math.pow(this.scale.current(), 2.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack pose, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        GuiRecipeAnimationStorage storage = this.item.recipe.storage;
        if (!storage.isReady() || !storage.isReady(this.item)) {
            return;
        }
        if (!this.initialized) {
            this.resetView();
            this.initialized = true;
        }
        this.rotX.tick();
        this.rotY.tick();
        this.rotZ.tick();
        this.scale.tick();
        this.offX.tick();
        this.offY.tick();
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        pose = RenderSystem.m_157191_();
        pose.m_85836_();
        RenderSystem.m_157182_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        double guiScale = window.m_85449_();
        int height = (int)(rect.getHeight() * guiScale);
        RenderSystem.m_69949_((int)((int)(rect.minX * guiScale)), (int)((int)((double)window.m_85442_() - rect.minY * guiScale - (double)height)), (int)((int)(rect.getWidth() * guiScale)), (int)height);
        RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
        PoseStack projection = new PoseStack();
        projection.m_166856_();
        projection.m_252931_(new Matrix4f().setOrtho(0.0f, (float)rect.getWidth(), 0.0f, (float)rect.getHeight(), 1000.0f, ForgeHooksClient.getGuiFarPlane()));
        RenderSystem.m_252934_((Matrix4f)projection.m_85850_().m_252922_());
        Matrix3f matrix3f = new Matrix3f((Matrix3fc)projection.m_85850_().m_252943_()).invert();
        RenderSystem.m_253212_((Matrix3f)matrix3f);
        Vec3d center = storage.center();
        pose.m_85837_(rect.getWidth() / 2.0, rect.getHeight() / 2.0, 0.0);
        float scale = this.calculateScale(rect);
        pose.m_85841_(scale, scale, scale);
        pose.m_85837_(this.offX.current(), -this.offY.current(), 0.0);
        pose.m_252781_(com.mojang.math.Axis.f_252529_.m_252977_((float)this.rotX.current()));
        pose.m_252781_(com.mojang.math.Axis.f_252436_.m_252977_((float)this.rotY.current()));
        pose.m_252781_(com.mojang.math.Axis.f_252403_.m_252977_((float)this.rotZ.current()));
        pose.m_85837_(-center.x, -center.y, -center.z);
        storage.renderAll(pose, projection.m_85850_().m_252922_(), mc);
        RenderSystem.m_157182_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69464_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.visibleAxis) {
            RenderSystem.m_157427_(GameRenderer::m_172757_);
            PoseStack empty = new PoseStack();
            empty.m_166856_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
            int colorAlpha = 255;
            LittleRenderBox renderBox = this.box.getRenderingBox(this.grid);
            RenderSystem.m_69465_();
            RenderSystem.m_69832_((float)16.0f);
            renderBox.renderLines(empty, (VertexConsumer)bufferbuilder, colorAlpha);
            tesselator.m_85914_();
        }
        pose.m_85849_();
        RenderSystem.m_69949_((int)0, (int)0, (int)window.m_85441_(), (int)window.m_85442_());
        RenderSystem.m_252934_((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)((double)window.m_85441_() / window.m_85449_()), (float)((double)window.m_85442_() / window.m_85449_()), 0.0f, 1000.0f, ForgeHooksClient.getGuiFarPlane()));
        RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
        Lighting.m_84931_();
        RenderSystem.m_69465_();
        pose.m_85836_();
        RenderSystem.m_157182_();
        int axisWidth = 20;
        int axisHeight = 16;
        pose.m_85837_(rect.getWidth() / 2.0 - (double)(axisWidth / 2), rect.getHeight() - (double)axisHeight - 2.0, 0.0);
        Minecraft.m_91087_().f_91062_.m_92750_(pose, this.view.xAxis.axis.name(), 0.0f, 0.0f, -1);
        GuiIcon icon = this.view.xAxis.positive ? GuiIcon.ARROW_RIGHT : GuiIcon.ARROW_LEFT;
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon.location());
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GuiRenderHelper.textureRect((PoseStack)pose, (int)5, (int)0, (int)icon.minX(), (int)icon.minY(), (float)(icon.minX() + icon.width()), (float)(icon.minY() + icon.height()));
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiRenderHelper.textureRect((PoseStack)pose, (int)4, (int)0, (int)icon.minX(), (int)icon.minY(), (float)(icon.minX() + icon.width()), (float)(icon.minY() + icon.height()));
        pose.m_85849_();
        RenderSystem.m_157182_();
    }

    public void closed() {
    }

    public void init() {
    }

    public void tick() {
    }

    public void flowX(int width, int preferred) {
    }

    public void flowY(int width, int height, int preferred) {
    }

    protected int preferredWidth(int availableWidth) {
        return 10;
    }

    protected int preferredHeight(int width, int availableHeight) {
        return 10;
    }

    public Axis axis() {
        return this.view.zAxis.axis;
    }

    public Facing getXFacing() {
        return this.view.xAxis;
    }

    public Facing getYFacing() {
        return this.view.yAxis;
    }

    public Facing getZFacing() {
        return this.view.zAxis;
    }

    static enum GuiIsoView {
        UP(90.0f, 90.0f, 0.0f, Facing.SOUTH, Facing.EAST, Facing.UP),
        DOWN(-90.0f, 90.0f, 0.0f, Facing.SOUTH, Facing.WEST, Facing.DOWN),
        EAST(0.0f, -90.0f, 0.0f, Facing.NORTH, Facing.UP, Facing.EAST),
        WEST(0.0f, 90.0f, 0.0f, Facing.SOUTH, Facing.UP, Facing.WEST),
        SOUTH(0.0f, 0.0f, 0.0f, Facing.EAST, Facing.UP, Facing.SOUTH),
        NORTH(0.0f, 180.0f, 0.0f, Facing.WEST, Facing.UP, Facing.NORTH);

        public final float rotX;
        public final float rotY;
        public final float rotZ;
        public final Facing xAxis;
        public final Facing yAxis;
        public final Facing zAxis;

        private GuiIsoView(float rotX, float rotY, float rotZ, Facing xAxis, Facing yAxis, Facing zAxis) {
            this.rotX = rotX;
            this.rotY = rotY;
            this.rotZ = rotZ;
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.zAxis = zAxis;
        }
    }

    public static class GuiAnimationAxisChangedEvent
    extends GuiControlChangedEvent {
        public GuiAnimationAxisChangedEvent(GuiIsoAnimationViewer viewer) {
            super((GuiControl)viewer);
        }
    }

    public static class GuiAnimationViewChangedEvent
    extends GuiControlChangedEvent {
        public GuiAnimationViewChangedEvent(GuiIsoAnimationViewer viewer) {
            super((GuiControl)viewer);
        }
    }
}

