/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.premade;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.controls.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.convertion.OldLittleTilesDataParser;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.item.ItemLittleBlueprint;

public class GuiImport
extends GuiLayer {
    public GuiTextfield textfield;
    public Container importSlot = new SimpleContainer(1);
    public GuiSyncLocal<CompoundTag> IMPORT_DATA = this.getSyncHolder().register("import_data", nbt -> {
        ItemStack stack = this.importSlot.m_8020_(0);
        if (stack.m_41720_() instanceof ItemLittleBlueprint || this.getPlayer().m_7500_() && stack.m_41619_()) {
            if (stack.m_41619_()) {
                stack = new ItemStack((ItemLike)LittleTilesRegistry.BLUEPRINT.get());
                this.importSlot.m_6836_(0, stack);
            }
            try {
                if (OldLittleTilesDataParser.isOld(nbt)) {
                    nbt = OldLittleTilesDataParser.convert(nbt);
                }
                LittleGrid.get(nbt);
                CompoundTag stackTag = stack.m_41784_();
                stackTag.m_128365_("c", (Tag)nbt);
                ((GuiInventoryGrid)this.get("import", GuiInventoryGrid.class)).setChanged();
            }
            catch (RuntimeException | OldLittleTilesDataParser.LittleConvertException e) {
                e.printStackTrace();
            }
        }
    });

    public GuiImport() {
        super("import");
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.STRETCH;
    }

    public void create() {
        this.textfield = new GuiTextfield("import_textfield");
        this.add((GuiControl)this.textfield);
        this.textfield.setMaxStringLength(Integer.MAX_VALUE);
        GuiParent secondRow = new GuiParent();
        this.add((GuiControl)secondRow);
        secondRow.add((GuiControl)new GuiButton("paste_button", x -> {
            String text = Minecraft.m_91087_().f_91068_.m_90876_();
            if (text == null) {
                text = "";
            }
            this.textfield.setText(text);
        }).setTranslate("gui.paste"));
        secondRow.add((GuiControl)new GuiButton("import_button", x -> {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)this.textfield.getText());
                try {
                    LittleGrid.get(nbt);
                    this.IMPORT_DATA.send((Tag)nbt);
                }
                catch (RuntimeException e) {
                    GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"invalid_grid", (MutableComponent)Component.m_237110_((String)"invalid_grid", (Object[])new Object[]{nbt.m_128461_("grid")}), (y, z) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
                }
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }).setTranslate("gui.import"));
        this.add((GuiControl)new GuiInventoryGrid("import", this.importSlot));
        this.add(new GuiPlayerInventoryGrid(this.getPlayer()).setUnexpandableX());
    }
}

