/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal;

import java.util.ArrayList;
import java.util.List;
import team.creative.creativecore.common.gui.controls.tree.GuiTreeItem;
import team.creative.littletiles.common.gui.signal.GuiSignalComponent;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;

public class GuiComponentSearch {
    public GuiTreeItemStructure item;

    public GuiComponentSearch(GuiTreeItemStructure item) {
        this.item = item;
    }

    public List<GuiSignalComponent> search(boolean input, boolean output, boolean includeRelations) {
        ArrayList<GuiSignalComponent> list = new ArrayList<GuiSignalComponent>();
        if (input) {
            this.gatherInputs(this.item, "", "", list, includeRelations, true);
        }
        if (output) {
            this.gatherOutputs(this.item, "", "", list, includeRelations, true);
        }
        return list;
    }

    public GuiSignalComponent[] internalOutputs() {
        LittleStructureType type = this.item.getStructureType();
        if (type != null && type.outputs != null) {
            GuiSignalComponent[] components = new GuiSignalComponent[type.outputs.size()];
            for (int i = 0; i < type.outputs.size(); ++i) {
                components[i] = new GuiSignalComponent("b" + i, "", type.outputs.get(i), false, false, i);
            }
            return components;
        }
        return null;
    }

    public List<GuiSignalComponent> externalOutputs() {
        ArrayList<GuiSignalComponent> components = new ArrayList<GuiSignalComponent>();
        this.addExternalOutputs(this.item, "", "", components, false);
        return components;
    }

    protected void addInput(GuiTreeItemStructure item, String prefix, String totalNamePrefix, List<GuiSignalComponent> list, boolean includeRelations) {
        int i;
        LittleStructureType type = item.getStructureType();
        if (type != null && type.inputs != null) {
            for (i = 0; i < type.inputs.size(); ++i) {
                list.add(new GuiSignalComponent(prefix + "a" + i, totalNamePrefix, type.inputs.get(i), true, false, i));
            }
        }
        i = 0;
        for (GuiTreeItem child : item.items()) {
            ISignalComponent com;
            if (child == this.item) continue;
            GuiTreeItemStructure childStructure = (GuiTreeItemStructure)child;
            if (childStructure.structure == null) continue;
            String name = childStructure.structure.name;
            LittleStructure littleStructure = childStructure.structure;
            if (littleStructure instanceof ISignalComponent && (com = (ISignalComponent)((Object)littleStructure)).getComponentType() == SignalComponentType.INPUT) {
                list.add(new GuiSignalComponent(prefix + "i" + i, totalNamePrefix + (String)(name != null ? name : "i" + i), com, true, i));
            } else if (includeRelations) {
                this.gatherInputs(childStructure, prefix + "c" + i + ".", totalNamePrefix + (name != null ? name + "." : "c" + i + "."), list, includeRelations, false);
            }
            ++i;
        }
    }

    protected void gatherInputs(GuiTreeItemStructure item, String prefix, String totalNamePrefix, List<GuiSignalComponent> list, boolean includeRelations, boolean searchForParent) {
        GuiTreeItem guiTreeItem;
        if (item == this.item) {
            this.addInput(item, "", "", list, includeRelations);
        }
        if (searchForParent && includeRelations && (guiTreeItem = item.getParentItem()) instanceof GuiTreeItemStructure) {
            GuiTreeItemStructure parent = (GuiTreeItemStructure)guiTreeItem;
            this.gatherInputs(parent, "p." + prefix, "p." + totalNamePrefix, list, includeRelations, true);
            return;
        }
        if (item != this.item) {
            this.addInput(item, prefix, totalNamePrefix, list, includeRelations);
        }
    }

    protected void addExternalOutputs(GuiTreeItemStructure item, String prefix, String totalNamePrefix, List<GuiSignalComponent> list, boolean includeRelations) {
        int i = 0;
        for (GuiTreeItem child : item.items()) {
            ISignalComponent com;
            if (child == this.item) continue;
            GuiTreeItemStructure childStructure = (GuiTreeItemStructure)child;
            if (childStructure.structure == null) continue;
            String name = childStructure.structure.name;
            LittleStructure littleStructure = childStructure.structure;
            if (littleStructure instanceof ISignalComponent && (com = (ISignalComponent)((Object)littleStructure)).getComponentType() == SignalComponentType.OUTPUT) {
                list.add(new GuiSignalComponent(prefix + "o" + i, totalNamePrefix + (String)(name != null ? name : "o" + i), com, true, i));
                continue;
            }
            if (!includeRelations) continue;
            this.gatherOutputs(childStructure, prefix + "c" + i + ".", totalNamePrefix + (name != null ? name + "." : "c" + i + "."), list, includeRelations, false);
        }
    }

    protected void addOutput(GuiTreeItemStructure item, String prefix, String totalNamePrefix, List<GuiSignalComponent> list, boolean includeRelations) {
        LittleStructureType type = item.getStructureType();
        if (type != null && type.outputs != null) {
            for (int i = 0; i < type.outputs.size(); ++i) {
                list.add(new GuiSignalComponent(prefix + "b" + i, totalNamePrefix, type.outputs.get(i), false, false, i));
            }
        }
        this.addExternalOutputs(item, prefix, totalNamePrefix, list, includeRelations);
    }

    protected void gatherOutputs(GuiTreeItemStructure item, String prefix, String totalNamePrefix, List<GuiSignalComponent> list, boolean includeRelations, boolean searchForParent) {
        GuiTreeItem guiTreeItem;
        if (item == this.item) {
            this.addOutput(item, "", "", list, includeRelations);
        }
        if (searchForParent && includeRelations && (guiTreeItem = item.getParentItem()) instanceof GuiTreeItemStructure) {
            GuiTreeItemStructure parent = (GuiTreeItemStructure)guiTreeItem;
            this.gatherOutputs(parent, "p." + prefix, "p." + totalNamePrefix, list, includeRelations, searchForParent);
            return;
        }
        if (item != this.item) {
            this.addOutput(item, prefix, totalNamePrefix, list, includeRelations);
        }
    }
}

