/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.ChatFormatting;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;

public final class GuiSignalComponent
extends Record {
    private final String name;
    private final boolean input;
    private final boolean external;
    private final int index;
    private final int bandwidth;
    private final String totalName;
    private final SignalMode defaultMode;

    public GuiSignalComponent(String name, boolean input, boolean external, int index, int bandwidth, String totalName, SignalMode defaultMode) {
        this.name = name;
        this.input = input;
        this.external = external;
        this.index = index;
        this.bandwidth = bandwidth;
        this.totalName = totalName;
        this.defaultMode = defaultMode;
    }

    public GuiSignalComponent(String name, String prefix, LittleStructureType.InternalComponent component, boolean input, boolean external, int index) {
        SignalMode signalMode;
        int n = component.bandwidth;
        String string = prefix + component.identifier;
        if (component instanceof LittleStructureType.InternalComponentOutput) {
            LittleStructureType.InternalComponentOutput output = (LittleStructureType.InternalComponentOutput)component;
            signalMode = output.defaultMode;
        } else {
            signalMode = SignalMode.EQUAL;
        }
        this(name, input, external, index, n, string, signalMode);
    }

    public GuiSignalComponent(String name, String totalName, ISignalComponent component, boolean external, int index) {
        this(name, component.getComponentType() == SignalComponentType.INPUT, external, index, GuiSignalComponent.getBandwidth(component), totalName, SignalMode.EQUAL);
    }

    public GuiSignalComponent(String name, String totalName, int bandwidth, SignalComponentType type, boolean external, int index) {
        this(name, type == SignalComponentType.INPUT, external, index, bandwidth, totalName, SignalMode.EQUAL);
    }

    public String display() {
        if (this.name.equals(this.totalName)) {
            return ChatFormatting.BOLD + this.name + " " + ChatFormatting.RESET + this.bandwidth + "-bit";
        }
        return ChatFormatting.BOLD + this.name + " " + this.totalName + " " + ChatFormatting.RESET + this.bandwidth + "-bit";
    }

    public String info() {
        if (this.totalName == null) {
            return this.name;
        }
        return this.name + " " + this.totalName;
    }

    private static int getBandwidth(ISignalComponent component) {
        try {
            return component.getBandwidth();
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{GuiSignalComponent.class, "name;input;external;index;bandwidth;totalName;defaultMode", "name", "input", "external", "index", "bandwidth", "totalName", "defaultMode"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GuiSignalComponent.class, "name;input;external;index;bandwidth;totalName;defaultMode", "name", "input", "external", "index", "bandwidth", "totalName", "defaultMode"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GuiSignalComponent.class, "name;input;external;index;bandwidth;totalName;defaultMode", "name", "input", "external", "index", "bandwidth", "totalName", "defaultMode"}, this, o);
    }

    public String name() {
        return this.name;
    }

    public boolean input() {
        return this.input;
    }

    public boolean external() {
        return this.external;
    }

    public int index() {
        return this.index;
    }

    public int bandwidth() {
        return this.bandwidth;
    }

    public String totalName() {
        return this.totalName;
    }

    public SignalMode defaultMode() {
        return this.defaultMode;
    }
}

