/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.simple.GuiColorPicker;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiShowItem;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.Color;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.LittleGuiUtils;
import team.creative.littletiles.common.gui.controls.GuiGridConfig;
import team.creative.littletiles.common.gui.tool.GuiConfigureTool;
import team.creative.littletiles.common.item.ItemLittleChisel;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeRegistry;

public class GuiChisel
extends GuiConfigureTool {
    public GuiChisel(ContainerSlotView view) {
        super("chisel", 230, 200, view);
        this.registerEventChanged(x -> {
            if (x.control.is("shape")) {
                this.onChange();
            } else if (x.control.is(new String[]{"picker", "preview"})) {
                this.updateLabel();
            }
        });
        this.flow = GuiFlow.STACK_X;
        this.valign = VAlign.STRETCH;
        this.registerEventChanged(x -> {
            if (x.control.is("mode")) {
                GuiComboBoxMapped modeBox = (GuiComboBoxMapped)x.control;
                TextBuilder builder = new TextBuilder();
                if (((PlacementMode)modeBox.getSelected()).canPlaceStructures()) {
                    builder.text("" + ChatFormatting.BOLD).translate("placement.mode.placestructure").text("" + ChatFormatting.WHITE).newLine();
                }
                builder.translate(((PlacementMode)modeBox.getSelected()).translatableKey() + ".tooltip");
                ((GuiLabel)this.get("text")).setTitle(builder.build());
                ItemMultiTiles.currentMode = (PlacementMode)modeBox.getSelected();
            }
        });
    }

    public void create() {
        if (!this.isClient()) {
            return;
        }
        GuiParent left = new GuiParent((GuiFlow)GuiFlow.STACK_Y).setAlign(Align.STRETCH);
        this.add((GuiControl)left);
        LittleElement element = ItemLittleChisel.getElement(this.tool.get());
        Color color = new Color(element.color);
        left.add((GuiControl)new GuiColorPicker("picker", color, LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())));
        GuiParent parent = new GuiParent((GuiFlow)GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        left.add((GuiControl)parent);
        parent.add(new GuiShowItem("item").setDim(60, 60));
        parent.add((GuiControl)new GuiGridConfig("grid", ItemMultiTiles.currentGrid, x -> {
            ItemMultiTiles.currentGrid = x;
            if (ItemLittleChisel.selection != null) {
                ItemLittleChisel.selection.convertTo((LittleGrid)x);
            }
        }));
        GuiStackSelector selector = new GuiStackSelector("preview", this.getPlayer(), LittleGuiUtils.getCollector(this.getPlayer()), true);
        selector.setSelectedForce(element.getBlock().getStack());
        left.add((GuiControl)selector);
        GuiComboBoxMapped box = new GuiComboBoxMapped("shape", new TextMapBuilder().addComponent(ShapeRegistry.placingShapes(), x -> Component.m_237115_((String)x.getTranslatableName())));
        box.select((Object)ItemLittleChisel.getShape(this.tool.get()));
        left.add((GuiControl)box);
        left.add((GuiControl)new GuiScrollY("settings").setDim(20, 60).setExpandable());
        GuiParent right = new GuiParent((GuiFlow)GuiFlow.STACK_Y).setAlign(Align.STRETCH);
        this.add((GuiControl)right);
        GuiComboBoxMapped modeBox = new GuiComboBoxMapped("mode", PlacementMode.map());
        modeBox.select((Object)ItemMultiTiles.currentMode);
        right.add((GuiControl)modeBox);
        right.add((GuiControl)new GuiLabel("text"));
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)modeBox));
        this.onChange();
        this.updateLabel();
    }

    public void onChange() {
        GuiComboBoxMapped box = (GuiComboBoxMapped)this.get("shape");
        GuiScrollY scroll = (GuiScrollY)this.get("settings");
        scroll.clear();
        for (GuiControl control : ((LittleShape)box.getSelected((Object)ShapeRegistry.DEFAULT_SHAPE)).getCustomSettings(this.tool.get().m_41783_(), this.getGrid())) {
            scroll.add(control);
        }
        scroll.reflow();
    }

    public void updateLabel() {
        LittleElement element;
        GuiStackSelector selector = (GuiStackSelector)this.get("preview");
        ItemStack selected = selector.getSelected();
        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
        try {
            element = LittleElement.of(selected, picker.color.toInt());
        }
        catch (LittleElement.NotBlockException e) {
            element = new LittleElement(ItemLittleChisel.getElement(this.tool.get()), picker.color.toInt());
        }
        ((GuiShowItem)this.get((String)"item", GuiShowItem.class)).stack = ItemMultiTiles.of(element);
    }

    @Override
    public CompoundTag saveConfiguration(CompoundTag nbt) {
        LittleElement element;
        GuiComboBoxMapped box = (GuiComboBoxMapped)this.get("shape");
        GuiScrollY scroll = (GuiScrollY)this.get("settings");
        LittleShape shape = (LittleShape)box.getSelected((Object)ShapeRegistry.DEFAULT_SHAPE);
        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
        GuiStackSelector selector = (GuiStackSelector)this.get("preview");
        ItemStack selected = selector.getSelected();
        try {
            element = LittleElement.of(selected, picker.color.toInt());
        }
        catch (LittleElement.NotBlockException e) {
            element = new LittleElement(ItemLittleChisel.getElement(this.tool.get()), picker.color.toInt());
        }
        ItemLittleChisel.setElement(nbt, element);
        ItemLittleChisel.setShape(nbt, shape);
        shape.saveCustomSettings((GuiParent)scroll, nbt, this.getGrid());
        return nbt;
    }
}

