/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe;

import java.util.Collections;
import java.util.Iterator;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButtonMapped;
import team.creative.creativecore.common.gui.controls.tree.GuiTree;
import team.creative.creativecore.common.gui.controls.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.creativecore.common.util.type.itr.SingleIterator;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.controls.GuiDistanceControl;
import team.creative.littletiles.common.gui.controls.animation.GuiAnimationPanel;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipe;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTest;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;

public class GuiRecipeMove
extends GuiLayer {
    public GuiRecipe recipe;
    public GuiTree tree;

    public GuiRecipeMove() {
        super("gui.recipe.move", 400, 200);
        this.flow = GuiFlow.STACK_Y;
        this.registerEventChanged(x -> {
            if (x.control.is("modes")) {
                ((GuiRecipeMoveMode)((Object)((Object)((GuiStateButtonMapped)x.control).getSelected()))).select(this.tree);
            }
        });
    }

    public void init(GuiRecipe recipe) {
        this.recipe = recipe;
        this.clear();
        this.init();
    }

    public void closed() {
        if (this.tree == null) {
            return;
        }
        for (GuiTreeItem item : () -> this.tree.allItems()) {
            if (!(item instanceof GuiRecipeMoveItem)) continue;
            GuiRecipeMoveItem move = (GuiRecipeMoveItem)item;
            move.structure.resetOffset();
        }
    }

    public void create() {
        if (this.recipe == null) {
            return;
        }
        GuiParent upper = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)upper);
        GuiParent sidebar = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        upper.add(sidebar.setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRatioRules().widthRatio(0.3f).maxWidth(100)).setExpandableY());
        this.tree = new GuiTree("tree").setRootVisibility(false);
        sidebar.add(this.tree.setExpandable());
        for (GuiTreeItem item : this.recipe.tree.root().items()) {
            GuiRecipeMoveItem child = new GuiRecipeMoveItem(this.tree, (GuiTreeItemStructure)item);
            this.tree.root().addItem((GuiTreeItem)child);
            child.addChildren();
        }
        GuiStateButtonMapped modes = new GuiStateButtonMapped("modes", new TextMapBuilder().addComponent((Object[])GuiRecipeMoveMode.values(), x -> x.title()));
        sidebar.add(modes.setExpandableX());
        GuiParent config = new GuiParent((GuiFlow)GuiFlow.STACK_Y).setAlign(Align.CENTER);
        upper.add(config.setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRatioRules().widthRatio(0.3f)));
        config.add((GuiControl)new GuiDistanceControl("distance", LittleGrid.defaultGrid(), 1));
        GuiParent row1 = new GuiParent();
        config.add((GuiControl)row1);
        row1.add((GuiControl)new GuiRecipeMoveButton(Facing.EAST));
        row1.add((GuiControl)new GuiRecipeMoveButton(Facing.UP));
        row1.add((GuiControl)new GuiRecipeMoveButton(Facing.SOUTH));
        GuiParent row2 = new GuiParent();
        config.add((GuiControl)row2);
        row2.add((GuiControl)new GuiRecipeMoveButton(Facing.WEST));
        row2.add((GuiControl)new GuiRecipeMoveButton(Facing.DOWN));
        row2.add((GuiControl)new GuiRecipeMoveButton(Facing.NORTH));
        upper.add((GuiControl)new GuiAnimationPanel(this.recipe.tree, this.recipe.storage, true, null));
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addLeft((GuiControl)new GuiButton("cancel", x -> this.closeThisLayer()).setTranslate("gui.cancel"));
        bottom.addRight((GuiControl)new GuiButton("test", x -> {
            this.recipe.storage.resetOverlap();
            RecipeTest.testModule(this.recipe, RecipeTest.OVERLAP_TEST);
        }).setTranslate("gui.recipe.test.overlap"));
        bottom.addRight((GuiControl)new GuiButton("save", x -> {
            for (GuiTreeItem item : () -> this.tree.allItems()) {
                if (!(item instanceof GuiRecipeMoveItem)) continue;
                GuiRecipeMoveItem move = (GuiRecipeMoveItem)item;
                move.structure.applyOffset();
            }
            this.closeThisLayer();
        }).setTranslate("gui.save"));
        this.tree.updateTree();
    }

    public void move(Facing facing) {
        GuiDistanceControl distance = (GuiDistanceControl)this.get("distance");
        GuiStateButtonMapped modes = (GuiStateButtonMapped)this.get("modes");
        LittleVec direction = new LittleVec(facing);
        direction.scale(distance.getDistance());
        LittleVecGrid vec = new LittleVecGrid(direction, distance.getDistanceGrid());
        for (GuiRecipeMoveItem item : () -> ((GuiRecipeMoveMode)((Object)((Object)modes.getSelected()))).iterator(this.tree)) {
            item.addOffset(vec);
        }
    }

    public class GuiRecipeMoveItem
    extends GuiTreeItem {
        public final GuiTreeItemStructure structure;

        public GuiRecipeMoveItem(GuiTree tree, GuiTreeItemStructure structure) {
            super("item", tree);
            this.structure = structure;
            this.setTitle((Component)Component.m_237113_((String)structure.getTitle()));
        }

        public void addOffset(LittleVecGrid vec) {
            LittleVecGrid offset = this.structure.getOffset();
            if (offset == null) {
                this.structure.setOffset(vec.copy());
            } else {
                offset.add(vec);
            }
        }

        public void addChildren() {
            for (GuiTreeItem item : this.structure.items()) {
                GuiRecipeMoveItem child = new GuiRecipeMoveItem(this.tree, (GuiTreeItemStructure)item);
                this.addItem(child);
                child.addChildren();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GuiRecipeMoveMode {
        DEFAULT(false){

            @Override
            public Iterator<GuiRecipeMoveItem> iterator(GuiTree tree) {
                if (tree.selected() == null) {
                    return Collections.emptyIterator();
                }
                return new SingleIterator((Object)((GuiRecipeMoveItem)tree.selected()));
            }
        }
        ,
        CHECKBOX(true){

            @Override
            public Iterator<GuiRecipeMoveItem> iterator(GuiTree tree) {
                return new FunctionIterator(tree.itemsChecked(), x -> (GuiRecipeMoveItem)((Object)x));
            }
        };

        public final boolean checkboxes;

        private GuiRecipeMoveMode(boolean checkboxes) {
            this.checkboxes = checkboxes;
        }

        public Component title() {
            return Component.m_237115_((String)("gui.recipe.move.mode." + this.name().toLowerCase()));
        }

        public void select(GuiTree tree) {
            tree.setCheckboxes(this.checkboxes, false);
            tree.updateTree();
        }

        public abstract Iterator<GuiRecipeMoveItem> iterator(GuiTree var1);
    }

    public class GuiRecipeMoveButton
    extends GuiButton {
        public GuiRecipeMoveButton(Facing facing) {
            super(facing.name, x -> GuiRecipeMove.this.move(facing));
            this.setTitle(facing.translate());
        }
    }
}

