/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.level.little;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.eventbus.api.Event;
import org.slf4j.Logger;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.mixin.server.level.ChunkSerializerAccessor;
import team.creative.littletiles.server.level.little.LittleServerLevel;

public class LittleChunkSerializer {
    public static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = ChunkSerializerAccessor.getBLOCK_STATE_CODEC();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static LevelChunk read(LittleLevel level, CompoundTag nbt) {
        ChunkPos chunkpos = new ChunkPos(nbt.m_128451_("xPos"), nbt.m_128451_("zPos"));
        ListTag listtag = nbt.m_128437_("sections", 10);
        int i = level.m_151559_();
        LevelChunkSection[] alevelchunksection = new LevelChunkSection[i];
        boolean chunkSkyLight = level.m_6042_().f_223549_();
        ChunkSource chunksource = level.m_7726_();
        LevelLightEngine levellightengine = chunksource.m_7827_();
        Registry registry = level.m_9598_().m_175515_(Registries.f_256952_);
        boolean retained = false;
        for (int j = 0; j < listtag.size(); ++j) {
            boolean hasSkyLight;
            CompoundTag compoundtag = listtag.m_128728_(j);
            byte y = compoundtag.m_128445_("Y");
            int l = level.m_151566_(y);
            if (l >= 0 && l < alevelchunksection.length) {
                LevelChunkSection levelchunksection;
                PalettedContainer states = compoundtag.m_128425_("block_states", 10) ? (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundtag.m_128469_("block_states")).promotePartial(error -> LittleChunkSerializer.logErrors(chunkpos, y, error)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)) : new PalettedContainer((IdMap)Block.f_49791_, (Object)Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_);
                alevelchunksection[l] = levelchunksection = new LevelChunkSection((int)y, states, (PalettedContainerRO)new PalettedContainer(registry.m_206115_(), (Object)registry.m_246971_(Biomes.f_48202_), PalettedContainer.Strategy.f_188138_));
            }
            boolean hasBlockLight = compoundtag.m_128425_("BlockLight", 7);
            boolean bl = hasSkyLight = chunkSkyLight && compoundtag.m_128425_("SkyLight", 7);
            if (!hasBlockLight && !hasSkyLight) continue;
            if (!retained) {
                levellightengine.m_6462_(chunkpos, true);
                retained = true;
            }
            if (hasBlockLight) {
                levellightengine.m_5687_(LightLayer.BLOCK, SectionPos.m_123196_((ChunkPos)chunkpos, (int)y), new DataLayer(compoundtag.m_128463_("BlockLight")), true);
            }
            if (!hasSkyLight) continue;
            levellightengine.m_5687_(LightLayer.SKY, SectionPos.m_123196_((ChunkPos)chunkpos, (int)y), new DataLayer(compoundtag.m_128463_("SkyLight")), true);
        }
        LevelChunkTicks blockTicks = LevelChunkTicks.m_193185_((ListTag)nbt.m_128437_("block_ticks", 10), x -> BuiltInRegistries.f_256975_.m_6612_(ResourceLocation.m_135820_((String)x)), (ChunkPos)chunkpos);
        LevelChunkTicks fluidTicks = LevelChunkTicks.m_193185_((ListTag)nbt.m_128437_("fluid_ticks", 10), x -> BuiltInRegistries.f_257020_.m_6612_(ResourceLocation.m_135820_((String)x)), (ChunkPos)chunkpos);
        LevelChunk chunk = new LevelChunk(level.asLevel(), chunkpos, UpgradeData.f_63320_, blockTicks, fluidTicks, nbt.m_128454_("InhabitedTime"), alevelchunksection, LittleChunkSerializer.postLoadChunk(level, nbt), null);
        if (nbt.m_128441_("ForgeCaps")) {
            chunk.readCapsFromNBT(nbt.m_128469_("ForgeCaps"));
        }
        chunk.m_8094_(nbt.m_128471_("isLightOn"));
        CompoundTag heightmaps = nbt.m_128469_("Heightmaps");
        EnumSet<Heightmap.Types> enumset = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types type : chunk.m_6415_().m_62500_()) {
            String s = type.m_64294_();
            if (heightmaps.m_128425_(s, 12)) {
                chunk.m_6511_(type, heightmaps.m_128467_(s));
                continue;
            }
            enumset.add(type);
        }
        Heightmap.m_64256_((ChunkAccess)chunk, enumset);
        if (nbt.m_128471_("shouldSave")) {
            chunk.m_8092_(true);
        }
        ListTag blockEntities = nbt.m_128437_("block_entities", 10);
        for (int j = 0; j < blockEntities.size(); ++j) {
            chunk.m_5604_(blockEntities.m_128728_(j));
        }
        MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load((ChunkAccess)chunk, nbt, ChunkStatus.ChunkType.LEVELCHUNK));
        return chunk;
    }

    private static void logErrors(ChunkPos pos, int y, String error) {
        LOGGER.error("Recoverable errors when loading section [" + pos.f_45578_ + ", " + y + ", " + pos.f_45579_ + "]: " + error);
    }

    public static CompoundTag write(LittleServerLevel level, ChunkAccess chunk) {
        ChunkPos chunkpos = chunk.m_7697_();
        CompoundTag nbt = NbtUtils.m_264171_((CompoundTag)new CompoundTag());
        nbt.m_128405_("xPos", chunkpos.f_45578_);
        nbt.m_128405_("yPos", chunk.m_151560_());
        nbt.m_128405_("zPos", chunkpos.f_45579_);
        nbt.m_128356_("LastUpdate", level.m_46467_());
        nbt.m_128356_("InhabitedTime", chunk.m_6319_());
        LevelChunkSection[] alevelchunksection = chunk.m_7103_();
        ListTag sections = new ListTag();
        ThreadedLevelLightEngine levellightengine = level.getChunkSource().m_7827_();
        for (int i = levellightengine.m_164447_(); i < levellightengine.m_164448_(); ++i) {
            int j = chunk.m_151566_(i);
            boolean flag1 = j >= 0 && j < alevelchunksection.length;
            DataLayer blockLight = levellightengine.m_75814_(LightLayer.BLOCK).m_8079_(SectionPos.m_123196_((ChunkPos)chunkpos, (int)i));
            DataLayer skyLight = levellightengine.m_75814_(LightLayer.SKY).m_8079_(SectionPos.m_123196_((ChunkPos)chunkpos, (int)i));
            if (!flag1 && blockLight == null && skyLight == null) continue;
            CompoundTag sectionTag = new CompoundTag();
            if (flag1) {
                LevelChunkSection levelchunksection = alevelchunksection[j];
                sectionTag.m_128365_("block_states", (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)levelchunksection.m_63019_()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
            }
            if (blockLight != null && !blockLight.m_62575_()) {
                sectionTag.m_128382_("BlockLight", blockLight.m_7877_());
            }
            if (skyLight != null && !skyLight.m_62575_()) {
                sectionTag.m_128382_("SkyLight", skyLight.m_7877_());
            }
            if (sectionTag.m_128456_()) continue;
            sectionTag.m_128344_("Y", (byte)i);
            sections.add((Object)sectionTag);
        }
        nbt.m_128365_("sections", (Tag)sections);
        if (chunk.m_6332_()) {
            nbt.m_128379_("isLightOn", true);
        }
        ListTag blockEntities = new ListTag();
        for (BlockPos blockpos : chunk.m_5928_()) {
            CompoundTag blockEntityTag = chunk.m_8051_(blockpos);
            if (blockEntityTag == null) continue;
            blockEntities.add((Object)blockEntityTag);
        }
        nbt.m_128365_("block_entities", (Tag)blockEntities);
        LevelChunk levelChunk = (LevelChunk)chunk;
        try {
            CompoundTag capTag = levelChunk.writeCapsToNBT();
            if (capTag != null) {
                nbt.m_128365_("ForgeCaps", (Tag)capTag);
            }
        }
        catch (Exception exception) {
            LOGGER.error("A capability provider has thrown an exception trying to write state. It will not persist. Report this to the mod author", (Throwable)exception);
        }
        LittleChunkSerializer.saveTicks((Level)level, nbt, chunk.m_183568_());
        CompoundTag heightmaps = new CompoundTag();
        for (Map.Entry entry : chunk.m_6890_()) {
            if (!chunk.m_6415_().m_62500_().contains(entry.getKey())) continue;
            heightmaps.m_128365_(((Heightmap.Types)entry.getKey()).m_64294_(), (Tag)new LongArrayTag(((Heightmap)entry.getValue()).m_64239_()));
        }
        nbt.m_128365_("Heightmaps", (Tag)heightmaps);
        MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Save(chunk, (LevelAccessor)level, nbt));
        return nbt;
    }

    private static void saveTicks(Level level, CompoundTag nbt, ChunkAccess.TicksToSave ticks) {
        long i = level.m_6106_().m_6793_();
        nbt.m_128365_("block_ticks", ticks.f_187680_().m_183237_(i, x -> BuiltInRegistries.f_256975_.m_7981_(x).toString()));
        nbt.m_128365_("fluid_ticks", ticks.f_187681_().m_183237_(i, x -> BuiltInRegistries.f_257020_.m_7981_(x).toString()));
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(LittleLevel level, CompoundTag nbt) {
        ListTag entities = LittleChunkSerializer.getListOfCompoundsOrNull(nbt, "entities");
        ListTag blockEntities = LittleChunkSerializer.getListOfCompoundsOrNull(nbt, "block_entities");
        return entities == null && blockEntities == null ? null : x -> {
            if (entities != null && level instanceof LittleServerLevel) {
                LittleServerLevel sLevel = (LittleServerLevel)level;
                sLevel.m_143311_(EntityType.m_147045_((List)entities, (Level)level.asLevel()));
            }
            if (blockEntities != null) {
                for (int i = 0; i < blockEntities.size(); ++i) {
                    CompoundTag blockTag = blockEntities.m_128728_(i);
                    if (blockTag.m_128471_("keepPacked")) {
                        x.m_5604_(blockTag);
                        continue;
                    }
                    BlockPos blockpos = BlockEntity.m_187472_((CompoundTag)blockTag);
                    BlockEntity blockentity = BlockEntity.m_155241_((BlockPos)blockpos, (BlockState)x.m_8055_(blockpos), (CompoundTag)blockTag);
                    if (blockentity == null) continue;
                    x.m_142169_(blockentity);
                }
            }
        };
    }

    @Nullable
    private static ListTag getListOfCompoundsOrNull(CompoundTag nbt, String key) {
        ListTag listtag = nbt.m_128437_(key, 10);
        return listtag.isEmpty() ? null : listtag;
    }
}

