/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.level.tick;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import team.creative.littletiles.common.level.handler.LevelHandler;
import team.creative.littletiles.common.level.tick.LittleTickTicket;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.schedule.ISignalSchedulable;

public class LittleTicker
extends LevelHandler
implements Iterable<LittleTickTicket> {
    private final HashSet<LittleStructure> updateStructures = new HashSet();
    private final HashSet<LittleStructure> tickingStructures = new HashSet();
    private boolean ticking = false;
    private final List<LittleStructure> queuedTickingStructures = new ArrayList<LittleStructure>();
    private List<ISignalSchedulable> signalChanged = new ArrayList<ISignalSchedulable>();
    public int tick = Integer.MIN_VALUE;
    public int latest = Integer.MIN_VALUE;
    public LittleTickTicket next;
    public LittleTickTicket last;
    public LittleTickTicket unused;

    public LittleTicker(Level level) {
        super(level);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected LittleTickTicket pollUnused() {
        if (this.unused == null) {
            return new LittleTickTicket();
        }
        LittleTickTicket result = this.unused;
        this.unused = result.next;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUpdate(LittleStructure structure) {
        if (structure.isClient()) {
            return;
        }
        HashSet<LittleStructure> hashSet = this.updateStructures;
        synchronized (hashSet) {
            this.updateStructures.add(structure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueNextTick(LittleStructure structure) {
        HashSet<LittleStructure> hashSet = this.tickingStructures;
        synchronized (hashSet) {
            if (this.ticking) {
                this.queuedTickingStructures.add(structure);
            } else {
                this.tickingStructures.add(structure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markSignalChanged(ISignalSchedulable schedulable) {
        List<ISignalSchedulable> list = this.signalChanged;
        synchronized (list) {
            this.signalChanged.add(schedulable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(int delay, Runnable run) {
        LittleTicker littleTicker = this;
        synchronized (littleTicker) {
            if (delay < 0) {
                run.run();
            }
            LittleTickTicket result = this.pollUnused();
            result.setup(delay + this.tick, run);
            if (this.latest < result.tickTime) {
                if (this.last != null) {
                    this.last.next = result;
                }
                this.last = result;
                this.latest = result.tickTime;
                return;
            }
            if (this.next.tickTime >= result.tickTime) {
                result.next = this.next;
                this.next = null;
                return;
            }
            LittleTickTicket current = this.next;
            while (current.next.tickTime <= result.tickTime) {
                current = current.next;
            }
            result.next = current.next;
            current.next = result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Iterable<LittleTickTicket> iterable = this;
        synchronized (iterable) {
            while (this.next != null && this.next.tickTime <= this.tick) {
                this.next.run();
                if (this.next == this.last) {
                    this.last = null;
                }
                LittleTickTicket temp = this.next;
                this.next = temp.next;
                if (this.unused != null) {
                    temp.next = this.unused;
                }
                this.unused = temp;
            }
            ++this.tick;
        }
        iterable = this.tickingStructures;
        synchronized (iterable) {
            if (!this.queuedTickingStructures.isEmpty()) {
                for (LittleStructure structure : this.queuedTickingStructures) {
                    this.tickingStructures.add(structure);
                }
                this.queuedTickingStructures.clear();
            }
            this.ticking = true;
            if (!this.tickingStructures.isEmpty()) {
                Iterator<LittleStructure> iterator = this.tickingStructures.iterator();
                while (iterator.hasNext()) {
                    LittleStructure structure;
                    structure = iterator.next();
                    if (structure.queuedTick()) continue;
                    iterator.remove();
                }
            }
            this.ticking = false;
        }
        if (!this.updateStructures.isEmpty()) {
            iterable = this.updateStructures;
            synchronized (iterable) {
                for (LittleStructure structure : this.updateStructures) {
                    structure.sendUpdatePacket();
                }
                this.updateStructures.clear();
            }
        }
        if (!this.signalChanged.isEmpty()) {
            iterable = this.signalChanged;
            synchronized (iterable) {
                for (ISignalSchedulable signal : this.signalChanged) {
                    try {
                        signal.updateSignaling();
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
                }
                this.signalChanged.clear();
            }
        }
    }

    @Override
    public Iterator<LittleTickTicket> iterator() {
        return new Iterator<LittleTickTicket>(){
            public LittleTickTicket next;
            {
                this.next = LittleTicker.this.next;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public LittleTickTicket next() {
                LittleTickTicket ticket = this.next;
                this.next = this.next.next;
                return ticket;
            }
        };
    }

    @Override
    public void unload() {
        super.unload();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }
}

