/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.box;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;
import team.creative.creativecore.common.util.math.geo.NormalPlane;
import team.creative.creativecore.common.util.math.geo.Ray3f;
import team.creative.creativecore.common.util.math.geo.VectorFan;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.utils.BooleanUtils;
import team.creative.creativecore.common.util.math.utils.IntegerUtils;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.client.render.tile.LittleRenderBoxTransformable;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.TransformableVoxelShape;
import team.creative.littletiles.common.math.box.volume.LittleBoxReturnedVolume;
import team.creative.littletiles.common.math.face.ILittleFace;
import team.creative.littletiles.common.math.face.LittleFace;
import team.creative.littletiles.common.math.face.LittleServerFace;
import team.creative.littletiles.common.math.vec.LittleRay;
import team.creative.littletiles.common.math.vec.LittleVec;

public class LittleTransformableBox
extends LittleBox {
    private static boolean[][] flipRotationMatrix = new boolean[][]{{false, false, false, false, true, true}, {false, false, false, false, true, true}, {true, true, false, false, false, false}, {true, true, false, false, false, false}, {true, true, true, true, true, true}, {true, true, true, true, true, true}};
    private static boolean[][] flipMirrorMatrix = new boolean[][]{{true, true, true, true, true, true}, {true, true, true, true, true, true}, {true, true, true, true, true, true}};
    private static final Vec3f ZERO = new Vec3f();
    protected static final int dataStartIndex = 0;
    protected static final int dataEndIndex = 23;
    protected static final int flipStartIndex = 24;
    protected static final int flipEndIndex = 29;
    private int[] data;
    private SoftReference<VectorFanCache> cache;

    protected static boolean[][] buildFlipRotationCache() {
        boolean[][] cache = new boolean[Rotation.values().length][Facing.values().length];
        AlignedBox box = new AlignedBox();
        Vec3f center = new Vec3f(0.5f, 0.5f, 0.5f);
        for (int i = 0; i < cache.length; ++i) {
            Rotation rotation = Rotation.values()[i];
            boolean[] flipped = cache[i];
            for (int j = 0; j < Facing.values().length; ++j) {
                Facing facing = Facing.values()[j];
                BoxFace face = BoxFace.get((Facing)facing);
                BoxCorner corner = face.getCornerInQuestion(false, false);
                Vec3f vec = box.getCorner(corner);
                vec.sub(center);
                rotation.transform(vec);
                vec.add(center);
                Facing rotatedFacing = rotation.rotate(facing);
                BoxFace rotatedFace = BoxFace.get((Facing)rotatedFacing);
                flipped[j] = !vec.epsilonEquals(box.getCorner(rotatedFace.getCornerInQuestion(false, false)), 1.0E-4f) && !vec.epsilonEquals(box.getCorner(rotatedFace.getCornerInQuestion(true, false)), 1.0E-4f);
            }
        }
        return cache;
    }

    protected static boolean[][] buildFlipMirrorCache() {
        boolean[][] cache = new boolean[Axis.values().length][Facing.values().length];
        AlignedBox box = new AlignedBox();
        Vec3f center = new Vec3f(0.5f, 0.5f, 0.5f);
        for (int i = 0; i < cache.length; ++i) {
            Axis axis = Axis.values()[i];
            boolean[] flipped = cache[i];
            for (int j = 0; j < Facing.values().length; ++j) {
                Facing facing = Facing.values()[j];
                BoxFace face = BoxFace.get((Facing)facing);
                BoxCorner corner = face.getCornerInQuestion(false, false);
                Vec3f vec = box.getCorner(corner);
                vec.sub(center);
                axis.mirror(vec);
                vec.add(center);
                Facing rotatedFacing = axis.mirror(facing);
                BoxFace rotatedFace = BoxFace.get((Facing)rotatedFacing);
                flipped[j] = !vec.epsilonEquals(box.getCorner(rotatedFace.getCornerInQuestion(false, false)), 1.0E-4f) && !vec.epsilonEquals(box.getCorner(rotatedFace.getCornerInQuestion(true, false)), 1.0E-4f);
            }
        }
        return cache;
    }

    public LittleTransformableBox(int[] data) {
        super(data[0], data[1], data[2], data[3], data[4], data[5]);
        this.data = Arrays.copyOfRange(data, 6, data.length);
    }

    public LittleTransformableBox(LittleBox box, int[] data) {
        super(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
        this.data = data;
    }

    @Override
    public VoxelShape getShape(LittleGrid grid) {
        return TransformableVoxelShape.create(this, grid, this.getBB(grid));
    }

    public int getIndicator() {
        return this.data[0];
    }

    public void setFlipped(int facing, boolean value) {
        this.data[0] = IntegerUtils.set((int)this.getIndicator(), (int)(24 + facing), (boolean)value);
        this.changed();
    }

    public boolean getFlipped(int facing) {
        return IntegerUtils.bitIs((int)this.getIndicator(), (int)(24 + facing));
    }

    public void setFlipped(Facing facing, boolean value) {
        this.data[0] = IntegerUtils.set((int)this.getIndicator(), (int)(24 + facing.ordinal()), (boolean)value);
        this.changed();
    }

    public boolean getFlipped(Facing facing) {
        return IntegerUtils.bitIs((int)this.getIndicator(), (int)(24 + facing.ordinal()));
    }

    public void setData(int[] data) {
        this.data = data;
        this.cache = null;
    }

    public void setData(int index, short value) {
        int realIndex = index / 2 + 1;
        this.data[realIndex] = index % 2 == 1 ? this.data[realIndex] & 0xFFFF0000 | value & 0xFFFF : value << 16 | this.data[realIndex] & 0xFFFF;
        this.changed();
    }

    public short getData(int index) {
        int realIndex = index / 2 + 1;
        if (index % 2 == 1) {
            return (short)(this.data[realIndex] & 0xFFFF);
        }
        return (short)(this.data[realIndex] >> 16 & 0xFFFF);
    }

    public Vec3f[] getTiltedCorners() {
        Vec3f[] corners = new Vec3f[BoxCorner.values().length];
        int indicator = this.getIndicator();
        int activeBits = 0;
        for (int i = 0; i < corners.length; ++i) {
            BoxCorner corner = BoxCorner.values()[i];
            short x = 0;
            short y = 0;
            short z = 0;
            int index = i * 3;
            if (IntegerUtils.bitIs((int)indicator, (int)index)) {
                x = this.getData(activeBits);
                ++activeBits;
            }
            if (IntegerUtils.bitIs((int)indicator, (int)(index + 1))) {
                y = this.getData(activeBits);
                ++activeBits;
            }
            if (IntegerUtils.bitIs((int)indicator, (int)(index + 2))) {
                z = this.getData(activeBits);
                ++activeBits;
            }
            corners[i] = new Vec3f((float)(x + this.get(corner.x)), (float)(y + this.get(corner.y)), (float)(z + this.get(corner.z)));
        }
        return corners;
    }

    @Override
    public void changed() {
        super.changed();
        this.cache = null;
    }

    private static boolean checkEqual(Vec3f[] corners, LittleVec[] otherCorners, BoxCorner[] toCheck, Axis axis) {
        block5: for (int j = 0; j < toCheck.length; ++j) {
            BoxCorner corner = toCheck[j];
            switch (axis) {
                case X: {
                    if (corners[corner.ordinal()].x == (float)otherCorners[corner.ordinal()].x) continue block5;
                    return false;
                }
                case Y: {
                    if (corners[corner.ordinal()].y == (float)otherCorners[corner.ordinal()].y) continue block5;
                    return false;
                }
                case Z: {
                    if (corners[corner.ordinal()].z == (float)otherCorners[corner.ordinal()].z) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    private static VectorFan createStrip(BoxCorner[] corners, Vec3f[] vec) {
        Vec3f[] coords = BoxFace.getVecArray((BoxCorner[])corners, (Vec3f[])vec);
        boolean invalid = false;
        for (int i = 0; i < coords.length - 1; ++i) {
            if (!coords[i].epsilonEquals(coords[i + 1], 1.0E-4f)) continue;
            invalid = true;
            break;
        }
        if (invalid) {
            if (coords.length == 3) {
                return null;
            }
            ArrayList<Vec3f> newCoords = new ArrayList<Vec3f>();
            for (int i = 0; i < coords.length - 1; ++i) {
                if (coords[i].epsilonEquals(coords[i + 1], 1.0E-4f)) continue;
                newCoords.add(coords[i]);
            }
            if (newCoords.size() < 3) {
                return null;
            }
            coords = newCoords.toArray(new Vec3f[newCoords.size()]);
        }
        return new VectorFan(coords);
    }

    public synchronized VectorFanCache requestCache() {
        BoxFace face;
        Facing facing;
        int i;
        VectorFanCache temp;
        if (this.cache != null && (temp = this.cache.get()) != null) {
            return temp;
        }
        NormalPlane[] planes = new NormalPlane[Facing.values().length];
        for (int i2 = 0; i2 < planes.length; ++i2) {
            Facing facing2 = Facing.values()[i2];
            Axis axis = facing2.axis;
            NormalPlane plane = new NormalPlane(new Vec3f(), new Vec3f());
            plane.origin.set(0.0f, 0.0f, 0.0f);
            plane.origin.set(axis, (float)this.get(facing2));
            plane.normal.set(0.0f, 0.0f, 0.0f);
            plane.normal.set(axis, (float)facing2.offset());
            planes[i2] = plane;
        }
        VectorFanCache cache = new VectorFanCache();
        NormalPlane[] tiltedPlanes = new NormalPlane[Facing.values().length * 2];
        Vec3f[] corners = this.getTiltedCorners();
        LittleVec[] boxCorners = this.getCorners();
        for (i = 0; i < Facing.values().length; ++i) {
            int j;
            VectorFanFaceCache faceCache;
            facing = Facing.values()[i];
            face = BoxFace.get((Facing)facing);
            boolean inverted = this.getFlipped(facing);
            cache.faces[i] = faceCache = new VectorFanFaceCache();
            BoxCorner[] first = face.getTriangleFirst(inverted);
            Vec3f firstNormal = BoxFace.getTraingleNormal((BoxCorner[])first, (Vec3f[])corners);
            boolean firstSame = LittleTransformableBox.checkEqual(corners, boxCorners, first, facing.axis);
            BoxCorner[] second = face.getTriangleSecond(inverted);
            Vec3f secondNormal = BoxFace.getTraingleNormal((BoxCorner[])second, (Vec3f[])corners);
            boolean secondSame = LittleTransformableBox.checkEqual(corners, boxCorners, second, facing.axis);
            if (firstSame && secondSame) continue;
            firstNormal.normalize();
            secondNormal.normalize();
            boolean parallel = firstNormal.epsilonEquals(secondNormal, 1.0E-4f);
            if (parallel) {
                if (!firstSame && !firstNormal.epsilonEquals(ZERO, 1.0E-4f)) {
                    faceCache.tiltedStrip1 = LittleTransformableBox.createStrip(face.corners, corners);
                    if (faceCache.tiltedStrip1 != null) {
                        tiltedPlanes[i * 2] = new NormalPlane(corners[first[0].ordinal()], firstNormal);
                    }
                }
            } else {
                if (!firstSame && !firstNormal.epsilonEquals(ZERO, 1.0E-4f)) {
                    faceCache.tiltedStrip1 = LittleTransformableBox.createStrip(first, corners);
                    if (faceCache.tiltedStrip1 != null) {
                        tiltedPlanes[i * 2] = new NormalPlane(corners[first[0].ordinal()], firstNormal);
                    }
                }
                if (!secondSame && !secondNormal.epsilonEquals(ZERO, 1.0E-4f)) {
                    faceCache.tiltedStrip2 = LittleTransformableBox.createStrip(second, corners);
                    if (faceCache.tiltedStrip2 != null) {
                        tiltedPlanes[i * 2 + 1] = new NormalPlane(corners[second[0].ordinal()], secondNormal);
                    }
                }
            }
            if (faceCache.tiltedStrip1 != null && faceCache.tiltedStrip2 != null) {
                for (j = 0; j < faceCache.tiltedStrip2.count(); ++j) {
                    Vec3f vec = faceCache.tiltedStrip2.get(j);
                    if (!BooleanUtils.isTrue((Boolean)tiltedPlanes[i * 2].isInFront(vec))) continue;
                    faceCache.convex = false;
                    break;
                }
            }
            for (j = 0; j < planes.length; ++j) {
                if (faceCache.tiltedStrip1 != null) {
                    faceCache.tiltedStrip1 = faceCache.tiltedStrip1.cut(planes[j]);
                }
                if (faceCache.tiltedStrip2 == null) continue;
                faceCache.tiltedStrip2 = faceCache.tiltedStrip2.cut(planes[j]);
            }
        }
        block4: for (i = 0; i < Facing.values().length; ++i) {
            facing = Facing.values()[i];
            face = BoxFace.get((Facing)facing);
            VectorFanFaceCache axisFaceCache = cache.faces[i];
            axisFaceCache.axisStrips.add(new VectorFan(this.getVecArray(face.corners)));
            for (int j = 0; j < Facing.values().length; ++j) {
                VectorFanFaceCache faceCache = cache.faces[j];
                if (faceCache.tiltedStrip1 == null && faceCache.tiltedStrip2 == null) {
                    cutPlane1 = tiltedPlanes[j * 2];
                    cutPlane2 = tiltedPlanes[j * 2 + 1];
                    if (faceCache.convex) {
                        if (cutPlane1 != null) {
                            axisFaceCache.cutAxisStrip(cutPlane1);
                        }
                        if (cutPlane2 != null) {
                            axisFaceCache.cutAxisStrip(cutPlane2);
                        }
                    } else {
                        axisFaceCache.cutAxisStrip(facing, cutPlane1, cutPlane2);
                    }
                } else {
                    cutPlane1 = null;
                    cutPlane2 = null;
                    if (!faceCache.convex || faceCache.tiltedStrip1 != null && faceCache.tiltedStrip2 != null) {
                        cutPlane1 = tiltedPlanes[j * 2];
                        cutPlane2 = tiltedPlanes[j * 2 + 1];
                    } else if (faceCache.tiltedStrip1 != null) {
                        cutPlane1 = tiltedPlanes[j * 2];
                    } else if (faceCache.tiltedStrip2 != null) {
                        cutPlane1 = tiltedPlanes[j * 2 + 1];
                    }
                    if (faceCache.convex) {
                        if (cutPlane1 != null) {
                            axisFaceCache.cutAxisStrip(cutPlane1);
                        }
                        if (cutPlane2 != null) {
                            axisFaceCache.cutAxisStrip(cutPlane2);
                        }
                    } else {
                        axisFaceCache.cutAxisStrip(facing, cutPlane1, cutPlane2);
                    }
                }
                if (!axisFaceCache.hasAxisStrip()) continue block4;
            }
        }
        this.cache = new SoftReference<VectorFanCache>(cache);
        return cache;
    }

    @Override
    public int[] getArray() {
        int[] array = new int[6 + this.data.length];
        array[0] = this.minX;
        array[1] = this.minY;
        array[2] = this.minZ;
        array[3] = this.maxX;
        array[4] = this.maxY;
        array[5] = this.maxZ;
        for (int i = 0; i < this.data.length; ++i) {
            array[i + 6] = this.data[i];
        }
        return array;
    }

    @Override
    public int getSmallest(LittleGrid grid) {
        int size = super.getSmallest(grid);
        Iterator<TransformablePoint> points = this.points();
        while (points.hasNext()) {
            size = Math.max(size, grid.getMinGrid(points.next().getRelative()));
        }
        return size;
    }

    @Override
    protected void scale(int ratio) {
        VectorFanCache temp;
        super.scale(ratio);
        Iterator<TransformablePoint> points = this.points();
        while (points.hasNext()) {
            TransformablePoint point = points.next();
            point.setRelative((short)(point.getRelative() * ratio));
        }
        if (this.cache != null && (temp = this.cache.get()) != null) {
            temp.scale(ratio);
        }
    }

    @Override
    protected void divide(int ratio) {
        VectorFanCache temp;
        super.divide(ratio);
        Iterator<TransformablePoint> points = this.points();
        while (points.hasNext()) {
            TransformablePoint point = points.next();
            point.setRelative((short)(point.getRelative() / ratio));
        }
        if (this.cache != null && (temp = this.cache.get()) != null) {
            temp.divide(ratio);
        }
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean doesFillEntireBlock(LittleGrid grid) {
        return false;
    }

    @Override
    public LittleBox combineBoxes(LittleBox box) {
        if (box instanceof LittleTransformableBox) {
            LittleTransformableBox result;
            Facing facing = box.sharedBoxFaceWithoutBounds(this);
            if (facing == null) {
                return null;
            }
            Iterator<TransformableVec> points = this.corners();
            Iterator<TransformableVec> otherPoints = ((LittleTransformableBox)box).corners();
            TransformableVec point = null;
            TransformableVec otherPoint = null;
            Axis one = facing.one();
            Axis two = facing.two();
            while (points.hasNext() || otherPoints.hasNext()) {
                point = points.hasNext() ? points.next() : null;
                otherPoint = otherPoints.hasNext() ? otherPoints.next() : null;
                while (point != null && (otherPoint == null || point.corner.ordinal() < otherPoint.corner.ordinal())) {
                    if (box.get(point.corner, one) != point.getAbsolute(one) || box.get(point.corner, two) != point.getAbsolute(two)) {
                        return null;
                    }
                    if (points.hasNext()) {
                        point = points.next();
                        continue;
                    }
                    point = null;
                }
                while (otherPoint != null && (point == null || point.corner.ordinal() > otherPoint.corner.ordinal())) {
                    if (this.get(otherPoint.corner, one) != otherPoint.getAbsolute(one) || this.get(otherPoint.corner, two) != otherPoint.getAbsolute(two)) {
                        return null;
                    }
                    if (otherPoints.hasNext()) {
                        otherPoint = otherPoints.next();
                        continue;
                    }
                    otherPoint = null;
                }
                if (point == null || otherPoint == null || point.getAbsolute(one) == otherPoint.getAbsolute(one) && point.getAbsolute(two) == otherPoint.getAbsolute(two)) continue;
                return null;
            }
            if (!this.requestCache().get(facing).equalAxisStrip(((LittleTransformableBox)box).requestCache().get(facing.opposite()), facing.axis)) {
                return null;
            }
            CornerCache cornerCache = new CornerCache(false);
            this.setAbsoluteCorners(cornerCache);
            LittleTransformableBox littleTransformableBox = (LittleTransformableBox)box;
            Objects.requireNonNull(littleTransformableBox);
            CornerCache otherCornerCache = littleTransformableBox.new CornerCache(false);
            ((LittleTransformableBox)box).setAbsoluteCorners(otherCornerCache);
            LittleRay ray = new LittleRay(new LittleVec(0, 0, 0), new LittleVec(0, 0, 0));
            LittleRay ray2 = new LittleRay(new LittleVec(0, 0, 0), new LittleVec(0, 0, 0));
            BoxCorner[] corners = BoxCorner.faceCorners((Facing)facing);
            for (int i = 0; i < corners.length; ++i) {
                BoxCorner corner = corners[i];
                BoxCorner otherCorner = corner.mirror(facing.axis);
                ray.set(cornerCache.getOrCreate(corner), cornerCache.getOrCreate(otherCorner));
                ray2.set(otherCornerCache.getOrCreate(corner), otherCornerCache.getOrCreate(otherCorner));
                if (!ray.parallel(ray2)) {
                    return null;
                }
                if (ray.direction.x != 0 || ray.direction.y != 0 || ray.direction.z != 0) continue;
                BoxCorner newCorner = otherCorner.mirror(one);
                ray.set(cornerCache.getOrCreate(corner), cornerCache.getOrCreate(newCorner));
                ray2.set(otherCornerCache.getOrCreate(corner), otherCornerCache.getOrCreate(newCorner));
                if (!ray.parallel(ray2)) {
                    return null;
                }
                newCorner = otherCorner.mirror(two);
                ray.set(cornerCache.getOrCreate(corner), cornerCache.getOrCreate(newCorner));
                ray2.set(otherCornerCache.getOrCreate(corner), otherCornerCache.getOrCreate(newCorner));
                if (ray.parallel(ray2)) continue;
                return null;
            }
            LittleTransformableBox littleTransformableBox2 = result = new LittleTransformableBox(new LittleBox(this, box), (int[])this.data.clone());
            Objects.requireNonNull(littleTransformableBox2);
            CornerCache cache = littleTransformableBox2.new CornerCache(false);
            ((LittleTransformableBox)box).setAbsoluteCornersTakeBounds(cache);
            this.setAbsoluteCornersTakeBounds(cache);
            result.data = cache.getData();
            return result;
        }
        LittleBox newBox = super.combine(box);
        if (newBox == null) {
            return null;
        }
        if (box.getClass() == LittleBox.class) {
            LittleTransformableBox test;
            LittleTransformableBox littleTransformableBox = test = new LittleTransformableBox(box, this.data);
            Objects.requireNonNull(littleTransformableBox);
            CornerCache cache = littleTransformableBox.new CornerCache(false);
            this.setAbsoluteCorners(cache);
            test.data = cache.getData();
            if (test.requestCache().isCompletelyFilled()) {
                LittleTransformableBox result;
                LittleTransformableBox littleTransformableBox3 = result = new LittleTransformableBox(newBox, this.data);
                Objects.requireNonNull(littleTransformableBox3);
                cache = littleTransformableBox3.new CornerCache(false);
                this.setAbsoluteCorners(cache);
                result.data = cache.getData();
                return result;
            }
        }
        return null;
    }

    @Override
    public boolean isFaceSolid(Facing facing) {
        return this.requestCache().get(facing).isCompletelyFilled();
    }

    @Override
    protected boolean intersectsWith(LittleBox box) {
        if (super.intersectsWith(box)) {
            if (box instanceof LittleTransformableBox) {
                return this.intersectsWith(((LittleTransformableBox)box).requestCache()) || ((LittleTransformableBox)box).intersectsWith(this.requestCache());
            }
            VectorFanCache ownCache = this.requestCache();
            for (int i = 0; i < ownCache.faces.length; ++i) {
                for (VectorFan fan : ownCache.faces[i]) {
                    for (int j = 0; j < fan.count(); ++j) {
                        if (!box.isVecInside(fan.get(j))) continue;
                        return true;
                    }
                }
            }
            VectorFanCache newCache = new VectorFanCache();
            for (int i = 0; i < newCache.faces.length; ++i) {
                Facing facing = Facing.values()[i];
                BoxFace face = BoxFace.get((Facing)facing);
                VectorFanFaceCache faceCache = new VectorFanFaceCache();
                faceCache.axisStrips.add(new VectorFan(box.getVecArray(face.corners)));
                newCache.faces[i] = faceCache;
            }
            return this.intersectsWith(newCache);
        }
        return false;
    }

    protected boolean intersectsWith(VectorFanCache cache) {
        VectorFanCache ownCache = this.requestCache();
        for (int i = 0; i < ownCache.faces.length; ++i) {
            VectorFanFaceCache face = ownCache.faces[i];
            VectorFanFaceCache otherFace = cache.faces[i];
            if (!face.hasAxisStrip() || !otherFace.hasAxisStrip()) continue;
            Facing facing = Facing.values()[i];
            Axis axis = facing.axis;
            Axis one = facing.one();
            Axis two = facing.two();
            for (VectorFan fan : face.axisStrips) {
                for (VectorFan fan2 : otherFace.axisStrips) {
                    if (fan.get(0).get(axis) != fan2.get(0).get(axis) || !fan.intersect2d(fan2, one, two, facing.positive)) continue;
                    return true;
                }
            }
        }
        ArrayList<List<NormalPlane>> shapes = new ArrayList<List<NormalPlane>>();
        shapes.add(new ArrayList());
        for (int i = 0; i < ownCache.faces.length; ++i) {
            VectorFanFaceCache face = ownCache.faces[i];
            if (face.hasTiltedStrip()) {
                NormalPlane plane2;
                NormalPlane plane1 = face.tiltedStrip1 != null ? face.tiltedStrip1.createPlane() : null;
                NormalPlane normalPlane = plane2 = face.tiltedStrip2 != null ? face.tiltedStrip2.createPlane() : null;
                if (face.convex) {
                    for (int j = 0; j < shapes.size(); ++j) {
                        if (plane1 != null) {
                            ((List)shapes.get(j)).add(plane1);
                        }
                        if (plane2 == null) continue;
                        ((List)shapes.get(j)).add(plane2);
                    }
                } else {
                    int sizeBefore = shapes.size();
                    for (int j = 0; j < sizeBefore; ++j) {
                        if (plane1 != null && plane2 != null) {
                            ArrayList<NormalPlane> newList = new ArrayList<NormalPlane>((Collection)shapes.get(j));
                            ((List)shapes.get(j)).add(plane1);
                            newList.add(plane2);
                            shapes.add(newList);
                            continue;
                        }
                        if (plane1 != null) {
                            ((List)shapes.get(j)).add(plane1);
                            continue;
                        }
                        if (plane2 == null) continue;
                        ((List)shapes.get(j)).add(plane2);
                    }
                }
            }
            if (!face.hasAxisStrip()) continue;
            for (int j = 0; j < shapes.size(); ++j) {
                Facing facing = Facing.values()[i];
                NormalPlane plane = new NormalPlane(new Vec3f(), new Vec3f());
                plane.origin.set(0.0f, 0.0f, 0.0f);
                plane.origin.set(facing.axis, (float)this.get(facing));
                plane.normal.set(0.0f, 0.0f, 0.0f);
                plane.normal.set(facing.axis, (float)facing.offset());
                ((List)shapes.get(j)).add(plane);
            }
        }
        return cache.isInside(shapes);
    }

    @Override
    public void rotate(Rotation rotation, LittleVec doubledCenter) {
        int i;
        CornerCache cache = new CornerCache(false);
        Iterator<TransformableVec> corners = this.corners();
        while (corners.hasNext()) {
            TransformableVec vec = corners.next();
            long tempX = vec.getAbsoluteX() * 2 - doubledCenter.x;
            long tempY = vec.getAbsoluteY() * 2 - doubledCenter.y;
            long tempZ = vec.getAbsoluteZ() * 2 - doubledCenter.z;
            LittleVec rotatedVec = new LittleVec(0, 0, 0);
            rotatedVec.x = (int)((rotation.getMatrix().getX(tempX, tempY, tempZ) + (long)doubledCenter.x) / 2L);
            rotatedVec.y = (int)((rotation.getMatrix().getY(tempX, tempY, tempZ) + (long)doubledCenter.y) / 2L);
            rotatedVec.z = (int)((rotation.getMatrix().getZ(tempX, tempY, tempZ) + (long)doubledCenter.z) / 2L);
            cache.setAbsolute(vec.corner.rotate(rotation), rotatedVec);
        }
        super.rotate(rotation, doubledCenter);
        this.data = cache.getData();
        boolean[] cachedFlipped = new boolean[6];
        for (i = 0; i < Facing.VALUES.length; ++i) {
            cachedFlipped[i] = this.getFlipped(i);
        }
        for (i = 0; i < Facing.VALUES.length; ++i) {
            Facing facing = rotation.rotate(Facing.get((int)i));
            if (flipRotationMatrix[rotation.ordinal()][i]) {
                this.setFlipped(facing.ordinal(), !cachedFlipped[i]);
                continue;
            }
            this.setFlipped(facing.ordinal(), cachedFlipped[i]);
        }
    }

    @Override
    public void mirror(Axis axis, LittleVec doubledCenter) {
        int i;
        CornerCache cache = new CornerCache(false);
        Iterator<TransformableVec> corners = this.corners();
        while (corners.hasNext()) {
            TransformableVec vec = corners.next();
            long tempX = vec.getAbsoluteX() * 2 - doubledCenter.x;
            long tempY = vec.getAbsoluteY() * 2 - doubledCenter.y;
            long tempZ = vec.getAbsoluteZ() * 2 - doubledCenter.z;
            LittleVec flippedVec = new LittleVec(0, 0, 0);
            switch (axis) {
                case X: {
                    tempX = -tempX;
                    break;
                }
                case Y: {
                    tempY = -tempY;
                    break;
                }
                case Z: {
                    tempZ = -tempZ;
                }
            }
            flippedVec.x = (int)((tempX + (long)doubledCenter.x) / 2L);
            flippedVec.y = (int)((tempY + (long)doubledCenter.y) / 2L);
            flippedVec.z = (int)((tempZ + (long)doubledCenter.z) / 2L);
            cache.setAbsolute(vec.corner.mirror(axis), flippedVec);
        }
        super.mirror(axis, doubledCenter);
        this.data = cache.getData();
        boolean[] cachedFlipped = new boolean[6];
        for (i = 0; i < Facing.VALUES.length; ++i) {
            cachedFlipped[i] = this.getFlipped(i);
        }
        for (i = 0; i < Facing.VALUES.length; ++i) {
            Facing facing = axis.mirror(Facing.get((int)i));
            if (flipMirrorMatrix[axis.ordinal()][i]) {
                this.setFlipped(facing.ordinal(), !cachedFlipped[i]);
                continue;
            }
            this.setFlipped(facing.ordinal(), cachedFlipped[i]);
        }
    }

    protected void setAbsoluteCorners(CornerCache cache) {
        int indicator = this.getIndicator();
        int activeBits = 0;
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner corner = BoxCorner.values()[i];
            short x = 0;
            short y = 0;
            short z = 0;
            int index = i * 3;
            if (IntegerUtils.bitIs((int)indicator, (int)index)) {
                x = this.getData(activeBits);
                ++activeBits;
            }
            if (IntegerUtils.bitIs((int)indicator, (int)(index + 1))) {
                y = this.getData(activeBits);
                ++activeBits;
            }
            if (IntegerUtils.bitIs((int)indicator, (int)(index + 2))) {
                z = this.getData(activeBits);
                ++activeBits;
            }
            cache.setAbsolute(corner, new LittleVec(x + this.get(corner.x), y + this.get(corner.y), z + this.get(corner.z)));
        }
    }

    protected void setAbsoluteCornersTakeBounds(CornerCache cache) {
        int indicator = this.getIndicator();
        int activeBits = 0;
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner corner = BoxCorner.values()[i];
            int index = i * 3;
            if (IntegerUtils.bitIs((int)indicator, (int)index)) {
                cache.setAbsolute(corner, Axis.X, this.getData(activeBits) + this.get(corner.x));
                ++activeBits;
            }
            if (IntegerUtils.bitIs((int)indicator, (int)(index + 1))) {
                cache.setAbsolute(corner, Axis.Y, this.getData(activeBits) + this.get(corner.y));
                ++activeBits;
            }
            if (!IntegerUtils.bitIs((int)indicator, (int)(index + 2))) continue;
            cache.setAbsolute(corner, Axis.Z, this.getData(activeBits) + this.get(corner.z));
            ++activeBits;
        }
    }

    @Override
    public LittleBox extractBox(int x, int y, int z, @Nullable LittleBoxReturnedVolume volume) {
        LittleTransformableBox box;
        LittleTransformableBox littleTransformableBox = box = this.copy();
        Objects.requireNonNull(littleTransformableBox);
        CornerCache cache = littleTransformableBox.new CornerCache(false);
        box.minX = x;
        box.minY = y;
        box.minZ = z;
        box.maxX = x + 1;
        box.maxY = y + 1;
        box.maxZ = z + 1;
        this.setAbsoluteCorners(cache);
        box.data = cache.getData();
        box.cache = null;
        if (!box.requestCache().isInvalid()) {
            if (box.requestCache().isCompletelyFilled()) {
                return new LittleBox(x, y, z, x + 1, y + 1, z + 1);
            }
            return box;
        }
        if (volume != null) {
            volume.addPixel();
        }
        return null;
    }

    @Override
    public LittleBox extractBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, @Nullable LittleBoxReturnedVolume volume) {
        LittleTransformableBox box;
        LittleTransformableBox littleTransformableBox = box = this.copy();
        Objects.requireNonNull(littleTransformableBox);
        CornerCache cache = littleTransformableBox.new CornerCache(false);
        box.minX = minX;
        box.minY = minY;
        box.minZ = minZ;
        box.maxX = maxX;
        box.maxY = maxY;
        box.maxZ = maxZ;
        this.setAbsoluteCorners(cache);
        box.data = cache.getData();
        box.cache = null;
        if (!box.requestCache().isInvalid()) {
            if (box.requestCache().isCompletelyFilled()) {
                return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
            }
            box.requestCache().setBounds(minX, minY, minZ, maxX, maxY, maxZ);
            box.data = cache.getData();
            if (volume != null) {
                volume.addDifBox(box, minX, minY, minZ, maxX, maxY, maxZ);
            }
            return box;
        }
        if (volume != null) {
            volume.addBox(minX, minY, minZ, maxX, maxY, maxZ);
        }
        return null;
    }

    @Override
    public LittleTransformableBox copy() {
        return new LittleTransformableBox((LittleBox)this, (int[])this.data.clone());
    }

    @Override
    public LittleBox grow(Facing facing) {
        LittleBox box = super.grow(facing);
        if (box != null) {
            return new LittleTransformableBox(box, this.data);
        }
        return null;
    }

    @Override
    public LittleBox shrink(Facing facing, boolean toLimit) {
        LittleBox box = super.shrink(facing, toLimit);
        if (box != null) {
            return new LittleTransformableBox(box, this.data);
        }
        return null;
    }

    protected Iterator<TransformableVec> corners() {
        return new Iterator<TransformableVec>(){
            int indicator;
            int corner;
            int activeBits;
            LittleVec vec;
            TransformableVec holder;
            {
                this.indicator = LittleTransformableBox.this.getIndicator();
                this.corner = -1;
                this.activeBits = 0;
                this.vec = new LittleVec(0, 0, 0);
                this.holder = new TransformableVec();
                this.findNext();
            }

            void findNext() {
                ++this.corner;
                while (this.corner < BoxCorner.values().length) {
                    short x = 0;
                    short y = 0;
                    short z = 0;
                    int index = this.corner * 3;
                    if (IntegerUtils.bitIs((int)this.indicator, (int)index)) {
                        x = LittleTransformableBox.this.getData(this.activeBits);
                        ++this.activeBits;
                    }
                    if (IntegerUtils.bitIs((int)this.indicator, (int)(index + 1))) {
                        y = LittleTransformableBox.this.getData(this.activeBits);
                        ++this.activeBits;
                    }
                    if (IntegerUtils.bitIs((int)this.indicator, (int)(index + 2))) {
                        z = LittleTransformableBox.this.getData(this.activeBits);
                        ++this.activeBits;
                    }
                    if (x != 0 || y != 0 || z != 0) {
                        this.vec.set(x, y, z);
                        return;
                    }
                    ++this.corner;
                }
                this.vec = null;
            }

            @Override
            public boolean hasNext() {
                return this.vec != null;
            }

            @Override
            public TransformableVec next() {
                if (this.holder == null) {
                    throw new NoSuchElementException();
                }
                TransformableVec toReturn = this.holder.set(this.activeBits, BoxCorner.values()[this.corner], this.vec.x, this.vec.y, this.vec.z);
                this.findNext();
                if (!this.hasNext()) {
                    this.holder = null;
                }
                return toReturn;
            }
        };
    }

    protected Iterator<TransformablePoint> points() {
        return new Iterator<TransformablePoint>(){
            int indicator;
            int corner;
            int axisIndex;
            int index;
            int activeBits;
            TransformablePoint point;
            {
                this.indicator = LittleTransformableBox.this.getIndicator();
                this.corner = 0;
                this.axisIndex = -1;
                this.index = -1;
                this.activeBits = -1;
                this.point = new TransformablePoint();
                this.findNext();
            }

            void inc() {
                ++this.axisIndex;
                ++this.index;
                if (this.axisIndex == 3) {
                    ++this.corner;
                    this.axisIndex = 0;
                }
            }

            void findNext() {
                this.inc();
                while (this.index < 24 && !IntegerUtils.bitIs((int)this.indicator, (int)this.index)) {
                    this.inc();
                }
                ++this.activeBits;
            }

            @Override
            public boolean hasNext() {
                return this.index < 24;
            }

            @Override
            public TransformablePoint next() {
                if (this.point == null) {
                    throw new NoSuchElementException();
                }
                TransformablePoint toReturn = this.point.set(this.corner * 3 + this.axisIndex, this.activeBits, Axis.values()[this.axisIndex], BoxCorner.values()[this.corner]);
                this.findNext();
                if (!this.hasNext()) {
                    this.point = null;
                }
                return toReturn;
            }
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleRenderBox getRenderingBox(LittleGrid grid) {
        return new LittleRenderBoxTransformable(grid, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleRenderBox getRenderingBox(LittleGrid grid, BlockState state) {
        return new LittleRenderBoxTransformable(grid, this, state);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleRenderBox getRenderingBox(LittleGrid grid, LittleElement element) {
        return new LittleRenderBoxTransformable(grid, this, element);
    }

    @Override
    public BlockHitResult rayTrace(LittleGrid grid, BlockPos pos, Vec3 vecA, Vec3 vecB) {
        VectorFanCache cache = this.requestCache();
        Vec3f start = new Vec3f((float)(vecA.f_82479_ - (double)pos.m_123341_()), (float)(vecA.f_82480_ - (double)pos.m_123342_()), (float)(vecA.f_82481_ - (double)pos.m_123343_()));
        Vec3f end = new Vec3f((float)(vecB.f_82479_ - (double)pos.m_123341_()), (float)(vecB.f_82480_ - (double)pos.m_123342_()), (float)(vecB.f_82481_ - (double)pos.m_123343_()));
        start.scale((double)grid.count);
        end.scale((double)grid.count);
        Ray3f ray = new Ray3f(start, end);
        vecA = vecA.m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        Vec3d startA = new Vec3d(vecA);
        Vec3d collision = null;
        Facing collided = null;
        for (int i = 0; i < Facing.values().length; ++i) {
            VectorFanFaceCache face = cache.get(Facing.values()[i]);
            for (VectorFan strip : face) {
                Vec3d temp = strip.calculateIntercept(ray);
                if (temp != null) {
                    temp.scale(grid.pixelLength);
                }
                if (temp == null || !LittleTransformableBox.isClosest(startA, collision, temp)) continue;
                collided = Facing.values()[i];
                collision = temp;
            }
        }
        if (collision == null) {
            return null;
        }
        return new BlockHitResult(collision.toVanilla().m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), collided.toVanilla(), pos, true);
    }

    @Override
    protected void fillAdvanced(ILittleFace face) {
        List<VectorFan> axis = this.requestCache().get((Facing)face.facing().opposite()).axisStrips;
        if (axis != null && !axis.isEmpty()) {
            face.cut(axis);
        }
    }

    @Override
    @Nullable
    public LittleFace generateFace(LittleGrid grid, Facing facing) {
        VectorFanFaceCache faceCache = this.requestCache().get(facing);
        if (faceCache.isCompletelyFilled()) {
            return super.generateFace(grid, facing);
        }
        if (faceCache.axisStrips.isEmpty()) {
            return null;
        }
        Axis one = facing.one();
        Axis two = facing.two();
        return new LittleFace(this, faceCache.axisStrips, faceCache.tilted(), grid, facing, this.getMin(one), this.getMin(two), this.getMax(one), this.getMax(two), facing.positive ? this.getMax(facing.axis) : this.getMin(facing.axis));
    }

    @Override
    @Nullable
    public boolean set(LittleServerFace face, LittleGrid grid, Facing facing) {
        if (this.requestCache().get((Facing)facing).axisStrips.isEmpty()) {
            return false;
        }
        return super.set(face, grid, facing);
    }

    @Override
    public void add(int x, int y, int z) {
        VectorFanCache temp;
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        if (this.cache != null && (temp = this.cache.get()) != null) {
            temp.add(x, y, z);
        }
    }

    @Override
    public void sub(int x, int y, int z) {
        VectorFanCache temp;
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX -= x;
        this.maxY -= y;
        this.maxZ -= z;
        if (this.cache != null && (temp = this.cache.get()) != null) {
            temp.sub(x, y, z);
        }
    }

    public class VectorFanCache {
        VectorFanFaceCache[] faces = new VectorFanFaceCache[6];

        public VectorFanFaceCache get(Facing facing) {
            return this.faces[facing.ordinal()];
        }

        public void add(float x, float y, float z) {
            for (int i = 0; i < this.faces.length; ++i) {
                this.faces[i].add(x, y, z);
            }
        }

        public void sub(float x, float y, float z) {
            for (int i = 0; i < this.faces.length; ++i) {
                this.faces[i].sub(x, y, z);
            }
        }

        public void scale(float ratio) {
            for (int i = 0; i < this.faces.length; ++i) {
                this.faces[i].scale(ratio);
            }
        }

        public boolean isCompletelyFilled() {
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i].isCompletelyFilled()) continue;
                return false;
            }
            return true;
        }

        public boolean isInvalid() {
            int count = 0;
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i].isInvalid()) continue;
                ++count;
            }
            return count < 3;
        }

        protected void divide(int ratio) {
            for (int i = 0; i < this.faces.length; ++i) {
                this.faces[i].divide(ratio);
            }
        }

        protected boolean intersects(NormalPlane plane1, NormalPlane plane2) {
            for (int i = 0; i < this.faces.length; ++i) {
                if (!this.faces[i].intersects(plane1, plane2)) continue;
                return true;
            }
            return false;
        }

        public boolean isInside(List<List<NormalPlane>> shapes) {
            int i;
            ArrayList<CenterPoint> centers = new ArrayList<CenterPoint>();
            centers.add(new CenterPoint());
            for (i = 0; i < this.faces.length; ++i) {
                if (!this.faces[i].isInside(shapes, centers)) continue;
                return true;
            }
            for (i = 0; i < centers.size(); ++i) {
                Vec3f center = ((CenterPoint)centers.get(i)).getCenter();
                for (int j = 0; j < shapes.size(); ++j) {
                    if (!this.isInside(shapes.get(j), center)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isInside(List<NormalPlane> shape, Vec3f vec) {
            for (int i = 0; i < shape.size(); ++i) {
                if (BooleanUtils.isFalse((Boolean)shape.get(i).isInFront(vec))) continue;
                return false;
            }
            return true;
        }

        protected void setBounds(int oldMinX, int oldMinY, int oldMinZ, int oldMaxX, int oldMaxY, int oldMaxZ) {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (int i = 0; i < this.faces.length; ++i) {
                for (VectorFan fan : this.faces[i]) {
                    for (int j = 0; j < fan.count(); ++j) {
                        Vec3f vec = fan.get(j);
                        minX = Math.min(minX, (int)Math.floor(vec.x));
                        minY = Math.min(minY, (int)Math.floor(vec.y));
                        minZ = Math.min(minZ, (int)Math.floor(vec.z));
                        maxX = Math.max(maxX, (int)Math.ceil(vec.x));
                        maxY = Math.max(maxY, (int)Math.ceil(vec.y));
                        maxZ = Math.max(maxZ, (int)Math.ceil(vec.z));
                    }
                }
            }
            minX = Math.max(minX, oldMinX);
            minY = Math.max(minY, oldMinY);
            minZ = Math.max(minZ, oldMinZ);
            maxX = Math.min(maxX, oldMaxX);
            maxY = Math.min(maxY, oldMaxY);
            maxZ = Math.min(maxZ, oldMaxZ);
            LittleTransformableBox.this.set(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public static class VectorFanFaceCache
    implements Iterable<VectorFan> {
        public boolean convex = true;
        public VectorFan tiltedStrip1;
        public VectorFan tiltedStrip2;
        public boolean completedFilled = true;
        public List<VectorFan> axisStrips = new ArrayList<VectorFan>();

        public boolean isInvalid() {
            return this.tiltedStrip1 == null && this.tiltedStrip2 == null && this.axisStrips.isEmpty();
        }

        public boolean isCompletelyFilled() {
            return this.completedFilled && !this.hasTiltedStrip();
        }

        public boolean hasTiltedStrip() {
            return this.tiltedStrip1 != null || this.tiltedStrip2 != null;
        }

        public boolean hasAxisStrip() {
            return !this.axisStrips.isEmpty();
        }

        public void cutAxisStrip(Facing facing, NormalPlane plane, NormalPlane plane2) {
            Axis one = facing.one();
            Axis two = facing.two();
            boolean inverse = facing.positive;
            ArrayList<VectorFan> newAxisStrips = new ArrayList<VectorFan>();
            for (int i = 0; i < this.axisStrips.size(); ++i) {
                VectorFan strip = this.axisStrips.get(i).cut(plane);
                VectorFan strip2 = this.axisStrips.get(i).cut(plane2);
                if (strip != null && strip2 != null && strip.intersect2d(strip2, one, two, inverse)) {
                    List fans = strip.cut2d(strip2, one, two, inverse, false);
                    newAxisStrips.add(strip2);
                    newAxisStrips.addAll(fans);
                    continue;
                }
                if (strip != null) {
                    newAxisStrips.add(strip);
                }
                if (strip2 == null) continue;
                newAxisStrips.add(strip2);
            }
            if (this.completedFilled) {
                this.completedFilled = newAxisStrips.size() == 1 && this.axisStrips.size() == 1 ? ((VectorFan)newAxisStrips.get(0)).equals((Object)this.axisStrips.get(0)) : false;
            }
            this.axisStrips = newAxisStrips;
        }

        public void cutAxisStrip(NormalPlane plane) {
            int i = 0;
            VectorFan before = null;
            if (this.completedFilled && this.axisStrips.size() == 1) {
                before = this.axisStrips.get(0).copy();
            }
            while (i < this.axisStrips.size()) {
                VectorFan strip = this.axisStrips.get(i).cut(plane);
                if (strip == null) {
                    this.axisStrips.remove(i);
                    continue;
                }
                this.axisStrips.set(i, strip);
                ++i;
            }
            if (this.completedFilled) {
                this.completedFilled = this.axisStrips.size() == 1 ? before.equals((Object)this.axisStrips.get(0)) : false;
            }
        }

        public boolean equalAxisStrip(VectorFanFaceCache cache, Axis toIgnore) {
            if (this.axisStrips.size() != cache.axisStrips.size() || this.axisStrips.size() != 1) {
                return false;
            }
            return this.axisStrips.get(0).equalsIgnoreOrder(cache.axisStrips.get(0), toIgnore);
        }

        public void add(float x, float y, float z) {
            if (this.tiltedStrip1 != null) {
                this.tiltedStrip1.move(x, y, z);
            }
            if (this.tiltedStrip2 != null) {
                this.tiltedStrip2.move(x, y, z);
            }
            for (int i = 0; i < this.axisStrips.size(); ++i) {
                this.axisStrips.get(i).move(x, y, z);
            }
        }

        public void sub(float x, float y, float z) {
            if (this.tiltedStrip1 != null) {
                this.tiltedStrip1.move(-x, -y, -z);
            }
            if (this.tiltedStrip2 != null) {
                this.tiltedStrip2.move(-x, -y, -z);
            }
            for (int i = 0; i < this.axisStrips.size(); ++i) {
                this.axisStrips.get(i).move(-x, -y, -z);
            }
        }

        public void scale(float ratio) {
            if (this.tiltedStrip1 != null) {
                this.tiltedStrip1.scale(ratio);
            }
            if (this.tiltedStrip2 != null) {
                this.tiltedStrip2.scale(ratio);
            }
            for (int i = 0; i < this.axisStrips.size(); ++i) {
                this.axisStrips.get(i).scale(ratio);
            }
        }

        public void divide(float ratio) {
            if (this.tiltedStrip1 != null) {
                this.tiltedStrip1.divide(ratio);
            }
            if (this.tiltedStrip2 != null) {
                this.tiltedStrip2.divide(ratio);
            }
            for (int i = 0; i < this.axisStrips.size(); ++i) {
                this.axisStrips.get(i).divide(ratio);
            }
        }

        public boolean intersects(NormalPlane plane1, NormalPlane plane2) {
            for (VectorFan fan : this) {
                if (!fan.intersects(plane1, plane2)) continue;
                return true;
            }
            return false;
        }

        public boolean isInside(List<List<NormalPlane>> shapes, List<CenterPoint> centers) {
            if (!this.convex) {
                int sizeBefore = centers.size();
                for (int i = 0; i < sizeBefore; ++i) {
                    CenterPoint first = centers.get(i);
                    CenterPoint second = first.copy();
                    if (this.tiltedStrip1 != null) {
                        first.add(this.tiltedStrip1);
                    }
                    if (this.tiltedStrip2 != null) {
                        second.add(this.tiltedStrip2);
                    }
                    centers.add(second);
                }
            }
            if (this.hasAxisStrip()) {
                for (int i = 0; i < centers.size(); ++i) {
                    for (int j = 0; j < this.axisStrips.size(); ++j) {
                        centers.get(i).add(this.axisStrips.get(j));
                    }
                }
            }
            for (VectorFan fan : this) {
                if (!fan.isInside(shapes)) continue;
                return true;
            }
            return false;
        }

        public Iterable<VectorFan> tilted() {
            return new Iterable<VectorFan>(){

                @Override
                public Iterator<VectorFan> iterator() {
                    return new Iterator<VectorFan>(){
                        int additionalCount;
                        int index;
                        {
                            this.additionalCount = (tiltedStrip1 != null ? 1 : 0) + (tiltedStrip2 != null ? 1 : 0);
                            this.index = 0;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.index < this.additionalCount;
                        }

                        @Override
                        public VectorFan next() {
                            VectorFan result;
                            int secondIndex = this.index;
                            if (secondIndex < this.additionalCount) {
                                result = secondIndex == 0 ? (tiltedStrip1 != null ? tiltedStrip1 : tiltedStrip2) : tiltedStrip2;
                            } else {
                                throw new RuntimeException("Missing next element in iterator");
                            }
                            ++this.index;
                            return result;
                        }
                    };
                }
            };
        }

        @Override
        public Iterator<VectorFan> iterator() {
            return new Iterator<VectorFan>(){
                int additionalCount;
                int index;
                {
                    this.additionalCount = (tiltedStrip1 != null ? 1 : 0) + (tiltedStrip2 != null ? 1 : 0);
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < axisStrips.size() + this.additionalCount;
                }

                @Override
                public VectorFan next() {
                    VectorFan result;
                    if (this.index < axisStrips.size()) {
                        result = axisStrips.get(this.index);
                    } else {
                        int secondIndex = this.index - axisStrips.size();
                        if (secondIndex < this.additionalCount) {
                            result = secondIndex == 0 ? (tiltedStrip1 != null ? tiltedStrip1 : tiltedStrip2) : tiltedStrip2;
                        } else {
                            throw new RuntimeException("Missing next element in iterator");
                        }
                    }
                    ++this.index;
                    return result;
                }
            };
        }
    }

    class TransformablePoint {
        int progressIndex;
        int index;
        Axis axis;
        BoxCorner corner;

        TransformablePoint() {
        }

        public TransformablePoint set(int progressIndex, int index, Axis axis, BoxCorner corner) {
            this.progressIndex = progressIndex;
            this.index = index;
            this.axis = axis;
            this.corner = corner;
            return this;
        }

        public int getProgressIndex() {
            return this.progressIndex;
        }

        public int getAbsolute() {
            return this.getRelative() + LittleTransformableBox.this.get(this.corner, this.axis);
        }

        public void setAbsolute(int value) {
            this.setRelative((short)(value - LittleTransformableBox.this.get(this.corner, this.axis)));
        }

        public short getRelative() {
            return LittleTransformableBox.this.getData(this.index);
        }

        public void setRelative(short value) {
            LittleTransformableBox.this.setData(this.index, value);
        }

        public String toString() {
            return this.corner + "," + this.axis + "," + this.getRelative();
        }
    }

    class TransformableVec {
        int index;
        BoxCorner corner;
        int x = 0;
        int y = 0;
        int z = 0;

        public int getAbsolute(Axis axis) {
            switch (axis) {
                case X: {
                    return this.getAbsoluteX();
                }
                case Y: {
                    return this.getAbsoluteY();
                }
                case Z: {
                    return this.getAbsoluteZ();
                }
            }
            return 0;
        }

        public int getAbsoluteX() {
            return LittleTransformableBox.this.get(this.corner, Axis.X) + this.x;
        }

        public int getAbsoluteY() {
            return LittleTransformableBox.this.get(this.corner, Axis.Y) + this.y;
        }

        public int getAbsoluteZ() {
            return LittleTransformableBox.this.get(this.corner, Axis.Z) + this.z;
        }

        public int getRelative(Axis axis) {
            switch (axis) {
                case X: {
                    return this.getRelativeX();
                }
                case Y: {
                    return this.getRelativeY();
                }
                case Z: {
                    return this.getRelativeZ();
                }
            }
            return 0;
        }

        public BoxCorner getCorner() {
            return this.corner;
        }

        public int getRelativeX() {
            return this.x;
        }

        public int getRelativeY() {
            return this.y;
        }

        public int getRelativeZ() {
            return this.z;
        }

        public TransformableVec set(int index, BoxCorner corner, int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.index = index;
            this.corner = corner;
            return this;
        }

        public String toString() {
            return "[" + this.x + "," + this.y + "," + this.z + "]";
        }
    }

    public class CornerCache {
        public final boolean relative;
        public LittleVec[] corners = new LittleVec[BoxCorner.values().length];

        public CornerCache(boolean relative) {
            this.relative = relative;
        }

        public LittleTransformableBox getBox() {
            return LittleTransformableBox.this;
        }

        public LittleVec getOrCreate(BoxCorner corner) {
            LittleVec vec = this.corners[corner.ordinal()];
            if (vec == null) {
                vec = this.relative ? new LittleVec(0, 0, 0) : LittleTransformableBox.this.get(corner);
                this.corners[corner.ordinal()] = vec;
            }
            return vec;
        }

        public void setAbsolute(BoxCorner corner, LittleVec vec) {
            this.corners[corner.ordinal()] = vec;
            if (this.relative) {
                vec.x -= LittleTransformableBox.this.get(corner, Axis.X);
                vec.y -= LittleTransformableBox.this.get(corner, Axis.Y);
                vec.z -= LittleTransformableBox.this.get(corner, Axis.Z);
            }
        }

        public void setAbsolute(BoxCorner corner, Axis axis, int value) {
            if (this.relative) {
                this.getOrCreate(corner).set(axis, value - LittleTransformableBox.this.get(corner, axis));
            } else {
                this.getOrCreate(corner).set(axis, value);
            }
        }

        public void setRelative(BoxCorner corner, LittleVec vec) {
            this.corners[corner.ordinal()] = vec;
            if (!this.relative) {
                vec.x += LittleTransformableBox.this.get(corner, Axis.X);
                vec.y += LittleTransformableBox.this.get(corner, Axis.Y);
                vec.z += LittleTransformableBox.this.get(corner, Axis.Z);
            }
        }

        public void setRelative(BoxCorner corner, Axis axis, int value) {
            if (this.relative) {
                this.getOrCreate(corner).set(axis, value);
            } else {
                this.getOrCreate(corner).set(axis, value + LittleTransformableBox.this.get(corner, axis));
            }
        }

        public int[] getData() {
            int indicator = Integer.MIN_VALUE | 0xBF000000 & this.getBox().getIndicator();
            ArrayList<Integer> data = new ArrayList<Integer>();
            for (int i = 0; i < this.corners.length; ++i) {
                LittleVec vec = this.corners[i];
                if (vec == null) continue;
                int index = i * 3;
                if (this.relative) {
                    if (vec.x != 0) {
                        indicator = IntegerUtils.set((int)indicator, (int)index);
                        data.add(vec.x);
                    }
                    if (vec.y != 0) {
                        indicator = IntegerUtils.set((int)indicator, (int)(index + 1));
                        data.add(vec.y);
                    }
                    if (vec.z == 0) continue;
                    indicator = IntegerUtils.set((int)indicator, (int)(index + 2));
                    data.add(vec.z);
                    continue;
                }
                BoxCorner corner = BoxCorner.values()[i];
                if (vec.x != LittleTransformableBox.this.get(corner, Axis.X)) {
                    indicator = IntegerUtils.set((int)indicator, (int)index);
                    data.add(vec.x - LittleTransformableBox.this.get(corner, Axis.X));
                }
                if (vec.y != LittleTransformableBox.this.get(corner, Axis.Y)) {
                    indicator = IntegerUtils.set((int)indicator, (int)(index + 1));
                    data.add(vec.y - LittleTransformableBox.this.get(corner, Axis.Y));
                }
                if (vec.z == LittleTransformableBox.this.get(corner, Axis.Z)) continue;
                indicator = IntegerUtils.set((int)indicator, (int)(index + 2));
                data.add(vec.z - LittleTransformableBox.this.get(corner, Axis.Z));
            }
            int[] array = new int[1 + (int)Math.ceil((double)data.size() / 2.0)];
            array[0] = indicator;
            for (int i = 0; i < array.length - 1; ++i) {
                int second = i * 2 + 1 < data.size() ? (Integer)data.get(i * 2 + 1) : 0;
                array[i + 1] = (short)((Integer)data.get(i * 2)).intValue() << 16 | (short)second & 0xFFFF;
            }
            return array;
        }
    }

    public static class CenterPoint {
        Vec3f vec = new Vec3f();
        int count = 0;

        public void add(Vec3f vec) {
            this.vec.add(vec);
            ++this.count;
        }

        public void add(VectorFan fan) {
            for (int i = 0; i < fan.count(); ++i) {
                this.add(fan.get(i));
            }
        }

        public Vec3f getCenter() {
            float multiplier = 1.0f / (float)this.count;
            Vec3f result = new Vec3f(this.vec);
            result.scale((double)multiplier);
            return result;
        }

        public CenterPoint copy() {
            CenterPoint point = new CenterPoint();
            point.vec = new Vec3f(this.vec);
            point.count = this.count;
            return point;
        }
    }
}

