/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.box.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.box.LittleBoxCombiner;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;

public final class LittleBoxesNoOverlap
extends LittleBoxes {
    protected HashMapList<BlockPos, LittleBox> blockMap = new HashMapList();
    protected HashMapList<BlockPos, LittleBox> tempMap = new HashMapList();
    protected List<LittleBox> cutOutTemp = new ArrayList<LittleBox>();

    public LittleBoxesNoOverlap(BlockPos pos, LittleGrid grid, HashMapList<BlockPos, LittleBox> map) {
        super(pos, grid);
        this.blockMap = map;
    }

    public LittleBoxesNoOverlap(BlockPos pos, LittleGrid grid) {
        super(pos, grid);
    }

    @Override
    public void add(LittleBox box) {
        this.tempMap.clear();
        box.split(this.grid, this.pos, LittleVec.ZERO, this.tempMap, null);
        for (Map.Entry entry : this.tempMap.entrySet()) {
            boolean missing;
            ArrayList<LittleBox> existingBoxes = this.blockMap.get((Object)((BlockPos)entry.getKey()));
            boolean bl = missing = existingBoxes == null;
            if (missing) {
                existingBoxes = new ArrayList<LittleBox>();
            }
            for (LittleBox splitted : (ArrayList)entry.getValue()) {
                this.cutOutTemp.clear();
                existingBoxes.addAll(splitted.cutOut(existingBoxes, this.cutOutTemp, null));
            }
            LittleBoxCombiner.combineLast(existingBoxes);
            if (!missing) continue;
            this.blockMap.add((Object)((BlockPos)entry.getKey()), existingBoxes);
        }
        this.tempMap.clear();
    }

    @Override
    public LittleBoxesNoOverlap copy() {
        return new LittleBoxesNoOverlap(this.pos, this.grid, (HashMapList<BlockPos, LittleBox>)new HashMapList(this.blockMap));
    }

    @Override
    public void convertTo(LittleGrid to) {
        for (LittleBox box : this.blockMap) {
            box.convertTo(this.grid, to);
        }
        this.grid = to;
    }

    @Override
    public int getSmallest() {
        int size = LittleGrid.min().count;
        for (LittleBox box : this.blockMap) {
            size = Math.max(size, box.getSmallest(this.grid));
        }
        return size;
    }

    @Override
    public void clear() {
        this.blockMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.blockMap.isEmpty();
    }

    @Override
    public int size() {
        return this.blockMap.sizeOfValues();
    }

    @Override
    public LittleBox getSurroundingBox() {
        if (this.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Map.Entry entry : this.blockMap.entrySet()) {
            int x = ((BlockPos)entry.getKey()).m_123341_() * this.grid.count;
            int y = ((BlockPos)entry.getKey()).m_123342_() * this.grid.count;
            int z = ((BlockPos)entry.getKey()).m_123343_() * this.grid.count;
            for (LittleBox box : (ArrayList)entry.getValue()) {
                minX = Math.min(minX, x + box.minX);
                minY = Math.min(minY, y + box.minY);
                minZ = Math.min(minZ, z + box.minZ);
                maxX = Math.max(maxX, x + box.maxX);
                maxY = Math.max(maxY, y + box.maxY);
                maxZ = Math.max(maxZ, z + box.maxZ);
            }
        }
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public HashMapList<BlockPos, LittleBox> generateBlockWise() {
        return this.blockMap;
    }

    public List<LittleBox> all() {
        ArrayList<LittleBox> boxes = new ArrayList<LittleBox>();
        LittleVec vec = new LittleVec(0, 0, 0);
        for (Map.Entry entry : this.blockMap.entrySet()) {
            vec.set(this.grid, (Vec3i)((BlockPos)entry.getKey()).m_121996_((Vec3i)this.pos));
            for (LittleBox box : (ArrayList)entry.getValue()) {
                LittleBox toAdd = box.copy();
                toAdd.add(vec);
                boxes.add(toAdd);
            }
        }
        return boxes;
    }

    @Override
    public void mirror(Axis axis, LittleBoxAbsolute absoluteBox) {
        this.sameGrid(absoluteBox, () -> {
            Iterable boxes = this.all();
            this.blockMap = new HashMapList();
            LittleVec center = absoluteBox.getDoubledCenter(this.pos);
            for (LittleBox box : boxes) {
                box.mirror(axis, center);
                this.add(box);
            }
        });
    }

    @Override
    public void combineBoxesBlocks() {
    }

    @Override
    public int littleVolume() {
        int volume = 0;
        for (ArrayList boxes : this.blockMap.values()) {
            for (LittleBox box : boxes) {
                volume += box.getVolume();
            }
        }
        return volume;
    }
}

