/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.vec;

import java.security.InvalidParameterException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VectorUtils;
import team.creative.littletiles.common.grid.LittleGrid;

public class LittleVec {
    public static final LittleVec ZERO = new LittleVec(0, 0, 0);
    public int x;
    public int y;
    public int z;

    public LittleVec(String name, CompoundTag nbt) {
        int[] array = nbt.m_128465_(name);
        if (array.length != 3) {
            throw new InvalidParameterException("No valid coords given " + nbt);
        }
        this.set(array[0], array[1], array[2]);
    }

    public LittleVec(LittleGrid grid, BlockHitResult result) {
        this(grid, result.m_82450_(), Facing.get((Direction)result.m_82434_()));
    }

    public LittleVec(LittleGrid grid, Vec3 vec, Facing facing) {
        this(grid, vec);
        if (facing.positive && !grid.isAtEdge(VectorUtils.get((Axis)facing.axis, (Vec3)vec))) {
            this.set(facing.axis, this.get(facing.axis) + 1);
        }
    }

    public LittleVec(LittleGrid grid, Vec3 vec) {
        this.x = grid.toGrid(vec.f_82479_);
        this.y = grid.toGrid(vec.f_82480_);
        this.z = grid.toGrid(vec.f_82481_);
    }

    public LittleVec(LittleGrid grid, Vec3d vec) {
        this.x = grid.toGrid(vec.x);
        this.y = grid.toGrid(vec.y);
        this.z = grid.toGrid(vec.z);
    }

    public LittleVec(LittleGrid grid, Vector3d vec) {
        this.x = grid.toGrid(vec.x);
        this.y = grid.toGrid(vec.y);
        this.z = grid.toGrid(vec.z);
    }

    public LittleVec(Facing facing) {
        switch (facing) {
            case EAST: {
                this.set(1, 0, 0);
                break;
            }
            case WEST: {
                this.set(-1, 0, 0);
                break;
            }
            case UP: {
                this.set(0, 1, 0);
                break;
            }
            case DOWN: {
                this.set(0, -1, 0);
                break;
            }
            case SOUTH: {
                this.set(0, 0, 1);
                break;
            }
            case NORTH: {
                this.set(0, 0, -1);
                break;
            }
            default: {
                this.set(0, 0, 0);
            }
        }
    }

    public LittleVec(int x, int y, int z) {
        this.set(x, y, z);
    }

    public LittleVec(LittleGrid grid, Vec3i vec) {
        this(grid.toGrid(vec.m_123341_()), grid.toGrid(vec.m_123342_()), grid.toGrid(vec.m_123343_()));
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(LittleGrid grid, Vec3i vec) {
        this.set(grid.toGrid(vec.m_123341_()), grid.toGrid(vec.m_123342_()), grid.toGrid(vec.m_123343_()));
    }

    public int getSmallest(LittleGrid grid) {
        int size = LittleGrid.min().count;
        size = Math.max(size, grid.getMinGrid(this.x));
        size = Math.max(size, grid.getMinGrid(this.y));
        size = Math.max(size, grid.getMinGrid(this.z));
        return size;
    }

    public void convertTo(LittleGrid from, LittleGrid to) {
        if (from.count > to.count) {
            int ratio = from.count / to.count;
            this.x /= ratio;
            this.y /= ratio;
            this.z /= ratio;
        } else {
            int ratio = to.count / from.count;
            this.x *= ratio;
            this.y *= ratio;
            this.z *= ratio;
        }
    }

    public BlockPos getBlockPos(LittleGrid grid) {
        return new BlockPos((int)Math.floor(grid.toVanillaGrid(this.x)), (int)Math.floor(grid.toVanillaGrid(this.y)), (int)Math.floor(grid.toVanillaGrid(this.z)));
    }

    public Vec3d getVec(LittleGrid grid) {
        return new Vec3d(grid.toVanillaGrid(this.x), grid.toVanillaGrid(this.y), grid.toVanillaGrid(this.z));
    }

    public Vec3 getVector(LittleGrid grid) {
        return new Vec3(grid.toVanillaGrid(this.x), grid.toVanillaGrid(this.y), grid.toVanillaGrid(this.z));
    }

    public double getPosX(LittleGrid grid) {
        return grid.toVanillaGrid(this.x);
    }

    public double getPosY(LittleGrid grid) {
        return grid.toVanillaGrid(this.y);
    }

    public double getPosZ(LittleGrid grid) {
        return grid.toVanillaGrid(this.z);
    }

    public void add(Facing facing) {
        this.set(facing.axis, this.get(facing.axis) + facing.offset());
    }

    public void add(LittleVec vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    public void add(BlockPos pos, LittleGrid grid) {
        this.x += grid.toGrid(pos.m_123341_());
        this.y += grid.toGrid(pos.m_123342_());
        this.z += grid.toGrid(pos.m_123343_());
    }

    public void sub(Facing facing) {
        this.set(facing.axis, this.get(facing.axis) - facing.offset());
    }

    public void sub(LittleVec vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
    }

    public void sub(BlockPos pos, LittleGrid grid) {
        this.x -= grid.toGrid(pos.m_123341_());
        this.y -= grid.toGrid(pos.m_123342_());
        this.z -= grid.toGrid(pos.m_123343_());
    }

    public void flip(Axis axis) {
        this.set(axis, -this.get(axis));
    }

    public void rotateVec(Rotation rotation) {
        int tempX = this.x;
        int tempY = this.y;
        int tempZ = this.z;
        this.x = rotation.getMatrix().getX(tempX, tempY, tempZ);
        this.y = rotation.getMatrix().getY(tempX, tempY, tempZ);
        this.z = rotation.getMatrix().getZ(tempX, tempY, tempZ);
    }

    public double distanceTo(LittleVec vec) {
        return Math.sqrt(Math.pow(vec.x - this.x, 2.0) + Math.pow(vec.y - this.y, 2.0) + Math.pow(vec.z - this.z, 2.0));
    }

    public boolean equals(Object object) {
        if (object instanceof LittleVec) {
            return this.x == ((LittleVec)object).x && this.y == ((LittleVec)object).y && this.z == ((LittleVec)object).z;
        }
        return super.equals(object);
    }

    public LittleVec copy() {
        return new LittleVec(this.x, this.y, this.z);
    }

    public void save(String name, CompoundTag nbt) {
        nbt.m_128385_(name, new int[]{this.x, this.y, this.z});
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public void invert() {
        this.set(-this.x, -this.y, -this.z);
    }

    public void scale(int factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void setX(int value) {
        this.x = value;
    }

    public void setY(int value) {
        this.y = value;
    }

    public void setZ(int value) {
        this.z = value;
    }

    public int get(Axis axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case Z: {
                return this.z;
            }
        }
        return 0;
    }

    public void set(Axis axis, int value) {
        switch (axis) {
            case X: {
                this.x = value;
                break;
            }
            case Y: {
                this.y = value;
                break;
            }
            case Z: {
                this.z = value;
            }
        }
    }

    public int getVolume() {
        return this.x * this.y * this.z;
    }

    public double getPercentVolume(LittleGrid context) {
        return (double)this.getVolume() / (double)context.count3d;
    }

    public LittleVec calculateInvertedCenter() {
        return new LittleVec((int)Math.ceil((double)this.x / 2.0), (int)Math.ceil((double)this.y / 2.0), (int)Math.ceil((double)this.z / 2.0));
    }

    public LittleVec calculateCenter() {
        return new LittleVec((int)Math.floor((double)this.x / 2.0), (int)Math.floor((double)this.y / 2.0), (int)Math.floor((double)this.z / 2.0));
    }

    public LittleVec max(LittleVec size) {
        this.x = Math.max(this.x, size.x);
        this.y = Math.max(this.y, size.y);
        this.z = Math.max(this.z, size.z);
        return this;
    }

    public Axis getLongestAxis() {
        if (Math.abs(this.x) > Math.abs(this.y)) {
            if (Math.abs(this.x) > Math.abs(this.z)) {
                return Axis.X;
            }
            return Axis.Z;
        }
        if (Math.abs(this.z) > Math.abs(this.y)) {
            return Axis.Z;
        }
        return Axis.Y;
    }
}

