/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement;

import team.creative.littletiles.common.action.LittleActionDestroyBoxes;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.ParentCollection;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.volume.LittleBoxReturnedVolume;
import team.creative.littletiles.common.placement.Placement;
import team.creative.littletiles.common.placement.PlacementResult;

public class PlacementContext {
    protected ParentCollection parent;
    public final Placement placement;
    public final Placement.PlacementBlock block;
    public final PlacementResult result;
    public final boolean collisionTest;

    public PlacementContext(Placement placement, Placement.PlacementBlock block, PlacementResult result, boolean collisionTest) {
        this.placement = placement;
        this.block = block;
        this.result = result;
        this.collisionTest = collisionTest;
    }

    public BETiles getBE() {
        return this.block.getBE();
    }

    public boolean isSpaceFor(LittleBox box) {
        return this.getBE().isSpaceFor(box);
    }

    public ParentCollection getParent() {
        return this.parent;
    }

    public void setParent(ParentCollection parent) {
        this.parent = parent;
    }

    public void addRemoved(LittleTile tile) {
        this.placement.removedTiles.add(this.parent, tile);
    }

    public boolean removeTile(LittleTile tile) {
        boolean changed = false;
        LittleBoxReturnedVolume volume = new LittleBoxReturnedVolume();
        for (LittleBox box : tile) {
            for (LittleTile removedTile : LittleActionDestroyBoxes.removeBox(this.block.getBE(), this.parent.getGrid(), box, false, volume)) {
                this.addRemoved(removedTile);
                changed = true;
            }
            if (volume.has()) {
                this.placement.addRemovedIngredient(this.block, tile, volume);
            }
            volume.clear();
        }
        this.getBE().convertTo(this.block.getGrid());
        return changed;
    }

    public void addUnplaceable(LittleElement element, LittleBox box) {
        this.placement.unplaceableTiles.add(this.parent.getGrid(), element, box);
    }

    public void placeTile(LittleTile tile) {
        this.parent.add(tile.copy());
        this.result.addPlacedTile(this.parent, tile);
    }
}

