/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.mark;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.GuiMarkMode;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mark.IMarkMode;

@OnlyIn(value=Dist.CLIENT)
public class MarkMode
implements IMarkMode {
    public PlacementPosition position = null;
    public boolean allowLowResolution = true;

    public static PlacementPosition loadPosition(PlacementPosition position, PlacementPreview preview) {
        return position;
    }

    public MarkMode(Player player, PlacementPosition position, PlacementPreview preview) {
        this.position = MarkMode.loadPosition(position, preview);
    }

    @Override
    public boolean allowLowResolution() {
        return this.allowLowResolution;
    }

    @Override
    public GuiConfigure getConfigurationGui() {
        return new GuiMarkMode(this);
    }

    @Override
    public PlacementPosition getPosition() {
        return this.position.copy();
    }

    @Override
    public void render(LittleGrid positionGrid, PoseStack pose) {
        Minecraft mc = Minecraft.m_91087_();
        AABB box = this.position.getBox(positionGrid).m_82400_(0.002);
        VertexConsumer consumer = mc.m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        RenderSystem.m_69832_((float)4.0f);
        LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)consumer, (AABB)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.m_69832_((float)1.0f);
        LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)consumer, (AABB)box, (float)1.0f, (float)0.3f, (float)0.0f, (float)1.0f);
    }

    @Override
    public void move(LittleGrid positionGrid, Facing facing) {
        LittleVec vec = new LittleVec(facing.opposite());
        vec.scale(Screen.m_96637_() ? positionGrid.count : 1);
        this.position.sub(new LittleVecGrid(vec, positionGrid));
    }

    @Override
    public void done() {
    }
}

