/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.VectorUtils;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleTransformableBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeSelection;

public class LittleShapeSlice
extends LittleShape {
    public LittleShapeSlice() {
        super(2);
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        LittleTransformableBox box;
        LittleTransformableBox littleTransformableBox = box = new LittleTransformableBox(selection.getOverallBox(), new int[1]);
        Objects.requireNonNull(littleTransformableBox);
        LittleTransformableBox.CornerCache cache = littleTransformableBox.new LittleTransformableBox.CornerCache(false);
        Vec3i vec = this.getVec(selection.getNBT());
        Facing facing = this.getFacing(selection.getNBT());
        Axis axis = facing.axis;
        if (facing.positive != VectorUtils.get((Axis)axis, (Vec3i)vec) > 0) {
            facing = Facing.get((Axis)axis, (VectorUtils.get((Axis)axis, (Vec3i)vec) > 0 ? 1 : 0) != 0);
        }
        Facing x = vec.m_123341_() > 0 ? Facing.EAST : Facing.WEST;
        Facing y = vec.m_123342_() > 0 ? Facing.UP : Facing.DOWN;
        Facing z = vec.m_123343_() > 0 ? Facing.SOUTH : Facing.NORTH;
        BoxCorner corner = BoxCorner.getCorner((Facing)x, (Facing)y, (Facing)z);
        cache.setAbsolute(corner, axis, box.get(facing.opposite()));
        cache.setAbsolute(corner.mirror(facing.axis), axis, box.get(facing.opposite()));
        box.setData(cache.getData());
        boxes.add(box);
    }

    public Vec3i getVec(CompoundTag nbt) {
        int[] array;
        if (nbt.m_128441_("vec") && (array = nbt.m_128465_("vec")).length == 3) {
            return new Vec3i(array[0], array[1], array[2]);
        }
        return new Vec3i(1, 1, 1);
    }

    public Facing getFacing(CompoundTag nbt) {
        if (nbt.m_128441_("direction")) {
            return Facing.values()[nbt.m_128451_("direction")];
        }
        return Facing.UP;
    }

    public void setFacing(CompoundTag nbt, Facing facing) {
        nbt.m_128405_("direction", facing.ordinal());
    }

    public void setVec(CompoundTag nbt, Vec3i vec) {
        nbt.m_128385_("vec", new int[]{vec.m_123341_(), vec.m_123342_(), vec.m_123343_()});
    }

    @Override
    public void addExtraInformation(CompoundTag nbt, List<Component> list) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<GuiControl> getCustomSettings(CompoundTag nbt, LittleGrid grid) {
        return new ArrayList<GuiControl>();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void saveCustomSettings(GuiParent gui, CompoundTag nbt, LittleGrid grid) {
    }

    @Override
    public void rotate(CompoundTag nbt, Rotation rotation) {
        this.setVec(nbt, rotation.transform(this.getVec(nbt)));
        this.setFacing(nbt, rotation.rotate(this.getFacing(nbt)));
    }

    @Override
    public void mirror(CompoundTag nbt, Axis axis) {
        this.setVec(nbt, axis.mirror(this.getVec(nbt)));
        this.setFacing(nbt, axis.mirror(this.getFacing(nbt)));
    }
}

