/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.item.ItemPremadeStructure;

public class StructureIngredient
extends Ingredient {
    public final String structureType;

    protected StructureIngredient(String structureType) {
        super(Stream.empty());
        this.structureType = structureType;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack.m_41720_() instanceof ItemMultiTiles) {
            return ItemMultiTiles.getStructure(stack).equals(this.structureType);
        }
        if (stack.m_41720_() instanceof ItemPremadeStructure) {
            return ItemPremadeStructure.getPremadeId(stack).equals(this.structureType);
        }
        return false;
    }

    public static class StructureIngredientSerializer
    implements IIngredientSerializer<StructureIngredient> {
        public static final StructureIngredientSerializer INSTANCE = new StructureIngredientSerializer();

        public StructureIngredient parse(FriendlyByteBuf buffer) {
            return this.create(buffer.m_130277_());
        }

        public StructureIngredient parse(JsonObject json) {
            if (json.has("structure")) {
                return this.create(json.get("structure").getAsString());
            }
            throw new JsonSyntaxException("Missing 'structure' type!");
        }

        public StructureIngredient create(String id) {
            return new StructureIngredient(id);
        }

        public void write(FriendlyByteBuf buffer, StructureIngredient ingredient) {
            buffer.m_130070_(ingredient.structureType);
        }
    }
}

